/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WanderingFireflyParticle
extends TextureSheetParticle {
    private final int halfLife;
    private final boolean fromJar;

    public WanderingFireflyParticle(ClientLevel level, double posX, double posY, double posZ, float movementX, float movementY, float movementZ, double additionalX, double additionalY, double additionalZ, SpriteSet set, boolean fromJar) {
        super(level, posX, posY, posZ, 0.0, 0.0, 0.0);
        this.f_107215_ *= (double)movementX;
        this.f_107216_ *= (double)movementY;
        this.f_107217_ *= (double)movementZ;
        this.f_107215_ += additionalX;
        this.f_107216_ += additionalY;
        this.f_107217_ += additionalZ;
        this.f_107227_ = 0.9f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 0.0f;
        this.m_108335_(set);
        this.f_107663_ = 0.2f + this.f_107223_.nextFloat() * 0.1f;
        this.f_107225_ = 30 + this.f_107223_.nextInt(21);
        this.halfLife = this.f_107225_ / 2;
        this.f_172259_ = true;
        this.f_107219_ = true;
        this.fromJar = fromJar;
    }

    public void m_5989_() {
        if (!this.fromJar && this.f_107208_.m_45517_(LightLayer.SKY, new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_)) < 1) {
            this.m_107274_();
        }
        super.m_5989_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer buffer, Camera entity, float partialTicks) {
        this.f_107230_ = this.getGlowBrightness();
        super.m_5744_(buffer, entity, partialTicks);
    }

    public float getGlowBrightness() {
        int lifeTime = this.f_107225_ - this.f_107224_;
        if (lifeTime <= this.halfLife) {
            return (float)lifeTime / (float)this.halfLife;
        }
        return Math.max(1.0f - ((float)lifeTime - (float)this.halfLife) / (float)this.halfLife, 0.0f);
    }

    public int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FromJarFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FromJarFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Random rand = world.f_46441_;
            double speedX = (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            double speedY = (double)rand.nextFloat() * -0.25 * (double)rand.nextFloat() * 0.1;
            double speedZ = (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            return new WanderingFireflyParticle(world, x, y, z, 0.1f, 0.1f, 0.1f, speedX, speedY, speedZ, this.spriteSet, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Random rand = world.f_46441_;
            double speedX = (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            double speedY = (double)rand.nextFloat() * -0.25 * (double)rand.nextFloat() * 0.1;
            double speedZ = (double)rand.nextFloat() * (rand.nextBoolean() ? -3.9 : 3.9) * (double)rand.nextFloat() * 0.1;
            return new WanderingFireflyParticle(world, x, y, z, 0.1f, 0.1f, 0.1f, speedX, speedY, speedZ, this.spriteSet, false);
        }
    }
}

