/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.UncraftingGui;
import twilightforest.compat.JEIUncraftingCategory;
import twilightforest.compat.ie.IEShaderRegister;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.inventory.UncraftingContainer;
import twilightforest.item.recipe.TFRecipes;

@JeiPlugin
public class JEI
implements IModPlugin {
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(UncraftingContainer.class, RecipeTypes.CRAFTING, 11, 9, 20, 36);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
        if (ModList.get().isLoaded("immersiveengineering")) {
            ShaderRegistry.rarityWeightMap.keySet().forEach(rarity -> ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(((Item)ForgeRegistries.ITEMS.getValue(TwilightForestMod.prefix("shader_bag_" + rarity))).m_7968_())));
            for (ShaderRegistry.ShaderRegistryEntry entry : IEShaderRegister.getAllTwilightShaders()) {
                ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(TwilightForestMod.prefix("shader")));
                ItemNBTHelper.putString((ItemStack)stack, (String)"shader_name", (String)entry.getName().toString());
                ingredientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(stack));
            }
        }
    }

    public ResourceLocation getPluginUid() {
        return TwilightForestMod.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIUncraftingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List recipes = manager.m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44107_);
        recipes.removeIf(recipe -> recipe.m_8043_().m_41619_() || recipe.m_8043_().m_204117_(ItemTagGenerator.BANNED_UNCRAFTABLES) || ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get()).contains(recipe.m_6423_().toString()) || ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()).booleanValue() != ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get()).contains(recipe.m_6423_().m_135827_()));
        recipes.addAll(manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TFRecipes.UNCRAFTING_RECIPE.get()));
        registration.addRecipes(JEIUncraftingCategory.UNCRAFTING, recipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(UncraftingGui.class, 34, 33, 27, 20, new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
        registration.addRecipeClickArea(UncraftingGui.class, 115, 33, 27, 20, new RecipeType[]{RecipeTypes.CRAFTING});
    }
}

