/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.entity.ITFCharger;
import twilightforest.entity.boss.Minoshroom;
import twilightforest.util.EntityUtil;

public class ChargeAttackGoal
extends Goal {
    private static final double MIN_RANGE_SQ = 16.0;
    private static final double MAX_RANGE_SQ = 64.0;
    private static final int FREQ = 10;
    private final PathfinderMob charger;
    private LivingEntity chargeTarget;
    private Vec3 chargePos;
    protected float speed;
    private final boolean canBreak;
    private int windup;
    private boolean hasAttacked;

    public ChargeAttackGoal(PathfinderMob mob, float f, boolean canBreak) {
        this.charger = mob;
        this.speed = f;
        this.canBreak = canBreak;
        this.windup = 0;
        this.hasAttacked = false;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        double minoshroomBonus;
        this.chargeTarget = this.charger.m_5448_();
        if (this.chargeTarget == null) {
            return false;
        }
        double distance = this.charger.m_20280_((Entity)this.chargeTarget);
        double d = minoshroomBonus = this.charger instanceof Minoshroom ? 9.0 : 0.0;
        if (distance < 16.0 + minoshroomBonus || distance > 64.0 + minoshroomBonus) {
            return false;
        }
        if (!this.charger.m_20096_()) {
            return false;
        }
        Vec3 chargePos = this.findChargePoint((Entity)this.charger, (Entity)this.chargeTarget);
        boolean canSeeTargetFromDest = this.charger.m_21574_().m_148306_((Entity)this.chargeTarget);
        if (!canSeeTargetFromDest) {
            return false;
        }
        this.chargePos = chargePos;
        return this.charger.m_21187_().nextInt(10) == 0;
    }

    public void m_8056_() {
        this.windup = 15 + this.charger.m_21187_().nextInt(30);
        this.charger.m_6858_(true);
    }

    public boolean m_8045_() {
        return this.windup > 0 || !this.charger.m_21573_().m_26571_();
    }

    public void m_8037_() {
        double rangeSq;
        block6: {
            block4: {
                block5: {
                    this.charger.m_21563_().m_24950_(this.chargePos.m_7096_(), this.chargePos.m_7098_() - 1.0, this.chargePos.m_7094_(), 10.0f, (float)this.charger.m_8132_());
                    if (this.windup <= 0) break block4;
                    if (--this.windup != 0) break block5;
                    this.charger.m_21573_().m_26519_(this.chargePos.m_7096_(), this.chargePos.m_7098_(), this.chargePos.m_7094_(), (double)this.speed);
                    break block6;
                }
                this.charger.f_20924_ = (float)((double)this.charger.f_20924_ + 0.8);
                PathfinderMob pathfinderMob = this.charger;
                if (!(pathfinderMob instanceof ITFCharger)) break block6;
                ITFCharger chargeMob = (ITFCharger)pathfinderMob;
                chargeMob.setCharging(true);
                break block6;
            }
            if (this.canBreak && !this.charger.m_183503_().m_5776_() && ForgeEventFactory.getMobGriefingEvent((Level)this.charger.m_183503_(), (Entity)this.charger)) {
                AABB bb = this.charger.m_142469_();
                int minx = Mth.m_14107_((double)(bb.f_82288_ - 0.75));
                int miny = Mth.m_14107_((double)(bb.f_82289_ + 0.0));
                int minz = Mth.m_14107_((double)(bb.f_82290_ - 0.75));
                int maxx = Mth.m_14107_((double)(bb.f_82291_ + 0.75));
                int maxy = Mth.m_14107_((double)(bb.f_82292_ + 0.15));
                int maxz = Mth.m_14107_((double)(bb.f_82293_ + 0.75));
                BlockPos min = new BlockPos(minx, miny, minz);
                BlockPos max = new BlockPos(maxx, maxy, maxz);
                if (this.charger.m_183503_().m_46832_(min, max)) {
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                        if (!EntityUtil.canDestroyBlock(this.charger.m_183503_(), pos, (Entity)this.charger) || this.charger.m_183503_().m_7702_(pos) != null) continue;
                        this.charger.m_183503_().m_46961_(pos, true);
                    }
                }
            }
        }
        double d = rangeSq = this.charger instanceof Minoshroom ? 5.0 : (double)(this.charger.m_20205_() * 2.0f * this.charger.m_20205_() * 2.0f + this.chargeTarget.m_20205_());
        if (this.charger.m_20275_(this.chargeTarget.m_20185_(), this.chargeTarget.m_142469_().f_82289_, this.chargeTarget.m_20189_()) <= rangeSq && !this.hasAttacked) {
            this.hasAttacked = true;
            this.charger.m_7327_((Entity)this.chargeTarget);
        }
    }

    public void m_8041_() {
        this.windup = 0;
        this.chargeTarget = null;
        this.hasAttacked = false;
        this.charger.m_6858_(false);
        PathfinderMob pathfinderMob = this.charger;
        if (pathfinderMob instanceof ITFCharger) {
            ITFCharger chargeMob = (ITFCharger)pathfinderMob;
            chargeMob.setCharging(false);
        }
    }

    protected Vec3 findChargePoint(Entity attacker, Entity target) {
        double vecx = target.m_20185_() - attacker.m_20185_();
        double vecz = target.m_20189_() - attacker.m_20189_();
        float rangle = (float)Math.atan2(vecz, vecx);
        double distance = Mth.m_14116_((float)((float)(vecx * vecx + vecz * vecz)));
        double overshoot = 2.1;
        double dx = (double)Mth.m_14089_((float)rangle) * (distance + overshoot);
        double dz = (double)Mth.m_14031_((float)rangle) * (distance + overshoot);
        return new Vec3(attacker.m_20185_() + dx, target.m_20186_(), attacker.m_20189_() + dz);
    }
}

