/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.TFEntities;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.util.TFDamageSources;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class NatureBolt
extends TFThrowable
implements ITFProjectile,
ItemSupplier {
    public NatureBolt(EntityType<? extends NatureBolt> type, Level world) {
        super(type, world);
    }

    public NatureBolt(Level world, LivingEntity owner) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.NATURE_BOLT.get()), world, owner);
    }

    public void m_8119_() {
        super.m_8119_();
        this.makeTrail();
    }

    protected float m_7139_() {
        return 0.003f;
    }

    private void makeTrail() {
        for (int i = 0; i < 5; ++i) {
            double dx = this.m_20185_() + 0.5 * (this.f_19796_.nextDouble() - this.f_19796_.nextDouble());
            double dy = this.m_20186_() + 0.5 * (this.f_19796_.nextDouble() - this.f_19796_.nextDouble());
            double dz = this.m_20189_() + 0.5 * (this.f_19796_.nextDouble() - this.f_19796_.nextDouble());
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50050_.m_49966_()), false, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.nextGaussian() * 0.05, this.f_19796_.nextDouble() * 0.2, this.f_19796_.nextGaussian() * 0.05);
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_6532_(HitResult ray) {
        if (!this.f_19853_.f_46443_) {
            if (ray.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPosHit = ((BlockHitResult)ray).m_82425_();
                Material materialHit = this.f_19853_.m_8055_(blockPosHit).m_60767_();
                if (materialHit == Material.f_76315_) {
                    ItemStack dummy = new ItemStack((ItemLike)Items.f_42499_, 1);
                    if (BoneMealItem.m_40627_((ItemStack)dummy, (Level)this.f_19853_, (BlockPos)blockPosHit)) {
                        this.f_19853_.m_46796_(2005, blockPosHit, 0);
                    }
                } else if (materialHit.m_76333_() && this.canReplaceBlock(this.f_19853_, blockPosHit)) {
                    this.f_19853_.m_46597_(blockPosHit, Blocks.f_50052_.m_49966_());
                }
            }
            if (ray instanceof EntityHitResult) {
                Entity owner = this.m_37282_();
                Entity entityHit = ((EntityHitResult)ray).m_82443_();
                if (entityHit instanceof LivingEntity && (owner == null || entityHit != owner && entityHit != owner.m_20202_()) && entityHit.m_6469_(TFDamageSources.leafBrain((Entity)this, (LivingEntity)this.m_37282_()), 2.0f) && this.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
                    int poisonTime = this.f_19853_.m_46791_() == Difficulty.HARD ? 7 : 3;
                    ((LivingEntity)entityHit).m_7292_(new MobEffectInstance(MobEffects.f_19614_, poisonTime * 20, 0));
                }
            }
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    private boolean canReplaceBlock(Level world, BlockPos pos) {
        float hardness = world.m_8055_(pos).m_60800_((BlockGetter)world, pos);
        return hardness >= 0.0f && hardness < 50.0f;
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42404_);
    }
}

