/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import twilightforest.IMCHandler;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.util.FeatureLogic;
import twilightforest.world.components.feature.config.SpikeConfig;

public class BlockSpikeFeature
extends Feature<SpikeConfig> {
    private static final List<StalactiteEntry> largeHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> mediumHillStalactites = new ArrayList<StalactiteEntry>();
    private static final List<StalactiteEntry> smallHillStalactites = new ArrayList<StalactiteEntry>();

    public BlockSpikeFeature(Codec<SpikeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SpikeConfig> context) {
        Random random = context.m_159776_();
        return BlockSpikeFeature.startSpike(context.m_159774_(), context.m_159777_(), (SpikeConfig)context.m_159778_(), random);
    }

    public static boolean startSpike(WorldGenLevel level, BlockPos startPos, SpikeConfig config, Random random) {
        return BlockSpikeFeature.startSpike(level, startPos, config.blockState, config.lengthBounds.m_142270_(random), config.lengthBounds.m_142739_(), config.tipClearance.m_142270_(random), config.hang, random);
    }

    public static boolean startSpike(WorldGenLevel level, BlockPos startPos, BlockStateProvider blockState, int length, int lengthMinimum, int clearance, boolean hang, Random random) {
        BlockPos.MutableBlockPos movingPos = startPos.m_122032_();
        int clearedLength = 0;
        int dY = hang ? -1 : 1;
        int i = 0;
        while (i < length) {
            clearedLength = i++;
            if (FeatureLogic.worldGenReplaceable(level.m_8055_((BlockPos)movingPos))) break;
            movingPos.m_122184_(0, dY, 0);
        }
        movingPos.m_122184_(0, dY, 0);
        int remainingScanLength = length - clearedLength + clearance;
        int finalLength = clearedLength - clearance;
        for (int i2 = 0; i2 < remainingScanLength; ++i2) {
            finalLength = clearedLength + i2;
            if (!FeatureLogic.worldGenReplaceable(level.m_8055_((BlockPos)movingPos))) break;
            movingPos.m_122184_(0, dY, 0);
        }
        if ((finalLength = Math.min(length, finalLength)) < lengthMinimum) {
            return false;
        }
        return BlockSpikeFeature.makeSpike(level, startPos, blockState, finalLength, dY, random, hang);
    }

    private static boolean makeSpike(WorldGenLevel level, BlockPos startPos, BlockStateProvider blockState, int length, int dY, Random random, boolean hang) {
        int diameter = (int)((float)length / 4.5f);
        if (!hang && !FeatureLogic.worldGenReplaceable(level.m_8055_(startPos.m_7495_()))) {
            return false;
        }
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int absz;
                int absx = Math.abs(dx);
                int dist = (int)((float)Math.max(absx, absz = Math.abs(dz)) + (float)Math.min(absx, absz) * 0.5f);
                int spikeLength = dist <= 0 ? length : random.nextInt((int)((float)length / ((float)dist + 0.25f)));
                for (int i = -1; i < spikeLength; ++i) {
                    BlockPos placement = startPos.m_142082_(dx, i * dY, dz);
                    if (!FeatureLogic.worldGenReplaceable(level.m_8055_(placement)) || dY <= 0 && placement.m_123342_() >= level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, placement.m_123341_(), placement.m_123343_()) - 1) continue;
                    level.m_7731_(placement, blockState.m_7112_(random, placement), 3);
                }
            }
        }
        return true;
    }

    public static SpikeConfig makeRandomOreStalactite(Random rand, int hillSize) {
        if (hillSize >= 3 || hillSize >= 2 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)((Object)WeightedRandom.m_146317_((Random)rand, BlockSpikeFeature.largeHillStalactites).get())).stalactite;
        }
        if (hillSize >= 2 || hillSize >= 1 && rand.nextInt(5) == 0) {
            return ((StalactiteEntry)((Object)WeightedRandom.m_146317_((Random)rand, BlockSpikeFeature.mediumHillStalactites).get())).stalactite;
        }
        return ((StalactiteEntry)((Object)WeightedRandom.m_146317_((Random)rand, BlockSpikeFeature.smallHillStalactites).get())).stalactite;
    }

    public static void registerStalactite(int hillSize, BlockState blockState, float size, int maxLength, int minHeight, int itemWeight) {
        if (itemWeight > 0) {
            BlockSpikeFeature.registerStalactite(hillSize, new StalactiteEntry(blockState, size, maxLength, itemWeight));
        }
    }

    private static void registerStalactite(int hillSize, StalactiteEntry entry) {
        if (hillSize <= 1) {
            smallHillStalactites.add(entry);
        }
        if (hillSize <= 2) {
            mediumHillStalactites.add(entry);
        }
        largeHillStalactites.add(entry);
    }

    private static void addDefaultStalactites() {
        BlockSpikeFeature.registerStalactite(3, Blocks.f_50089_.m_49966_(), 0.5f, 4, 16, 30);
        BlockSpikeFeature.registerStalactite(3, Blocks.f_50059_.m_49966_(), 0.8f, 8, 1, 30);
        BlockSpikeFeature.registerStalactite(3, Blocks.f_50264_.m_49966_(), 0.5f, 3, 12, 15);
        BlockSpikeFeature.registerStalactite(2, Blocks.f_49995_.m_49966_(), 0.6f, 6, 1, 20);
        BlockSpikeFeature.registerStalactite(2, Blocks.f_50173_.m_49966_(), 0.8f, 8, 1, 40);
        BlockSpikeFeature.registerStalactite(1, Blocks.f_49996_.m_49966_(), 0.7f, 8, 1, 24);
        BlockSpikeFeature.registerStalactite(1, Blocks.f_49997_.m_49966_(), 0.8f, 12, 1, 24);
        BlockSpikeFeature.registerStalactite(1, Blocks.f_152505_.m_49966_(), 0.6f, 12, 1, 12);
        BlockSpikeFeature.registerStalactite(1, Blocks.f_50141_.m_49966_(), 0.5f, 8, 1, 12);
    }

    public static void loadStalactites() {
        smallHillStalactites.clear();
        mediumHillStalactites.clear();
        largeHillStalactites.clear();
        TFConfig.COMMON_CONFIG.DIMENSION.hollowHillStalactites.load();
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.hollowHillStalactites.useConfigOnly.get()).booleanValue()) {
            if (smallHillStalactites.isEmpty()) {
                TwilightForestMod.LOGGER.info("Not all hollow hills are populated with the config, adding fallback");
                BlockSpikeFeature.registerStalactite(1, Blocks.f_50069_.m_49966_(), 0.7f, 8, 1, 1);
            }
            return;
        }
        BlockSpikeFeature.addDefaultStalactites();
        IMCHandler.getStalactites().forEach(BlockSpikeFeature::registerStalactite);
    }

    public static class StalactiteEntry
    extends WeightedEntry.IntrusiveBase {
        final SpikeConfig stalactite;

        StalactiteEntry(SpikeConfig stalactite, int itemWeight) {
            super(itemWeight);
            this.stalactite = stalactite;
        }

        public StalactiteEntry(BlockState blockState, float size, int maxLength, int itemWeight) {
            this(new SpikeConfig((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)blockState), (IntProvider)UniformInt.m_146622_((int)((int)((float)maxLength * size)), (int)maxLength), (IntProvider)ConstantInt.m_146483_((int)4), true), itemWeight);
        }
    }
}

