/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import twilightforest.enums.StructureWoodVariant;
import twilightforest.util.ArrayUtil;
import twilightforest.world.registration.TFStructureProcessors;

public final class CobblePlankSwizzler
extends StructureProcessor {
    private final StructureWoodVariant OAK_SWIZZLE;
    private final StructureWoodVariant SPRUCE_SWIZZLE;
    private final StructureWoodVariant BIRCH_SWIZZLE;
    public static final Codec<CobblePlankSwizzler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)StructureWoodVariant.values().length).fieldOf("oak_to_type").orElse((Object)0).forGetter(s -> s.OAK_SWIZZLE.ordinal()), (App)Codec.intRange((int)0, (int)StructureWoodVariant.values().length).fieldOf("spruce_to_type").orElse((Object)1).forGetter(s -> s.SPRUCE_SWIZZLE.ordinal()), (App)Codec.intRange((int)0, (int)StructureWoodVariant.values().length).fieldOf("birch_to_type").orElse((Object)2).forGetter(s -> s.BIRCH_SWIZZLE.ordinal())).apply((Applicative)instance, CobblePlankSwizzler::new));

    private CobblePlankSwizzler(int oakSwizzle, int spruceSwizzle, int birchSwizzle) {
        this.OAK_SWIZZLE = ArrayUtil.wrapped(StructureWoodVariant.values(), oakSwizzle);
        this.SPRUCE_SWIZZLE = ArrayUtil.wrapped(StructureWoodVariant.values(), spruceSwizzle);
        this.BIRCH_SWIZZLE = ArrayUtil.wrapped(StructureWoodVariant.values(), birchSwizzle);
    }

    public CobblePlankSwizzler(Random random) {
        this.OAK_SWIZZLE = StructureWoodVariant.getRandomWeighted(random);
        this.SPRUCE_SWIZZLE = StructureWoodVariant.getRandomWeighted(random);
        this.BIRCH_SWIZZLE = StructureWoodVariant.getRandomWeighted(random);
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader worldIn, BlockPos pos, BlockPos piecepos, StructureTemplate.StructureBlockInfo p_215194_3_, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        BlockState state = blockInfo.f_74676_;
        Block block = state.m_60734_();
        StructureWoodVariant type = StructureWoodVariant.getVariantFromBlock(block);
        if (type != null) {
            return switch (type) {
                case StructureWoodVariant.OAK -> new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_, StructureWoodVariant.modifyBlockWithType(state, this.OAK_SWIZZLE), null);
                case StructureWoodVariant.SPRUCE -> new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_, StructureWoodVariant.modifyBlockWithType(state, this.SPRUCE_SWIZZLE), null);
                case StructureWoodVariant.BIRCH -> new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_, StructureWoodVariant.modifyBlockWithType(state, this.BIRCH_SWIZZLE), null);
                default -> blockInfo;
            };
        }
        return blockInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)TFStructureProcessors.COBBLE_PLANK_SWIZZLER.get();
    }
}

