/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.block.TFBlocks;
import twilightforest.world.components.feature.config.SpikeConfig;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.registration.TFFeature;

public class YetiCaveComponent
extends HollowHillComponent {
    private static final SpikeConfig BLUE_ICE_SPIKE = new SpikeConfig((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50568_.m_49966_()), (IntProvider)UniformInt.m_146622_((int)8, (int)8), (IntProvider)ConstantInt.m_146483_((int)4), true);
    private static final SpikeConfig PACKED_ICE_SPIKE = new SpikeConfig((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50354_.m_49966_()), (IntProvider)UniformInt.m_146622_((int)5, (int)9), (IntProvider)ConstantInt.m_146483_((int)4), true);
    private static final SpikeConfig ICE_SPIKE = new SpikeConfig((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50126_.m_49966_()), (IntProvider)UniformInt.m_146622_((int)6, (int)10), (IntProvider)ConstantInt.m_146483_((int)4), true);

    public YetiCaveComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(TFFeature.TFYeti, nbt);
    }

    public YetiCaveComponent(TFFeature feature, Random rand, int i, int x, int y, int z) {
        super(TFFeature.TFYeti, feature, i, 2, x, y, z);
    }

    @Override
    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        int sn = 64;
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, BLUE_ICE_SPIKE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, PACKED_ICE_SPIKE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, ICE_SPIKE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, STONE_STALACTITE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb);
        }
        BlockState yetiSpawner = ((Block)TFBlocks.ALPHA_YETI_BOSS_SPAWNER.get()).m_49966_();
        this.setBlockStateRotated(world, yetiSpawner, this.radius, 1, this.radius, Rotation.NONE, sbb);
    }

    @Override
    boolean isInHill(int cx, int cz) {
        return cx < this.radius * 2 && cx > 0 && cz < this.radius * 2 && cz > 0;
    }

    @Override
    BlockPos.MutableBlockPos randomCeilingCoordinates(Random rand, float maximumRadius) {
        int rad = (int)maximumRadius;
        int x = rand.nextInt(rad * 2) - rad;
        int z = rand.nextInt(rad * 2) - rad;
        int dist = Math.min(Math.abs(x), Math.abs(z));
        return new BlockPos.MutableBlockPos(this.radius + x, 17 - dist / 6, this.radius + z);
    }
}

