/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import twilightforest.TwilightForestMod;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.Kobold;
import twilightforest.util.IntPair;
import twilightforest.util.PlayerHelper;
import twilightforest.world.components.structures.HedgeMazeComponent;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.HydraLairComponent;
import twilightforest.world.components.structures.QuestGrove;
import twilightforest.world.components.structures.YetiCaveComponent;
import twilightforest.world.components.structures.courtyard.CourtyardMain;
import twilightforest.world.components.structures.darktower.DarkTowerMainComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleMainComponent;
import twilightforest.world.components.structures.icetower.IceTowerMainComponent;
import twilightforest.world.components.structures.lichtower.TowerMainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRuinsComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerMainComponent;
import twilightforest.world.components.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;
import twilightforest.world.components.structures.trollcave.TrollCavePieces;
import twilightforest.world.registration.biomes.BiomeKeys;

public class TFFeature {
    public static final TFFeature NOTHING = new TFFeature(0, "no_feature", false, new ResourceLocation[0]){
        {
            this.enableDecorations().disableStructure();
        }
    };
    public static final TFFeature SMALL_HILL = new TFFeature(1, "small_hollow_hill", true, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.f_20479_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20501_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SWARM_SPIDER.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 4, 8);
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x - 3, y - 2, z - 3);
        }
    };
    public static final TFFeature MEDIUM_HILL = new TFFeature(2, "medium_hollow_hill", true, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP_SAPPER.get()), 1, 1, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 4, 8).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SWARM_SPIDER.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20479_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.FIRE_BEETLE.get()), 5, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 5, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1);
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x - 7, y - 5, z - 7);
        }
    };
    public static final TFFeature LARGE_HILL = new TFFeature(3, "large_hollow_hill", true, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP_SAPPER.get()), 2, 1, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20554_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 1, 1, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.WRAITH.get()), 2, 1, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.FIRE_BEETLE.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.PINCH_BEETLE.get()), 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1);
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x - 11, y - 5, z - 11);
        }
    };
    public static final TFFeature HEDGE_MAZE = new TFFeature(2, "hedge_maze", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new HedgeMazeComponent(this, 0, x + 1, y + 4, z + 1);
        }
    };
    public static final TFFeature QUEST_GROVE = new TFFeature(1, "quest_grove", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new QuestGrove(structureManager, new BlockPos(x - 12, y, z - 12));
        }
    };
    public static final TFFeature NAGA_COURTYARD = new TFFeature(3, "naga_courtyard", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new CourtyardMain(this, rand, 0, x + 1, y + 1, z + 1, structureManager);
        }
    };
    public static final TFFeature LICH_TOWER = new TFFeature(1, "lich_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_naga")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.f_20501_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 1, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 1, 1, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.DEATH_TOME.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1);
            this.adjustToTerrainHeight = true;
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.lichtower", 4);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on a Pointy Tower"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new TowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature HYDRA_LAIR = new TFFeature(2, "hydra_lair", true, true, new ResourceLocation[]{TwilightForestMod.prefix("progress_labyrinth")}){
        {
            this.enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.hydralair", 4);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on the Fire Swamp"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new HydraLairComponent(this, rand, 0, x - 7, y, z - 7);
        }
    };
    public static final TFFeature LABYRINTH = new TFFeature(3, "labyrinth", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.MINOTAUR.get()), 20, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20554_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.MAZE_SLIME.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 1, 1, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.FIRE_BEETLE.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.PINCH_BEETLE.get()), 10, 2, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.labyrinth", 5);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on a Swampy Labyrinth"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new MazeRuinsComponent(this, 0, x, y, z);
        }

        @Override
        public GenerationStep.Decoration getDecorationStage() {
            return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
        }
    };
    public static final TFFeature DARK_TOWER = new TFFeature(1, "dark_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_knights")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_GOLEM.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 2, 1, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_GHASTLING.get()), 10, 1, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_BROODLING.get()), 10, 8, 8).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.PINCH_BEETLE.get()), 10, 2, 4).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_GHASTGUARD.get()), 10, 1, 4).addWaterCreature((EntityType<? extends LivingEntity>)EntityType.f_20480_, 10, 4, 4);
            this.adjustToTerrainHeight = true;
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.darktower", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on a Wooden Tower"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new DarkTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature KNIGHT_STRONGHOLD = new TFFeature(3, "knight_stronghold", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_trophy_pedestal")}){
        {
            this.enableDecorations().disableProtectionAura();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.BLOCKCHAIN_GOBLIN.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.LOWER_GOBLIN_KNIGHT.get()), 5, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.HELMET_CRAB.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP_SAPPER.get()), 2, 1, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 4, 8).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20526_, 5, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.tfstronghold", 5);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on a Stronghold"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new StrongholdEntranceComponent(this, 0, x, y + 5, z);
        }

        @Override
        public GenerationStep.Decoration getDecorationStage() {
            return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
        }
    };
    public static final TFFeature YETI_CAVE = new TFFeature(2, "yeti_lairs", true, true, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.YETI.get()), 10, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.yeticave", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on an Icy Cave"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new YetiCaveComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature ICE_TOWER = new TFFeature(2, "ice_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_yeti")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SNOW_GUARDIAN.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.STABLE_ICE_CORE.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.UNSTABLE_ICE_CORE.get()), 5, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.icetower", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on Auroral Fortification"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new IceTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature TROLL_CAVE = new TFFeature(4, "troll_lairs", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_merge")}){
        {
            this.enableDecorations().enableTerrainAlterations().disableProtectionAura();
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 5, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.TROLL.get()), 20, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 5, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.GIANT_MINER.get()), 10, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.ARMORED_GIANT.get()), 10, 1, 1);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListTag bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.trollcave", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)TFFeature.BOOK_AUTHOR));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on the Highlands"));
        }

        @Override
        public GenerationStep.Decoration getDecorationStage() {
            return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new TrollCaveMainComponent(TrollCavePieces.TFTCMai, this, 0, x, y, z);
        }
    };
    public static final TFFeature FINAL_CASTLE = new TFFeature(4, "final_castle", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_troll")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.ADHERENT.get()), 10, 1, 1).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.HARBINGER_CUBE.get()), 10, 1, 1).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 10, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 4, 4).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.ADHERENT.get()), 10, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.HARBINGER_CUBE.get()), 10, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.ARMORED_GIANT.get()), 10, 1, 1).addMonster(2, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.ADHERENT.get()), 10, 1, 1).addMonster(3, (EntityType<? extends LivingEntity>)EntityType.f_20551_, 10, 1, 1);
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new FinalCastleMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature MUSHROOM_TOWER = new TFFeature(2, "mushroom_tower", true, new ResourceLocation[0]){
        {
            this.disableStructure();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
            return new MushroomTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature QUEST_ISLAND = new TFFeature(1, "quest_island", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    };
    private static final Map<ResourceLocation, TFFeature> BIOME_FEATURES = new ImmutableMap.Builder().put((Object)BiomeKeys.DARK_FOREST.m_135782_(), (Object)KNIGHT_STRONGHOLD).put((Object)BiomeKeys.DARK_FOREST_CENTER.m_135782_(), (Object)DARK_TOWER).put((Object)BiomeKeys.ENCHANTED_FOREST.m_135782_(), (Object)QUEST_GROVE).put((Object)BiomeKeys.FINAL_PLATEAU.m_135782_(), (Object)FINAL_CASTLE).put((Object)BiomeKeys.FIRE_SWAMP.m_135782_(), (Object)HYDRA_LAIR).put((Object)BiomeKeys.GLACIER.m_135782_(), (Object)ICE_TOWER).put((Object)BiomeKeys.HIGHLANDS.m_135782_(), (Object)TROLL_CAVE).put((Object)BiomeKeys.SNOWY_FOREST.m_135782_(), (Object)YETI_CAVE).put((Object)BiomeKeys.SWAMP.m_135782_(), (Object)LABYRINTH).put((Object)BiomeKeys.LAKE.m_135782_(), (Object)QUEST_ISLAND).build();
    public static final StructurePieceType TFHill = TFFeature.registerPiece("TFHill", HollowHillComponent::new);
    public static final StructurePieceType TFHedge = TFFeature.registerPiece("TFHedge", HedgeMazeComponent::new);
    public static final StructurePieceType TFQuestGrove = TFFeature.registerPiece("TFQuest1", QuestGrove::new);
    public static final StructurePieceType TFHydra = TFFeature.registerPiece("TFHydra", HydraLairComponent::new);
    public static final StructurePieceType TFYeti = TFFeature.registerPiece("TFYeti", YetiCaveComponent::new);
    public final int size;
    public final String name;
    public final boolean centerBounds;
    public boolean surfaceDecorationsAllowed = false;
    public boolean undergroundDecoAllowed = true;
    public boolean isStructureEnabled = true;
    public boolean requiresTerraforming = false;
    private final ResourceLocation[] requiredAdvancements;
    public boolean hasProtectionAura = true;
    protected boolean adjustToTerrainHeight = false;
    private static int maxPossibleSize;
    private final List<List<MobSpawnSettings.SpawnerData>> spawnableMonsterLists = new ArrayList<List<MobSpawnSettings.SpawnerData>>();
    private final List<MobSpawnSettings.SpawnerData> ambientCreatureList = new ArrayList<MobSpawnSettings.SpawnerData>();
    private final List<MobSpawnSettings.SpawnerData> waterCreatureList = new ArrayList<MobSpawnSettings.SpawnerData>();
    private long lastSpawnedHintMonsterTime;
    private static final String BOOK_AUTHOR = "A Forgotten Explorer";

    TFFeature(int size, String name, boolean featureGenerator, ResourceLocation ... requiredAdvancements) {
        this(size, name, featureGenerator, false, requiredAdvancements);
    }

    TFFeature(int size, String name, boolean featureGenerator, boolean centerBounds, ResourceLocation ... requiredAdvancements) {
        this.size = size;
        this.name = name;
        this.requiredAdvancements = requiredAdvancements;
        this.centerBounds = centerBounds;
        maxPossibleSize = Math.max(this.size, maxPossibleSize);
    }

    static void init() {
    }

    public static int getMaxSize() {
        return maxPossibleSize;
    }

    public boolean shouldAdjustToTerrain() {
        return this.adjustToTerrainHeight;
    }

    public static TFFeature getFeatureAt(int regionX, int regionZ, WorldGenLevel world) {
        return TFFeature.generateFeature(regionX >> 4, regionZ >> 4, world);
    }

    public static boolean isInFeatureChunk(int regionX, int regionZ) {
        int chunkX = regionX >> 4;
        int chunkZ = regionZ >> 4;
        BlockPos cc = TFFeature.getNearestCenterXYZ(chunkX, chunkZ);
        return chunkX == cc.m_123341_() >> 4 && chunkZ == cc.m_123343_() >> 4;
    }

    public TFFeature enableDecorations() {
        this.surfaceDecorationsAllowed = true;
        return this;
    }

    public TFFeature disableStructure() {
        this.enableDecorations();
        this.isStructureEnabled = false;
        return this;
    }

    public TFFeature enableTerrainAlterations() {
        this.requiresTerraforming = true;
        return this;
    }

    public TFFeature disableProtectionAura() {
        this.hasProtectionAura = false;
        return this;
    }

    public TFFeature addMonster(EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFFeature addMonster(int listIndex, EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new MobSpawnSettings.SpawnerData(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFFeature addWaterCreature(EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new MobSpawnSettings.SpawnerData(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public static TFFeature getFeatureDirectlyAt(int chunkX, int chunkZ, WorldGenLevel world) {
        if (TFFeature.isInFeatureChunk(chunkX << 4, chunkZ << 4)) {
            return TFFeature.getFeatureAt(chunkX << 4, chunkZ << 4, world);
        }
        return NOTHING;
    }

    public static TFFeature generateFeature(int chunkX, int chunkZ, WorldGenLevel world) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        Biome biomeAt = (Biome)world.m_204166_(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8)).m_203334_();
        return TFFeature.generateFeature(chunkX, chunkZ, biomeAt, world.m_7328_());
    }

    public static TFFeature generateFeature(int chunkX, int chunkZ, Biome biome, long seed) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        TFFeature biomeFeature = BIOME_FEATURES.get(biome.getRegistryName());
        if (biomeFeature != null) {
            return biomeFeature;
        }
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return LICH_TOWER;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return NAGA_COURTYARD;
        }
        return switch (new Random(seed + (long)chunkX * 25117L + (long)chunkZ * 151121L).nextInt(16)) {
            case 6, 7, 8 -> MEDIUM_HILL;
            case 9 -> LARGE_HILL;
            case 10, 11 -> HEDGE_MAZE;
            case 12, 13 -> NAGA_COURTYARD;
            case 14, 15 -> LICH_TOWER;
            default -> SMALL_HILL;
        };
    }

    public static TFFeature getNearestFeature(int cx, int cz, WorldGenLevel world) {
        return TFFeature.getNearestFeature(cx, cz, world, null);
    }

    public static TFFeature getNearestFeature(int cx, int cz, WorldGenLevel world, @Nullable IntPair center) {
        int maxSize = TFFeature.getMaxSize();
        int diam = maxSize * 2 + 1;
        TFFeature[] features = new TFFeature[diam * diam];
        for (int rad = 1; rad <= maxSize; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    int idx = (x + maxSize) * diam + (z + maxSize);
                    TFFeature directlyAt = features[idx];
                    if (directlyAt == null) {
                        features[idx] = directlyAt = TFFeature.getFeatureDirectlyAt(x + cx, z + cz, world);
                    }
                    if (directlyAt.size != rad) continue;
                    if (center != null) {
                        center.x = (x << 4) + 8;
                        center.z = (z << 4) + 8;
                    }
                    return directlyAt;
                }
            }
        }
        return NOTHING;
    }

    @Nullable
    public static BlockPos findNearestFeaturePosBySpacing(WorldGenLevel worldIn, TFFeature feature, BlockPos blockPos, int p_191069_3_, int p_191069_4_, int p_191069_5_, boolean p_191069_6_, int p_191069_7_, boolean findUnexplored) {
        int i = blockPos.m_123341_() >> 4;
        int j = blockPos.m_123343_() >> 4;
        Random random = new Random();
        block0: for (int k = 0; k <= p_191069_7_; ++k) {
            for (int l = -k; l <= k; ++l) {
                boolean flag = l == -k || l == k;
                for (int i1 = -k; i1 <= k; ++i1) {
                    boolean flag1;
                    boolean bl = flag1 = i1 == -k || i1 == k;
                    if (!flag && !flag1) continue;
                    int j1 = i + p_191069_3_ * l;
                    int k1 = j + p_191069_3_ * i1;
                    if (j1 < 0) {
                        j1 -= p_191069_3_ - 1;
                    }
                    if (k1 < 0) {
                        k1 -= p_191069_3_ - 1;
                    }
                    int l1 = j1 / p_191069_3_;
                    int i2 = k1 / p_191069_3_;
                    Random random1 = new Random();
                    l1 *= p_191069_3_;
                    i2 *= p_191069_3_;
                    if (p_191069_6_) {
                        l1 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                        i2 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                    } else {
                        l1 += random1.nextInt(p_191069_3_ - p_191069_4_);
                        i2 += random1.nextInt(p_191069_3_ - p_191069_4_);
                    }
                    random.nextInt();
                    if (TFFeature.getFeatureAt(l1 << 4, i2 << 4, (WorldGenLevel)worldIn.m_6018_()) == feature) {
                        if (findUnexplored && worldIn.m_7232_(l1, i2)) continue;
                        return new BlockPos((l1 << 4) + 8, 64, (i2 << 4) + 8);
                    }
                    if (k == 0) break;
                }
                if (k == 0) continue block0;
            }
        }
        return null;
    }

    public static TFFeature getFeatureForRegion(int chunkX, int chunkZ, WorldGenLevel world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return TFFeature.generateFeature(featureX, featureZ, world);
    }

    public static TFFeature getFeatureForRegionPos(int posX, int posZ, WorldGenLevel world) {
        return TFFeature.getFeatureForRegion(posX >> 4, posZ >> 4, world);
    }

    public static BlockPos getNearestCenterXYZ(int chunkX, int chunkZ) {
        int regionX = chunkX + 8 >> 4;
        int regionZ = chunkZ + 8 >> 4;
        long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new BlockPos(ccx, 0, ccz);
    }

    public List<MobSpawnSettings.SpawnerData> getCombinedMonsterSpawnableList() {
        ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>();
        this.spawnableMonsterLists.forEach(l -> {
            if (l != null) {
                list.addAll((Collection<MobSpawnSettings.SpawnerData>)l);
            }
        });
        return list;
    }

    public List<MobSpawnSettings.SpawnerData> getCombinedCreatureSpawnableList() {
        ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>();
        list.addAll(this.ambientCreatureList);
        list.addAll(this.waterCreatureList);
        return list;
    }

    public List<MobSpawnSettings.SpawnerData> getSpawnableList(MobCategory creatureType) {
        return switch (creatureType) {
            case MobCategory.MONSTER -> this.getSpawnableMonsterList(0);
            case MobCategory.AMBIENT -> this.ambientCreatureList;
            case MobCategory.WATER_CREATURE -> this.waterCreatureList;
            default -> new ArrayList();
        };
    }

    public List<MobSpawnSettings.SpawnerData> getSpawnableMonsterList(int index) {
        if (index >= 0 && index < this.spawnableMonsterLists.size()) {
            return this.spawnableMonsterLists.get(index);
        }
        return new ArrayList<MobSpawnSettings.SpawnerData>();
    }

    public boolean doesPlayerHaveRequiredAdvancements(Player player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, this.requiredAdvancements);
    }

    public void trySpawnHintMonster(Level world, Player player) {
        this.trySpawnHintMonster(world, player, player.m_142538_());
    }

    public void trySpawnHintMonster(Level world, Player player, BlockPos pos) {
        long currentTime = world.m_46467_();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    private boolean didSpawnHintMonster(Level world, Player player, BlockPos pos) {
        int dx = world.f_46441_.nextInt(16) - world.f_46441_.nextInt(16);
        int dy = world.f_46441_.nextInt(4) - world.f_46441_.nextInt(4);
        int dz = world.f_46441_.nextInt(16) - world.f_46441_.nextInt(16);
        Kobold hinty = (Kobold)((EntityType)TFEntities.KOBOLD.get()).m_20615_(world);
        hinty.m_20035_(pos.m_142082_(dx, dy, dz), 0.0f, 0.0f);
        if (hinty.m_6914_((LevelReader)world) && hinty.m_21574_().m_148306_((Entity)player)) {
            ItemStack book = this.createHintBook();
            hinty.m_8061_(EquipmentSlot.MAINHAND, book);
            hinty.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
            world.m_7967_((Entity)hinty);
            return true;
        }
        return false;
    }

    public ItemStack createHintBook() {
        ItemStack book = new ItemStack((ItemLike)Items.f_42615_);
        this.addBookInformation(book, new ListTag());
        return book;
    }

    protected void addBookInformation(ItemStack book, ListTag bookPages) {
        TFFeature.addTranslatedPages(bookPages, "twilightforest.book.unknown", 2);
        book.m_41700_("pages", (Tag)bookPages);
        book.m_41700_("author", (Tag)StringTag.m_129297_((String)BOOK_AUTHOR));
        book.m_41700_("title", (Tag)StringTag.m_129297_((String)"Notes on the Unexplained"));
    }

    @Nullable
    public StructurePiece provideFirstPiece(StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, int x, int y, int z) {
        return null;
    }

    public Optional<StructurePiece> generatePieces(PieceGeneratorSupplier.Context<?> context) {
        ChunkPos chunkPos = context.f_197355_();
        if (!TFFeature.isInFeatureChunk(chunkPos.f_45578_ << 4, chunkPos.f_45579_ << 4)) {
            return Optional.empty();
        }
        boolean dontCenter = this == LICH_TOWER || this == TROLL_CAVE || this == YETI_CAVE;
        int x = (chunkPos.f_45578_ << 4) + (dontCenter ? 0 : 7);
        int z = (chunkPos.f_45579_ << 4) + (dontCenter ? 0 : 7);
        int y = this.shouldAdjustToTerrain() ? Mth.m_14045_((int)context.f_197352_().m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()), (int)(context.f_197352_().m_6337_() + 1), (int)(context.f_197352_().m_6337_() + 7)) : context.f_197352_().m_6337_();
        Holder holder = context.f_197352_().m_203495_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z));
        if (this != TFFeature.generateFeature(chunkPos.f_45578_, chunkPos.f_45579_, (Biome)holder.m_203334_(), context.f_197354_())) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.provideFirstPiece(context.f_197359_(), context.f_197352_(), new Random(context.f_197354_() + (long)chunkPos.f_45578_ * 25117L + (long)chunkPos.f_45579_ * 151121L), x, y, z));
    }

    public GenerationStep.Decoration getDecorationStage() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static void addTranslatedPages(ListTag bookPages, String translationKey, int pageCount) {
        for (int i = 1; i <= pageCount; ++i) {
            bookPages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TranslatableComponent(translationKey + "." + i))));
        }
    }

    public static StructurePieceType registerPiece(String name, StructurePieceType piece) {
        return (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)TwilightForestMod.prefix(name.toLowerCase(Locale.ROOT)), (Object)piece);
    }

    public final BoundingBox getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int spanX, int spanY, int spanZ, @Nullable Direction dir) {
        if (this.centerBounds) {
            x += (spanX + minX) / 4;
            y += (spanY + minY) / 4;
            z += (spanZ + minZ) / 4;
        }
        return switch (dir) {
            case Direction.WEST -> new BoundingBox(x - spanZ + minZ, y + minY, z + minX, x + minZ, y + spanY + minY, z + spanX + minX);
            case Direction.NORTH -> new BoundingBox(x - spanX - minX, y + minY, z - spanZ - minZ, x - minX, y + spanY + minY, z - minZ);
            case Direction.EAST -> new BoundingBox(x + minZ, y + minY, z - spanX, x + spanZ + minZ, y + spanY + minY, z + minX);
            default -> new BoundingBox(x + minX, y + minY, z + minZ, x + spanX + minX, y + spanY + minY, z + spanZ + minZ);
        };
    }

    public static boolean isTheseFeatures(TFFeature feature, TFFeature ... predicates) {
        for (TFFeature predicate : predicates) {
            if (feature != predicate) continue;
            return true;
        }
        return false;
    }
}

