/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.options.RegistrarOption;
import dev.architectury.registry.registries.options.StandardRegistrarOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistriesImpl {
    private static final Logger LOGGER = LogManager.getLogger(RegistriesImpl.class);
    private static final Multimap<RegistryEntryId<?>, Consumer<?>> LISTENERS = HashMultimap.create();

    private static void listen(ResourceKey<?> resourceKey, ResourceLocation id, Consumer<?> listener, boolean vanilla) {
        LISTENERS.put(new RegistryEntryId(resourceKey, id), listener);
    }

    public static Registries.RegistryProvider _get(String modId) {
        return new RegistryProviderImpl(modId);
    }

    public static <T> ResourceLocation getId(T t, ResourceKey<Registry<T>> registryKey) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static <T> ResourceLocation getId(T t, Registry<T> registry) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static class RegistryEntryId<T> {
        private final ResourceKey<T> registryKey;
        private final ResourceLocation id;

        public RegistryEntryId(ResourceKey<T> registryKey, ResourceLocation id) {
            this.registryKey = registryKey;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegistryEntryId)) {
                return false;
            }
            RegistryEntryId that = (RegistryEntryId)o;
            return Objects.equals(this.registryKey, that.registryKey) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.registryKey, this.id);
        }
    }

    public static class RegistryProviderImpl
    implements Registries.RegistryProvider {
        private final String modId;
        private final Supplier<IEventBus> eventBus;
        private final Map<ResourceKey<? extends Registry<?>>, Data> registry = new HashMap();
        private final Multimap<ResourceKey<Registry<?>>, Consumer<Registrar<?>>> listeners = HashMultimap.create();

        public RegistryProviderImpl(String modId) {
            this.modId = modId;
            this.eventBus = Suppliers.memoize(() -> {
                IEventBus eventBus = EventBuses.getModEventBus(modId).orElseThrow(() -> new IllegalStateException("Can't get event bus for mod '" + modId + "' because it was not registered!"));
                eventBus.register((Object)new EventListener());
                return eventBus;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEventBus() {
            Supplier<IEventBus> supplier = this.eventBus;
            synchronized (supplier) {
                this.eventBus.get();
            }
        }

        @Override
        public <T> Registrar<T> get(ResourceKey<Registry<T>> registryKey) {
            this.updateEventBus();
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryKey.m_135782_());
            if (registry == null) {
                Registry ts = (Registry)Registry.f_122897_.m_7745_(registryKey.m_135782_());
                if (ts == null) {
                    throw new IllegalArgumentException("Registry " + registryKey + " does not exist!");
                }
                return this.get(ts);
            }
            return this.get((IForgeRegistry)registry);
        }

        public <T> Registrar<T> get(IForgeRegistry registry) {
            this.updateEventBus();
            return new ForgeBackedRegistryImpl(this.modId, this.registry, registry);
        }

        @Override
        public <T> Registrar<T> get(Registry<T> registry) {
            this.updateEventBus();
            return new VanillaBackedRegistryImpl<T>(this.modId, this.registry, registry);
        }

        @Override
        public <T> void forRegistry(ResourceKey<Registry<T>> key, Consumer<Registrar<T>> consumer) {
            this.listeners.put(key, consumer);
        }

        @Override
        public <T> RegistrarBuilder<T> builder(Class<T> type, ResourceLocation registryId) {
            return new RegistryBuilderWrapper(this, new RegistryBuilder().setName(registryId).setType(type));
        }

        public class EventListener {
            public void handleVanillaRegistries() {
                for (Registry vanillaRegistry : Registry.f_122897_) {
                    if (RegistryManager.ACTIVE.getRegistry(vanillaRegistry.m_123023_().m_135782_()) != null) continue;
                    Registrar archRegistry = RegistryProviderImpl.this.get(vanillaRegistry);
                    for (Map.Entry<ResourceKey<Registry<?>>, Data> typeDataEntry : RegistryProviderImpl.this.registry.entrySet()) {
                        ResourceKey resourceKey = archRegistry.key();
                        if (!typeDataEntry.getKey().equals(resourceKey)) continue;
                        Data data = typeDataEntry.getValue();
                        data.collected = true;
                        for (Map.Entry<ResourceLocation, Supplier<?>> entry : data.vanillaObjects.entrySet()) {
                            Object value = entry.getValue().get();
                            Registry.m_122965_((Registry)vanillaRegistry, (ResourceLocation)entry.getKey(), value);
                            RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, entry.getKey());
                            for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                                consumer.accept(value);
                            }
                            LISTENERS.removeAll(registryEntryId);
                        }
                        data.objects.clear();
                    }
                    for (Map.Entry<Object, Data> entry : RegistryProviderImpl.this.listeners.entries()) {
                        if (!((ResourceKey)entry.getKey()).equals((Object)vanillaRegistry.m_123023_())) continue;
                        ((Consumer)((Object)entry.getValue())).accept(archRegistry);
                    }
                }
            }

            public void handleVanillaRegistriesPost() {
                for (Registry vanillaRegistry : Registry.f_122897_) {
                    if (RegistryManager.ACTIVE.getRegistry(vanillaRegistry.m_123023_().m_135782_()) != null) continue;
                    Registrar archRegistry = RegistryProviderImpl.this.get(vanillaRegistry);
                    ArrayList<RegistryEntryId> toRemove = new ArrayList<RegistryEntryId>();
                    for (Map.Entry entry : LISTENERS.asMap().entrySet()) {
                        if (!((RegistryEntryId)entry.getKey()).registryKey.equals(archRegistry.key())) continue;
                        if (vanillaRegistry.m_7804_(((RegistryEntryId)entry.getKey()).id)) {
                            Object value = vanillaRegistry.m_7745_(((RegistryEntryId)entry.getKey()).id);
                            for (Consumer consumer : (Collection)entry.getValue()) {
                                consumer.accept(value);
                            }
                            toRemove.add((RegistryEntryId)entry.getKey());
                            continue;
                        }
                        LOGGER.warn("Registry entry listened {} was not realized!", entry.getKey());
                    }
                    for (RegistryEntryId entryId : toRemove) {
                        LISTENERS.removeAll((Object)entryId);
                    }
                }
            }

            @SubscribeEvent
            public void handleEvent(RegistryEvent.Register event) {
                if (event.getGenericType() == Block.class) {
                    this.handleVanillaRegistries();
                }
                IForgeRegistry registry = event.getRegistry();
                Registrar archRegistry = RegistryProviderImpl.this.get(registry);
                for (Map.Entry<ResourceKey<Registry<?>>, Data> typeDataEntry : RegistryProviderImpl.this.registry.entrySet()) {
                    ResourceKey resourceKey = archRegistry.key();
                    if (!typeDataEntry.getKey().equals(resourceKey)) continue;
                    Data data = typeDataEntry.getValue();
                    data.collected = true;
                    for (Map.Entry<RegistryObject<?>, Supplier<IForgeRegistryEntry<?>>> entry : data.objects.entrySet()) {
                        IForgeRegistryEntry<?> value = entry.getValue().get();
                        registry.register(value);
                        entry.getKey().updateReference(registry);
                        RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, entry.getKey().getId());
                        for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                            consumer.accept(value);
                        }
                        LISTENERS.removeAll(registryEntryId);
                    }
                    data.objects.clear();
                }
                for (Map.Entry<Object, Data> entry : RegistryProviderImpl.this.listeners.entries()) {
                    if (!((ResourceKey)entry.getKey()).m_135782_().equals((Object)registry.getRegistryName())) continue;
                    ((Consumer)((Object)entry.getValue())).accept(archRegistry);
                }
            }

            @SubscribeEvent(priority=EventPriority.LOWEST)
            public void handleEventPost(RegistryEvent.Register event) {
                if (event.getGenericType() == ForgeWorldPreset.class) {
                    this.handleVanillaRegistriesPost();
                }
                IForgeRegistry registry = event.getRegistry();
                Registrar archRegistry = RegistryProviderImpl.this.get(registry);
                ResourceKey resourceKey = archRegistry.key();
                ArrayList<RegistryEntryId> toRemove = new ArrayList<RegistryEntryId>();
                for (Map.Entry entry : LISTENERS.asMap().entrySet()) {
                    if (!((RegistryEntryId)entry.getKey()).registryKey.equals(resourceKey)) continue;
                    if (registry.containsKey(((RegistryEntryId)entry.getKey()).id)) {
                        IForgeRegistryEntry value = registry.getValue(((RegistryEntryId)entry.getKey()).id);
                        for (Consumer consumer : (Collection)entry.getValue()) {
                            consumer.accept(value);
                        }
                        toRemove.add((RegistryEntryId)entry.getKey());
                        continue;
                    }
                    LOGGER.warn("Registry entry listened {} was not realized!", entry.getKey());
                }
                for (RegistryEntryId id : toRemove) {
                    LISTENERS.removeAll((Object)id);
                }
            }
        }
    }

    public static class ForgeBackedRegistryImpl<T extends IForgeRegistryEntry<T>>
    implements Registrar<T> {
        private final String modId;
        private IForgeRegistry<T> delegate;
        private Map<ResourceKey<? extends Registry<?>>, Data> registry;

        public ForgeBackedRegistryImpl(String modId, Map<ResourceKey<? extends Registry<?>>, Data> registry, IForgeRegistry<T> delegate) {
            this.modId = modId;
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        public RegistrySupplier<T> delegate(final ResourceLocation id) {
            com.google.common.base.Supplier value = Suppliers.memoize(() -> this.get(id));
            final ForgeBackedRegistryImpl registrar = this;
            return new RegistrySupplier<T>(){
                final /* synthetic */ Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                public Registries getRegistries() {
                    return Registries.get(modId);
                }

                @Override
                public Registrar<T> getRegistrar() {
                    return registrar;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return (IForgeRegistryEntry)this.val$value.get();
                }

                public int hashCode() {
                    return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        public <E extends T> RegistrySupplier<E> register(final ResourceLocation id, Supplier<E> supplier) {
            final RegistryObject registryObject = RegistryObject.of((ResourceLocation)id, this.delegate);
            this.registry.computeIfAbsent(this.key(), type -> new Data()).register(this.delegate, registryObject, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)supplier.get()).setRegistryName(id));
            final ForgeBackedRegistryImpl registrar = this;
            return new RegistrySupplier<E>(){

                @Override
                public Registries getRegistries() {
                    return Registries.get(modId);
                }

                @Override
                public Registrar<E> getRegistrar() {
                    return registrar;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                public ResourceLocation getId() {
                    return registryObject.getId();
                }

                @Override
                public boolean isPresent() {
                    return registryObject.isPresent();
                }

                @Override
                public E get() {
                    return registryObject.get();
                }

                public int hashCode() {
                    return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.getKey(obj);
        }

        @Override
        public int getRawId(T obj) {
            return ((ForgeRegistry)this.delegate).getID(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T t) {
            return Optional.ofNullable(this.getId(t)).map(id -> ResourceKey.m_135785_(this.key(), (ResourceLocation)id));
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.getValue(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)((ForgeRegistry)this.delegate).getValue(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.containsKey(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.containsValue(t);
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.getKeys();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.delegate.getEntries();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return ResourceKey.m_135788_((ResourceLocation)this.delegate.getRegistryName());
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public void listen(ResourceLocation id, Consumer<T> callback) {
            if (this.contains(id)) {
                callback.accept(this.get(id));
            } else {
                RegistriesImpl.listen(this.key(), id, callback, false);
            }
        }
    }

    public static class VanillaBackedRegistryImpl<T>
    implements Registrar<T> {
        private final String modId;
        private Registry<T> delegate;
        private Map<ResourceKey<? extends Registry<?>>, Data> registry;

        public VanillaBackedRegistryImpl(String modId, Map<ResourceKey<? extends Registry<?>>, Data> registry, Registry<T> delegate) {
            this.modId = modId;
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        public RegistrySupplier<T> delegate(final ResourceLocation id) {
            com.google.common.base.Supplier value = Suppliers.memoize(() -> this.get(id));
            final VanillaBackedRegistryImpl registrar = this;
            return new RegistrySupplier<T>(){
                final /* synthetic */ Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                public Registries getRegistries() {
                    return Registries.get(modId);
                }

                @Override
                public Registrar<T> getRegistrar() {
                    return registrar;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return delegate.m_123023_().m_135782_();
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return this.val$value.get();
                }

                public int hashCode() {
                    return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        public <E extends T> RegistrySupplier<E> register(ResourceLocation id, Supplier<E> supplier) {
            this.registry.computeIfAbsent(this.key(), type -> new Data()).register(this.delegate, id, supplier);
            return this.delegate(id);
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.m_7981_(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.m_7447_(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T t) {
            return this.delegate.m_7854_(t);
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.m_7745_(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.m_7942_(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.m_6566_().contains(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.m_7854_(t).isPresent();
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.m_6566_();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.delegate.m_6579_();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.delegate.m_123023_();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public void listen(ResourceLocation id, Consumer<T> callback) {
            if (this.contains(id)) {
                callback.accept(this.get(id));
            } else {
                RegistriesImpl.listen(this.key(), id, callback, true);
            }
        }
    }

    public static class RegistryBuilderWrapper<T>
    implements RegistrarBuilder<T> {
        private final RegistryProviderImpl provider;
        private final RegistryBuilder<?> builder;
        private boolean saveToDisk = false;
        private boolean syncToClients = false;

        public RegistryBuilderWrapper(RegistryProviderImpl provider, RegistryBuilder<?> builder) {
            this.provider = provider;
            this.builder = builder;
        }

        @Override
        public Registrar<T> build() {
            if (!this.syncToClients) {
                this.builder.disableSync();
            }
            if (!this.saveToDisk) {
                this.builder.disableSaving();
            }
            return this.provider.get(this.builder.create());
        }

        @Override
        public RegistrarBuilder<T> option(RegistrarOption option) {
            if (option == StandardRegistrarOption.SAVE_TO_DISC) {
                this.saveToDisk = true;
            } else if (option == StandardRegistrarOption.SYNC_TO_CLIENTS) {
                this.syncToClients = true;
            }
            return this;
        }
    }

    public static class Data {
        private boolean collected = false;
        private final Map<RegistryObject<?>, Supplier<? extends IForgeRegistryEntry<?>>> objects = new LinkedHashMap();
        private final Map<ResourceLocation, Supplier<?>> vanillaObjects = new LinkedHashMap();

        public void register(IForgeRegistry registry, RegistryObject object, Supplier<? extends IForgeRegistryEntry<?>> reference) {
            if (!this.collected) {
                this.objects.put(object, reference);
            } else {
                ResourceKey resourceKey = ResourceKey.m_135788_((ResourceLocation)registry.getRegistryName());
                IForgeRegistryEntry<?> value = reference.get();
                registry.register(value);
                object.updateReference(registry);
                RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, object.getId());
                for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                    consumer.accept(value);
                }
                LISTENERS.removeAll(registryEntryId);
            }
        }

        public <T> void register(Registry<T> registry, ResourceLocation id, Supplier<? extends T> reference) {
            if (!this.collected) {
                this.vanillaObjects.put(id, reference);
            } else {
                T value = reference.get();
                Registry.m_122965_(registry, (ResourceLocation)id, value);
                RegistryEntryId registryEntryId = new RegistryEntryId(registry.m_123023_(), id);
                for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                    consumer.accept(value);
                }
                LISTENERS.removeAll(registryEntryId);
            }
        }
    }
}

