/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IIngredientGridConfig;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.ingredients.GuiIngredientProperties;
import mezz.jei.gui.overlay.HorizontalAlignment;
import mezz.jei.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.gui.overlay.VerticalAlignment;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.DeleteItemInputHandler;
import mezz.jei.render.ElementRenderer;
import mezz.jei.render.IngredientListRenderer;
import mezz.jei.render.IngredientListSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;

public class IngredientGrid
implements IRecipeFocusSource {
    private static final int INGREDIENT_PADDING = 1;
    public static final int INGREDIENT_WIDTH = GuiIngredientProperties.getWidth(1);
    public static final int INGREDIENT_HEIGHT = GuiIngredientProperties.getHeight(1);
    private final IIngredientGridConfig gridConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final IngredientListRenderer ingredientListRenderer;
    private final DeleteItemInputHandler deleteItemHandler;
    private final IngredientGridTooltipHelper tooltipHelper;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;

    public IngredientGrid(RegisteredIngredients registeredIngredients, IIngredientGridConfig gridConfig, IEditModeConfig editModeConfig, IIngredientFilterConfig ingredientFilterConfig, IClientConfig clientConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, IModIdHelper modIdHelper, IConnectionToServer serverConnection) {
        this.gridConfig = gridConfig;
        this.guiScreenHelper = guiScreenHelper;
        this.ingredientListRenderer = new IngredientListRenderer(editModeConfig, worldConfig, registeredIngredients);
        this.tooltipHelper = new IngredientGridTooltipHelper(registeredIngredients, ingredientFilterConfig, worldConfig, modIdHelper);
        this.deleteItemHandler = new DeleteItemInputHandler(this, worldConfig, clientConfig, serverConnection);
    }

    public IUserInputHandler getInputHandler() {
        return this.deleteItemHandler;
    }

    public int size() {
        return this.ingredientListRenderer.size();
    }

    public int maxWidth() {
        return this.gridConfig.getMaxColumns() * INGREDIENT_WIDTH;
    }

    public int maxHeight() {
        return this.gridConfig.getMaxRows() * INGREDIENT_HEIGHT;
    }

    public boolean updateBounds(ImmutableRect2i availableArea, Collection<ImmutableRect2i> exclusionAreas) {
        this.ingredientListRenderer.clear();
        this.area = IngredientGrid.calculateBounds(this.gridConfig, availableArea, INGREDIENT_WIDTH, INGREDIENT_HEIGHT);
        if (this.area.isEmpty()) {
            return false;
        }
        for (int y = this.area.getY(); y < this.area.getY() + this.area.getHeight(); y += INGREDIENT_HEIGHT) {
            for (int x = this.area.getX(); x < this.area.getX() + this.area.getWidth(); x += INGREDIENT_WIDTH) {
                IngredientListSlot ingredientListSlot = new IngredientListSlot(x, y, INGREDIENT_WIDTH, INGREDIENT_HEIGHT, 1);
                ImmutableRect2i stackArea = ingredientListSlot.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                ingredientListSlot.setBlocked(blocked);
                this.ingredientListRenderer.add(ingredientListSlot);
            }
        }
        return true;
    }

    private static ImmutableRect2i calculateBounds(IIngredientGridConfig config, ImmutableRect2i availableArea, int ingredientWidth, int ingredientHeight) {
        int columns = Math.min(availableArea.getWidth() / ingredientWidth, config.getMaxColumns());
        int rows = Math.min(availableArea.getHeight() / ingredientHeight, config.getMaxRows());
        if (rows < config.getMinRows() || columns < config.getMinColumns()) {
            return ImmutableRect2i.EMPTY;
        }
        int width = columns * ingredientWidth;
        int height = rows * ingredientHeight;
        int x = switch (config.getHorizontalAlignment()) {
            default -> throw new IncompatibleClassChangeError();
            case HorizontalAlignment.LEFT -> availableArea.getX();
            case HorizontalAlignment.CENTER -> availableArea.getX() + (availableArea.getWidth() - width) / 2;
            case HorizontalAlignment.RIGHT -> availableArea.getX() + (availableArea.getWidth() - width);
        };
        int y = switch (config.getVerticalAlignment()) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalAlignment.TOP -> availableArea.getY();
            case VerticalAlignment.CENTER -> availableArea.getY() + (availableArea.getHeight() - height) / 2;
            case VerticalAlignment.BOTTOM -> availableArea.getY() + (availableArea.getHeight() - height);
        };
        return new ImmutableRect2i(x, y, width, height);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_69461_();
        this.ingredientListRenderer.render(poseStack);
        if (this.isMouseOver(mouseX, mouseY) && !this.deleteItemHandler.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            this.ingredientListRenderer.getSlots().filter(s -> s.isMouseOver(mouseX, mouseY)).map(IngredientListSlot::getIngredientRenderer).flatMap(Optional::stream).map(ElementRenderer::getArea).findFirst().ifPresent(area -> IngredientGrid.drawHighlight(poseStack, area));
        }
    }

    public static void drawHighlight(PoseStack poseStack, ImmutableRect2i area) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)area.getX(), (int)area.getY(), (int)(area.getX() + area.getWidth()), (int)(area.getY() + area.getHeight()), (int)-2130706433);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.deleteItemHandler.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                this.deleteItemHandler.drawTooltips(poseStack, mouseX, mouseY);
            } else {
                this.ingredientListRenderer.getSlots().filter(s -> s.isMouseOver(mouseX, mouseY)).map(IngredientListSlot::getTypedIngredient).flatMap(Optional::stream).findFirst().ifPresent(ingredient -> this.tooltipHelper.drawTooltip(poseStack, mouseX, mouseY, ingredient));
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.ingredientListRenderer.getSlots().filter(s -> s.isMouseOver(mouseX, mouseY)).map(IngredientListSlot::getIngredientRenderer).flatMap(Optional::stream);
    }

    public <T> Stream<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        return this.ingredientListRenderer.getSlots().map(IngredientListSlot::getTypedIngredient).flatMap(Optional::stream).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream);
    }

    public void set(int firstItemIndex, List<ITypedIngredient<?>> ingredientList) {
        this.ingredientListRenderer.set(firstItemIndex, ingredientList);
    }
}

