/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.capabilities.oxygen;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorageHolder;

public class OxygenStorage
implements IOxygenStorage {
    private IOxygenStorageHolder holder;
    protected int oxygen;
    protected int capacity;

    public OxygenStorage(IOxygenStorageHolder holder, int capacity) {
        this(holder, capacity, 0);
    }

    public OxygenStorage(IOxygenStorageHolder holder, int capacity, int oxygen) {
        this.holder = holder;
        this.capacity = capacity;
        this.oxygen = Math.max(0, Math.min(capacity, oxygen));
    }

    @Override
    public int receiveOxygen(int maxReceive, boolean simulate) {
        int oxygen = this.getOxygenStored();
        int oxygenReceived = Math.min(this.getMaxOxygenStored() - oxygen, Math.max(0, maxReceive));
        if (!simulate) {
            this.setOxygenStored(oxygen + oxygenReceived);
        }
        return oxygenReceived;
    }

    @Override
    public int extractOxygen(int maxExtract, boolean simulate) {
        int oxygen = this.getOxygenStored();
        int oxygenExtracted = Math.min(oxygen, Math.max(0, maxExtract));
        if (!simulate) {
            this.setOxygenStored(oxygen - oxygenExtracted);
        }
        return oxygenExtracted;
    }

    public IOxygenStorageHolder getHolder() {
        return this.holder;
    }

    @Override
    public int getOxygenStored() {
        return this.oxygen;
    }

    @Override
    public void setOxygenStored(int oxygen) {
        oxygen = Math.max(Math.min(oxygen, this.getMaxOxygenStored()), 0);
        int oxygenPrev = this.getOxygenStored();
        if (oxygenPrev != oxygen) {
            this.oxygen = oxygen;
            int delta = oxygen - oxygenPrev;
            Optional.ofNullable(this.getHolder()).ifPresent(h -> h.onOxygenChanged(this, delta));
        }
    }

    @Override
    public int getMaxOxygenStored() {
        return this.capacity;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("oxygen", this.getOxygenStored());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.setOxygenStored(compound.m_128451_("oxygen"));
    }
}

