/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.compats.mekanism;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.common.registries.MekanismGases;
import net.minecraft.nbt.CompoundTag;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;

public class GasHandlerOxygenAdapter
implements IOxygenStorage {
    private IGasHandler gasHandler;
    private boolean canExtract;
    private boolean canReceive;

    public GasHandlerOxygenAdapter(IGasHandler gasHandler) {
        this(gasHandler, true, true);
    }

    public GasHandlerOxygenAdapter(IGasHandler gasHandler, boolean canExtract, boolean canReceive) {
        this.gasHandler = gasHandler;
        this.canExtract = canExtract;
        this.canReceive = canReceive;
    }

    public Gas getGas() {
        return (Gas)MekanismGases.OXYGEN.get();
    }

    protected GasStack createGasStack(int amount) {
        return new GasStack((IGasProvider)this.getGas(), (long)amount);
    }

    @Override
    public int receiveOxygen(int maxReceive, boolean simulate) {
        if (!this.isCanReceive()) {
            return 0;
        }
        GasStack toInsert = this.createGasStack(maxReceive);
        GasStack remain = (GasStack)this.getGasHandler().insertChemical((ChemicalStack)toInsert, Action.get((!simulate ? 1 : 0) != 0));
        if (remain.isEmpty()) {
            return maxReceive;
        }
        return (int)((long)maxReceive - remain.getAmount());
    }

    @Override
    public int extractOxygen(int maxExtract, boolean simulate) {
        if (!this.isCanExtract()) {
            return 0;
        }
        return (int)((GasStack)this.getGasHandler().extractChemical((long)maxExtract, Action.get((!simulate ? 1 : 0) != 0))).getAmount();
    }

    @Override
    public int getOxygenStored() {
        long stored = 0L;
        IGasHandler gasHandler = this.getGasHandler();
        int tanks = gasHandler.getTanks();
        for (int i = 0; i < tanks; ++i) {
            GasStack stack = (GasStack)gasHandler.getChemicalInTank(i);
            if (stack.getType() != this.getGas()) continue;
            stored = Math.max(stored + Math.max(stack.getAmount(), Integer.MAX_VALUE), Integer.MAX_VALUE);
        }
        return (int)stored;
    }

    @Override
    public void setOxygenStored(int oxygen) {
        IGasHandler gasHandler = this.getGasHandler();
        int tanks = gasHandler.getTanks();
        for (int i = 0; i < tanks; ++i) {
            GasStack stack = (GasStack)gasHandler.getChemicalInTank(i);
            if (stack.getType() != this.getGas()) continue;
            gasHandler.setChemicalInTank(i, (ChemicalStack)GasStack.EMPTY);
        }
        gasHandler.insertChemical((ChemicalStack)this.createGasStack(tanks), Action.EXECUTE);
    }

    @Override
    public int getMaxOxygenStored() {
        long capacity = 0L;
        IGasHandler gasHandler = this.getGasHandler();
        int tanks = gasHandler.getTanks();
        for (int i = 0; i < tanks; ++i) {
            if (!gasHandler.isValid(i, (ChemicalStack)this.createGasStack(1))) continue;
            capacity = Math.max(capacity + Math.max(gasHandler.getTankCapacity(i), Integer.MAX_VALUE), Integer.MAX_VALUE);
        }
        return (int)capacity;
    }

    public IGasHandler getGasHandler() {
        return this.gasHandler;
    }

    public boolean isCanExtract() {
        return this.canExtract;
    }

    public boolean isCanReceive() {
        return this.canReceive;
    }

    public CompoundTag serializeNBT() {
        return null;
    }

    public void deserializeNBT(CompoundTag nbt) {
    }
}

