/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.blocks.CoalLanternBlock;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.registries.BlocksRegistry;

@Mod.EventBusSubscriber(modid="beyond_earth")
public class CoalTorchEvents {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent event) {
        Level world = (Level)event.getWorld();
        if (Methods.isSpaceWorldWithoutOxygen(world)) {
            BlockPos pos = event.getPos();
            BlockState blockState = world.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block == Blocks.f_50083_.m_49966_().m_60734_()) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            } else if (block == Blocks.f_50082_) {
                DirectionProperty property = (DirectionProperty)blockState.m_60734_().m_49965_().m_61081_("facing");
                world.m_7731_(pos, (BlockState)((Block)BlocksRegistry.WALL_COAL_TORCH_BLOCK.get()).m_49966_().m_61124_((Property)property, (Comparable)((Direction)blockState.m_61143_((Property)property))), 3);
                CoalTorchEvents.playFireExtinguish(pos, world);
            } else if (block == Blocks.f_50081_) {
                world.m_7731_(pos, ((Block)BlocksRegistry.COAL_TORCH_BLOCK.get()).m_49966_(), 3);
                CoalTorchEvents.playFireExtinguish(pos, world);
            } else if (block == Blocks.f_50681_) {
                boolean isHanging = (Boolean)blockState.m_61143_((Property)LanternBlock.f_153459_);
                if (isHanging) {
                    world.m_7731_(pos, (BlockState)((Block)BlocksRegistry.COAL_LANTERN_BLOCK.get()).m_49966_().m_61124_((Property)CoalLanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    world.m_7731_(pos, ((Block)BlocksRegistry.COAL_LANTERN_BLOCK.get()).m_49966_(), 3);
                }
                CoalTorchEvents.playFireExtinguish(pos, world);
            } else if (block == Blocks.f_50683_ && ((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                BooleanProperty property = (BooleanProperty)world.m_8055_(pos).m_60734_().m_49965_().m_61081_("lit");
                world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)property, (Comparable)Boolean.valueOf(false)), 3);
                CoalTorchEvents.playFireExtinguish(pos, world);
            }
        }
    }

    public static void playFireExtinguish(BlockPos pos, Level world) {
        world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

