/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.helper;

import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.mrscauthd.beyond_earth.guis.helper.IMergeItemStack;

public class ContainerHelper {
    public static void addInventorySlots(AbstractContainerMenu container, Inventory inv, int left, int top, Function<Slot, Slot> addSlot) {
        ContainerHelper.addInventorySlots(container, inv, left, top, top + 58, addSlot);
    }

    public static void addInventorySlots(AbstractContainerMenu container, Inventory inv, int left, int top, int hotbarY, Function<Slot, Slot> addSlot) {
        int rows = 3;
        int cols = 9;
        int offsetX = 18;
        int offsetY = 18;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                addSlot.apply(new Slot((Container)inv, col + (row + 1) * cols, left + col * offsetX, top + row * offsetY));
            }
        }
        for (int col = 0; col < cols; ++col) {
            addSlot.apply(new Slot((Container)inv, col, left + col * offsetX, hotbarY));
        }
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, Player player, int slotNumber, int containerIndex, Container inventory, IMergeItemStack mergeItemStack) {
        int containerSize = inventory.m_6643_();
        return ContainerHelper.transferStackInSlot(container, player, slotNumber, containerIndex, containerSize, mergeItemStack);
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, Player player, int slotNumber, int containerIndex, int containerSize, IMergeItemStack mergeItemStack) {
        ItemStack itemStack = ItemStack.f_41583_;
        NonNullList inventorySlots = container.f_38839_;
        Slot slot = (Slot)inventorySlots.get(slotNumber);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            int playerInventoryStartIndex = containerIndex + containerSize;
            if (slotNumber < playerInventoryStartIndex ? !mergeItemStack.mergeItemStack(slotStack, playerInventoryStartIndex, inventorySlots.size(), true) : !mergeItemStack.mergeItemStack(slotStack, containerIndex, playerInventoryStartIndex, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, Player player, int slotNumber, Container inventory, IMergeItemStack mergeItemStack) {
        return ContainerHelper.transferStackInSlot(container, player, slotNumber, 0, inventory, mergeItemStack);
    }
}

