/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.screens.oxygenbubbledistributor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.beyond_earth.BeyondEarthMod;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.guis.helper.ImageButtonPlacer;
import net.mrscauthd.beyond_earth.guis.screens.oxygenbubbledistributor.OxygenBubbleDistributorGui;
import net.mrscauthd.beyond_earth.machines.tile.OxygenBubbleDistributorBlockEntity;
import net.mrscauthd.beyond_earth.utils.Rectangle2d;

@OnlyIn(value=Dist.CLIENT)
public class OxygenBubbleDistributorGuiWindow
extends AbstractContainerScreen<OxygenBubbleDistributorGui.GuiContainer> {
    public static final ResourceLocation texture = new ResourceLocation("beyond_earth", "textures/screens/oxygen_bubble_distributor.png");
    public static final int INPUT_TANK_LEFT = 9;
    public static final int INPUT_TANK_TOP = 21;
    public static final int OUTPUT_TANK_LEFT = 75;
    public static final int OUTPUT_TANK_TOP = 21;
    public static final int ENERGY_LEFT = 144;
    public static final int ENERGY_TOP = 21;
    public static final int ARROW_LEFT = 48;
    public static final int ARROW_TOP = 36;
    private boolean cachedWorkingAreaVisible = true;
    public ImageButtonPlacer workingAreaVisibleButton;
    public ImageButtonPlacer button_plus;
    public ImageButtonPlacer button_minus;
    private static ResourceLocation HideButton = new ResourceLocation("beyond_earth", "textures/buttons/technik_button.png");
    private static ResourceLocation Button1 = new ResourceLocation("beyond_earth", "textures/buttons/technik_button_plus.png");
    private static ResourceLocation Button2 = new ResourceLocation("beyond_earth", "textures/buttons/technik_button_minus.png");

    public OxygenBubbleDistributorGuiWindow(OxygenBubbleDistributorGui.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 177;
        this.f_97727_ = 172;
        this.f_97731_ = this.f_97727_ - 92;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        this.updateWorkingAreaVisibleButton();
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        OxygenBubbleDistributorBlockEntity blockEntity = ((OxygenBubbleDistributorGui.GuiContainer)this.m_6262_()).getBlockEntity();
        if (GuiHelper.isHover(this.getInputTankBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getFluid((IFluidTank)blockEntity.getInputTank())).build(), mouseX, mouseY);
        } else if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getOxygen(blockEntity.getOutputTank())).build(), mouseX, mouseY);
        } else if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getEnergy(blockEntity)).build(), mouseX, mouseY);
        }
        if (GuiHelper.isHover(this.getButtonBounds(-20, 4, 20, 21), mouseX, mouseY)) {
            this.button_plus.setTexture(new ResourceLocation("beyond_earth", "textures/buttons/technik_button_plus_2.png"));
        } else {
            this.button_plus.setTexture(new ResourceLocation("beyond_earth", "textures/buttons/technik_button_plus.png"));
        }
        if (GuiHelper.isHover(this.getButtonBounds(-20, 25, 20, 20), mouseX, mouseY)) {
            this.button_minus.setTexture(new ResourceLocation("beyond_earth", "textures/buttons/technik_button_minus_2.png"));
        } else {
            this.button_minus.setTexture(new ResourceLocation("beyond_earth", "textures/buttons/technik_button_minus.png"));
        }
        if (GuiHelper.isHover(this.getButtonBounds(-20, -22, 34, 20), mouseX, mouseY)) {
            this.workingAreaVisibleButton.setTexture(new ResourceLocation("beyond_earth", "textures/buttons/technik_button_2.png"));
        } else {
            this.workingAreaVisibleButton.setTexture(new ResourceLocation("beyond_earth", "textures/buttons/technik_button.png"));
        }
    }

    protected void m_7286_(PoseStack ms, float p_97788_, int p_97789_, int p_97790_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)ms, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        OxygenBubbleDistributorBlockEntity blockEntity = ((OxygenBubbleDistributorGui.GuiContainer)this.m_6262_()).getBlockEntity();
        GuiHelper.drawEnergy(ms, this.f_97735_ + 144, this.f_97736_ + 21, blockEntity.getPrimaryEnergyStorage());
        GuiHelper.drawFluidTank(ms, this.f_97735_ + 9, this.f_97736_ + 21, (IFluidTank)blockEntity.getInputTank());
        GuiHelper.drawOxygenTank(ms, this.f_97735_ + 75, this.f_97736_ + 21, blockEntity.getOutputTank());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.button_plus = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(this.f_97735_ - 20, this.f_97736_ + 5, 20, 20, 0, 0, 0, Button1, 20, 20, p_2130901 -> {
            BlockPos pos = ((OxygenBubbleDistributorGui.GuiContainer)this.m_6262_()).getBlockEntity().m_58899_();
            BeyondEarthMod.PACKET_HANDLER.sendToServer((Object)new OxygenBubbleDistributorBlockEntity.ChangeRangeMessage(pos, true));
        }));
        this.button_minus = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(this.f_97735_ - 20, this.f_97736_ + 25, 20, 20, 0, 0, 0, Button2, 20, 20, p_2130901 -> {
            BlockPos pos = ((OxygenBubbleDistributorGui.GuiContainer)this.m_6262_()).getBlockEntity().m_58899_();
            BeyondEarthMod.PACKET_HANDLER.sendToServer((Object)new OxygenBubbleDistributorBlockEntity.ChangeRangeMessage(pos, false));
        }));
        this.workingAreaVisibleButton = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(this.f_97735_ - 20, this.f_97736_ - 22, 34, 20, 0, 0, 0, HideButton, 34, 20, e -> {
            BlockPos pos = ((OxygenBubbleDistributorGui.GuiContainer)this.m_6262_()).getBlockEntity().m_58899_();
            BeyondEarthMod.PACKET_HANDLER.sendToServer((Object)new OxygenBubbleDistributorBlockEntity.ChangeWorkingAreaVisibleMessage(pos, !this.cachedWorkingAreaVisible));
        }));
    }

    protected void m_7027_(PoseStack ms, int mouseX, int mouseY) {
        super.m_7027_(ms, mouseX, mouseY);
        OxygenBubbleDistributorBlockEntity blockEntity = ((OxygenBubbleDistributorGui.GuiContainer)this.m_6262_()).getBlockEntity();
        double range = blockEntity.getRange();
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String rangeToString = numberInstance.format(range * 2.0 + 1.0);
        TranslatableComponent workingAreaText = new TranslatableComponent("gui.beyond_earth.oxygen_bubble_distributor.workingarea.text", new Object[]{rangeToString, rangeToString, rangeToString});
        int sideWidth = 2;
        int sidePadding = 2;
        int workingAreaHeight = 25;
        int workingAreaLeft = this.workingAreaVisibleButton.f_93620_ + this.workingAreaVisibleButton.m_5711_() - this.f_97735_;
        int workingAreaTop = -workingAreaHeight;
        int workingAreaOffsetX = workingAreaLeft;
        int textwidth = 12;
        if (range * 2.0 + 1.0 > 9.0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/buttons/oxygen_range_layer.png"));
            GuiComponent.m_93133_((PoseStack)ms, (int)(workingAreaOffsetX + 1), (int)workingAreaTop, (float)0.0f, (float)0.0f, (int)150, (int)25, (int)150, (int)25);
            textwidth = 13;
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("beyond_earth", "textures/buttons/oxygen_range_small_layer.png"));
            GuiComponent.m_93133_((PoseStack)ms, (int)(workingAreaOffsetX + 1), (int)workingAreaTop, (float)0.0f, (float)0.0f, (int)140, (int)25, (int)140, (int)25);
            textwidth = 17;
        }
        this.f_96547_.m_92889_(ms, (Component)workingAreaText, (float)(workingAreaLeft + sideWidth + sidePadding + textwidth), (float)(workingAreaTop + 9), 0x339900);
        ms.m_85836_();
        float oyxgenScale = 0.8f;
        ms.m_85841_(oyxgenScale, oyxgenScale, oyxgenScale);
        MutableComponent oxygenText = GaugeTextHelper.getUsingText2(GaugeValueHelper.getOxygen(blockEntity.getOxygenUsing(range)), blockEntity.getMaxTimer()).build();
        int oxygenWidth = this.f_96547_.m_92852_((FormattedText)oxygenText);
        this.f_96547_.m_92889_(ms, (Component)oxygenText, (float)((int)((float)(this.f_97726_ - 5) / oyxgenScale) - oxygenWidth), (float)((int)((float)this.f_97731_ / oyxgenScale)), 0x333333);
        ms.m_85849_();
        String prefix = "gui.beyond_earth.oxygen_bubble_distributor.workingarea.";
        String method = this.cachedWorkingAreaVisible ? "hide" : "show";
        this.f_96547_.m_92889_(ms, (Component)new TranslatableComponent(prefix + method), (float)(workingAreaLeft + sideWidth + sidePadding + (this.cachedWorkingAreaVisible ? -30 : -32)), (float)(workingAreaTop + 9), 0x339900);
    }

    private void updateWorkingAreaVisibleButton() {
        boolean next = ((OxygenBubbleDistributorGui.GuiContainer)this.m_6262_()).getBlockEntity().isWorkingAreaVisible();
        if (this.cachedWorkingAreaVisible != next) {
            this.cachedWorkingAreaVisible = next;
        }
    }

    public Rectangle2d getInputTankBounds() {
        return GuiHelper.getFluidTankBounds(this.f_97735_ + 9, this.f_97736_ + 21);
    }

    public Rectangle2d getOutputTankBounds() {
        return GuiHelper.getFluidTankBounds(this.f_97735_ + 75, this.f_97736_ + 21);
    }

    public Rectangle2d getEnergyBounds() {
        return GuiHelper.getEnergyBounds(this.f_97735_ + 144, this.f_97736_ + 21);
    }

    public Rectangle2d getButtonBounds(int left, int top, int width, int height) {
        return GuiHelper.getBounds(this.f_97735_ + left, this.f_97736_ + top, width, height);
    }
}

