/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.screens.planetselection;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkEvent;
import net.mrscauthd.beyond_earth.crafting.IngredientStack;
import net.mrscauthd.beyond_earth.crafting.SpaceStationRecipe;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.registries.ScreensRegistry;

public class PlanetSelectionGui {
    public static void defaultOptions(Player player) {
        player.m_20242_(false);
        Methods.holdSpaceMessage(player);
        player.m_6915_();
    }

    public static void deleteItems(Player player) {
        if (player.m_150110_().f_35937_ || player.m_5833_()) {
            return;
        }
        Inventory inv = player.m_150109_();
        SpaceStationRecipe recipe = player.f_19853_.m_7465_().m_44043_(SpaceStationRecipe.KEY).orElse(null);
        for (IngredientStack ingredientStack : recipe.getIngredientStacks()) {
            inv.m_36022_(ingredientStack::testWithoutCount, ingredientStack.getCount(), (Container)inv);
        }
    }

    public static class NetworkHandler {
        private int integer = 0;

        public NetworkHandler(int integer) {
            this.setInteger(integer);
        }

        public NetworkHandler(FriendlyByteBuf buffer) {
            this.setInteger(buffer.readInt());
        }

        public int getInteger() {
            return this.integer;
        }

        public void setInteger(int integer) {
            this.integer = integer;
        }

        public static NetworkHandler decode(FriendlyByteBuf buffer) {
            return new NetworkHandler(buffer);
        }

        public static void encode(NetworkHandler message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.getInteger());
        }

        public static void handle(NetworkHandler message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            ServerPlayer player = context.getSender();
            if (message.getInteger() == 0) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.overworld, false);
            }
            if (message.getInteger() == 1) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.moon, false);
            }
            if (message.getInteger() == 2) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.mars, false);
            }
            if (message.getInteger() == 3) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.mercury, false);
            }
            if (message.getInteger() == 4) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.venus, false);
            }
            if (message.getInteger() == 5) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.glacio, false);
            }
            if (message.getInteger() == 6) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.earth_orbit, false);
            }
            if (message.getInteger() == 7) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.moon_orbit, false);
            }
            if (message.getInteger() == 8) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.mars_orbit, false);
            }
            if (message.getInteger() == 9) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.mercury_orbit, false);
            }
            if (message.getInteger() == 10) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.venus_orbit, false);
            }
            if (message.getInteger() == 11) {
                PlanetSelectionGui.defaultOptions((Player)player);
                Methods.teleportButton((Player)player, Methods.glacio_orbit, false);
            }
            if (message.getInteger() == 12) {
                PlanetSelectionGui.defaultOptions((Player)player);
                PlanetSelectionGui.deleteItems((Player)player);
                Methods.teleportButton((Player)player, Methods.earth_orbit, true);
            }
            if (message.getInteger() == 13) {
                PlanetSelectionGui.defaultOptions((Player)player);
                PlanetSelectionGui.deleteItems((Player)player);
                Methods.teleportButton((Player)player, Methods.moon_orbit, true);
            }
            if (message.getInteger() == 14) {
                PlanetSelectionGui.defaultOptions((Player)player);
                PlanetSelectionGui.deleteItems((Player)player);
                Methods.teleportButton((Player)player, Methods.mars_orbit, true);
            }
            if (message.getInteger() == 15) {
                PlanetSelectionGui.defaultOptions((Player)player);
                PlanetSelectionGui.deleteItems((Player)player);
                Methods.teleportButton((Player)player, Methods.mercury_orbit, true);
            }
            if (message.getInteger() == 16) {
                PlanetSelectionGui.defaultOptions((Player)player);
                PlanetSelectionGui.deleteItems((Player)player);
                Methods.teleportButton((Player)player, Methods.venus_orbit, true);
            }
            if (message.getInteger() == 17) {
                PlanetSelectionGui.defaultOptions((Player)player);
                PlanetSelectionGui.deleteItems((Player)player);
                Methods.teleportButton((Player)player, Methods.glacio_orbit, true);
            }
            context.setPacketHandled(true);
        }
    }

    public static class GuiContainer
    extends AbstractContainerMenu {
        String rocket;
        Player player;

        public GuiContainer(int id, Inventory inv, FriendlyByteBuf extraData) {
            super((MenuType)ScreensRegistry.PLANET_SELECTION_GUI.get(), id);
            this.rocket = extraData.m_130277_();
            this.player = inv.f_35978_;
        }

        public boolean m_6875_(Player player) {
            return !player.m_21224_();
        }

        public String getRocket() {
            return this.rocket;
        }

        public Player getPlayer() {
            return this.player;
        }
    }

    public static class GuiContainerFactory
    implements IContainerFactory<GuiContainer> {
        public GuiContainer create(int id, Inventory inv, FriendlyByteBuf extraData) {
            return new GuiContainer(id, inv, extraData);
        }
    }
}

