/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.screens.planetselection;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.BeyondEarthMod;
import net.mrscauthd.beyond_earth.crafting.IngredientStack;
import net.mrscauthd.beyond_earth.crafting.SpaceStationRecipe;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.guis.helper.ImageButtonPlacer;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGui;
import net.mrscauthd.beyond_earth.utils.Rectangle2d;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionGuiWindow
extends AbstractContainerScreen<PlanetSelectionGui.GuiContainer> {
    public static final ResourceLocation texture = new ResourceLocation("beyond_earth", "textures/screens/planet_selection.png");
    public static final ResourceLocation defaultButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/red_button.png");
    public static final ResourceLocation gbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/green_button.png");
    public static final ResourceLocation gb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/green_button_2.png");
    public static final ResourceLocation rbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/red_button.png");
    public static final ResourceLocation rb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/red_button_2.png");
    public static final ResourceLocation dbbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/dark_blue_button.png");
    public static final ResourceLocation dbb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/dark_blue_button_2.png");
    public static final ResourceLocation bbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/blue_button.png");
    public static final ResourceLocation bb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/blue_button_2.png");
    public static final ResourceLocation sbbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/small_blue_button.png");
    public static final ResourceLocation sbb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/small_blue_button_2.png");
    public static final ResourceLocation bgbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_green_button.png");
    public static final ResourceLocation bgb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_green_button_2.png");
    public static final ResourceLocation brbButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_red_button.png");
    public static final ResourceLocation brb2ButtonTex = new ResourceLocation("beyond_earth", "textures/buttons/big_red_button_2.png");
    public static final ResourceLocation solarSystemTex = new ResourceLocation("beyond_earth", "textures/solar_system.png");
    public static final ResourceLocation proximaCentauriTex = new ResourceLocation("beyond_earth", "textures/proxima_centauri.png");
    public static final ResourceLocation milkyWayTex = new ResourceLocation("beyond_earth", "textures/sky/gui/milky_way.png");
    public static final ResourceLocation sunTex = new ResourceLocation("beyond_earth", "textures/sky/gui/sun.png");
    public static final ResourceLocation blueSunTex = new ResourceLocation("beyond_earth", "textures/sky/gui/blue_sun.png");
    public static final ResourceLocation marsTex = new ResourceLocation("beyond_earth", "textures/sky/gui/mars.png");
    public static final ResourceLocation earthTex = new ResourceLocation("beyond_earth", "textures/sky/gui/earth.png");
    public static final ResourceLocation venusTex = new ResourceLocation("beyond_earth", "textures/sky/gui/venus.png");
    public static final ResourceLocation mercuryTex = new ResourceLocation("beyond_earth", "textures/sky/gui/mercury.png");
    public static final ResourceLocation glacioTex = new ResourceLocation("beyond_earth", "textures/sky/gui/glacio.png");
    public static final ResourceLocation rocketMenuListTex = new ResourceLocation("beyond_earth", "textures/rocket_menu_list.png");
    public static final ResourceLocation rocketMenuListTex2 = new ResourceLocation("beyond_earth", "textures/rocket_menu_list_2.png");
    public static final Component catalogTEXT = PlanetSelectionGuiWindow.tl("catalog");
    public static final Component backTEXT = PlanetSelectionGuiWindow.tl("back");
    public static final Component sunTEXT = PlanetSelectionGuiWindow.tl("sun");
    public static final Component proxima_centauriTEXT = PlanetSelectionGuiWindow.tl("proxima_centauri");
    public static final Component solar_systemTEXT = PlanetSelectionGuiWindow.tl("solar_system");
    public static final Component solar_system_sunTEXT = PlanetSelectionGuiWindow.tl("solar_system_sun");
    public static final Component solar_system_proxima_centauriTEXT = PlanetSelectionGuiWindow.tl("solar_system_proxima_centauri");
    public static final Component earthTEXT = PlanetSelectionGuiWindow.tl("earth");
    public static final Component marsTEXT = PlanetSelectionGuiWindow.tl("mars");
    public static final Component mercuryTEXT = PlanetSelectionGuiWindow.tl("mercury");
    public static final Component venusTEXT = PlanetSelectionGuiWindow.tl("venus");
    public static final Component glacioTEXT = PlanetSelectionGuiWindow.tl("glacio");
    public static final Component planetTEXT = PlanetSelectionGuiWindow.tl("planet");
    public static final Component moonTEXT = PlanetSelectionGuiWindow.tl("moon");
    public static final Component orbitTEXT = PlanetSelectionGuiWindow.tl("orbit");
    public static final Component no_gravityTEXT = PlanetSelectionGuiWindow.tl("no_gravity");
    public static final Component space_stationTEXT = PlanetSelectionGuiWindow.tl("space_station");
    public static final Component categoryTEXT = PlanetSelectionGuiWindow.tl("category");
    public static final Component providedTEXT = PlanetSelectionGuiWindow.tl("provided");
    public static final Component typeTEXT = PlanetSelectionGuiWindow.tl("type");
    public static final Component gravityTEXT = PlanetSelectionGuiWindow.tl("gravity");
    public static final Component oxygenTEXT = PlanetSelectionGuiWindow.tl("oxygen");
    public static final Component temperatureTEXT = PlanetSelectionGuiWindow.tl("temperature");
    public static final Component oxygenTrueTEXT = PlanetSelectionGuiWindow.tl("oxygen.true");
    public static final Component oxygenFalseTEXT = PlanetSelectionGuiWindow.tl("oxygen.false");
    public static final Component item_requirementTEXT = PlanetSelectionGuiWindow.tl("item_requirement");
    public static final Component rocket_t1TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t1");
    public static final Component rocket_t2TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t2");
    public static final Component rocket_t3TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t3");
    public static final Component rocket_t4TEXT = new TranslatableComponent("entity.beyond_earth.rocket_t4");
    public int Category = -1;
    public float milkyWay = 0.0f;
    public float rotationMars = 0.0f;
    public float rotationEarth = 90.0f;
    public float rotationVenus = 180.0f;
    public float rotationMercury = 270.0f;
    public float rotationGlacio = 180.0f;
    public ImageButtonPlacer solarSystemButton;
    public ImageButtonPlacer proximaCentauriButton;
    public ImageButtonPlacer earthCategoryButton;
    public ImageButtonPlacer marsCategoryButton;
    public ImageButtonPlacer mercuryCategoryButton;
    public ImageButtonPlacer venusCategoryButton;
    public ImageButtonPlacer glacioCategoryButton;
    public ImageButtonPlacer earthButton;
    public ImageButtonPlacer moonButton;
    public ImageButtonPlacer marsButton;
    public ImageButtonPlacer mercuryButton;
    public ImageButtonPlacer venusButton;
    public ImageButtonPlacer glacioButton;
    public ImageButtonPlacer backButton;
    public ImageButtonPlacer earthOrbitButton;
    public ImageButtonPlacer moonOrbitButton;
    public ImageButtonPlacer marsOrbitButton;
    public ImageButtonPlacer mercuryOrbitButton;
    public ImageButtonPlacer venusOrbitButton;
    public ImageButtonPlacer glacioOrbitButton;
    public ImageButtonPlacer earthSpaceStationButton;
    public ImageButtonPlacer moonSpaceStationButton;
    public ImageButtonPlacer marsSpaceStationButton;
    public ImageButtonPlacer mercurySpaceStationButton;
    public ImageButtonPlacer venusSpaceStationButton;
    public ImageButtonPlacer glacioSpaceStationButton;
    private SpaceStationRecipe recipe;
    private boolean spaceStationItemList;

    public PlanetSelectionGuiWindow(PlanetSelectionGui.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 512;
        this.f_97727_ = 512;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        this.milkyWay = (this.milkyWay + partialTicks * 0.4f) % 360.0f;
        this.rotationMars = (this.rotationMars + partialTicks * 0.4f) % 360.0f;
        this.rotationEarth = (this.rotationEarth + partialTicks * 0.8f) % 360.0f;
        this.rotationVenus = (this.rotationVenus + partialTicks * 0.7f) % 360.0f;
        this.rotationMercury = (this.rotationMercury + partialTicks * 0.7f) % 360.0f;
        this.rotationGlacio = (this.rotationGlacio + partialTicks * 0.7f) % 360.0f;
        String rocketType = ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket;
        if (this.Category == -1) {
            this.solarSystemButton.f_93624_ = true;
            this.proximaCentauriButton.f_93624_ = true;
            this.categoryButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 34, 70, 20, ms, this.solarSystemButton, sunTEXT, solar_systemTEXT);
            this.categoryButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.proximaCentauriButton, proxima_centauriTEXT, solar_systemTEXT);
        } else {
            this.solarSystemButton.f_93624_ = false;
            this.proximaCentauriButton.f_93624_ = false;
        }
        if (this.Category == 0) {
            this.earthCategoryButton.f_93624_ = true;
            this.marsCategoryButton.f_93624_ = true;
            this.mercuryCategoryButton.f_93624_ = true;
            this.venusCategoryButton.f_93624_ = true;
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.earthCategoryButton, earthTEXT, 1);
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 10, 70, 20, ms, this.marsCategoryButton, marsTEXT, 2);
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 32, 70, 20, ms, this.mercuryCategoryButton, mercuryTEXT, 3);
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 54, 70, 20, ms, this.venusCategoryButton, venusTEXT, 3);
        } else {
            this.earthCategoryButton.f_93624_ = false;
            this.marsCategoryButton.f_93624_ = false;
            this.mercuryCategoryButton.f_93624_ = false;
            this.venusCategoryButton.f_93624_ = false;
        }
        if (this.Category >= 0) {
            this.backButton.f_93624_ = true;
            this.backButtonManager(dbbButtonTex, dbb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 34, 70, 20, this.backButton);
        } else {
            this.backButton.f_93624_ = false;
        }
        if (this.Category == 1) {
            this.earthButton.f_93624_ = true;
            this.earthOrbitButton.f_93624_ = true;
            this.earthSpaceStationButton.f_93624_ = true;
            this.moonButton.f_93624_ = true;
            this.moonOrbitButton.f_93624_ = true;
            this.moonSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.earthButton, planetTEXT, "9.807 m/s", true, "a", 14);
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 + 10, 70, 20, ms, this.moonButton, moonTEXT, "1.62 m/s", false, "c", -160);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.earthOrbitButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 + 10, 37, 20, ms, this.moonOrbitButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.earthSpaceStationButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 + 10, 75, 20, ms, this.moonSpaceStationButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
        } else {
            this.earthButton.f_93624_ = false;
            this.earthOrbitButton.f_93624_ = false;
            this.earthSpaceStationButton.f_93624_ = false;
            this.moonButton.f_93624_ = false;
            this.moonOrbitButton.f_93624_ = false;
            this.moonSpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 2) {
            this.marsButton.f_93624_ = true;
            this.marsOrbitButton.f_93624_ = true;
            this.marsSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.marsButton, planetTEXT, "3.721 m/s", false, "a", -63);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.marsOrbitButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.marsSpaceStationButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
        } else {
            this.marsButton.f_93624_ = false;
            this.marsOrbitButton.f_93624_ = false;
            this.marsSpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 3) {
            this.mercuryButton.f_93624_ = true;
            this.mercuryOrbitButton.f_93624_ = true;
            this.mercurySpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.mercuryButton, planetTEXT, "3.7 m/s", false, "a", 430);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.mercuryOrbitButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.mercurySpaceStationButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
        } else {
            this.mercuryButton.f_93624_ = false;
            this.mercuryOrbitButton.f_93624_ = false;
            this.mercurySpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 4) {
            this.venusButton.f_93624_ = true;
            this.venusOrbitButton.f_93624_ = true;
            this.venusSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.venusButton, planetTEXT, "8.87 m/s", false, "a", 482);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.venusOrbitButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.venusSpaceStationButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
        } else {
            this.venusButton.f_93624_ = false;
            this.venusOrbitButton.f_93624_ = false;
            this.venusSpaceStationButton.f_93624_ = false;
        }
        if (this.Category == 5) {
            this.glacioCategoryButton.f_93624_ = true;
            this.buttonManager(rocketType, gb2ButtonTex, rb2ButtonTex, gbButtonTex, rbButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.glacioCategoryButton, glacioTEXT, 4);
        } else {
            this.glacioCategoryButton.f_93624_ = false;
        }
        if (this.Category == 6) {
            this.glacioButton.f_93624_ = true;
            this.glacioOrbitButton.f_93624_ = true;
            this.glacioSpaceStationButton.f_93624_ = true;
            this.teleportButtonManager(bbButtonTex, bb2ButtonTex, mouseX, mouseY, 10, this.f_96544_ / 2 - 12, 70, 20, ms, this.glacioButton, planetTEXT, "3.721 m/s", true, "a", -20);
            this.teleportButtonManager(sbbButtonTex, sbb2ButtonTex, mouseX, mouseY, 84, this.f_96544_ / 2 - 12, 37, 20, ms, this.glacioOrbitButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
            this.spaceStationCreatorButtonManager(brbButtonTex, brb2ButtonTex, bgbButtonTex, bgb2ButtonTex, mouseX, mouseY, 125, this.f_96544_ / 2 - 12, 75, 20, ms, this.glacioSpaceStationButton, orbitTEXT, no_gravityTEXT, false, "c", -270);
        } else {
            this.glacioButton.f_93624_ = false;
            this.glacioOrbitButton.f_93624_ = false;
            this.glacioSpaceStationButton.f_93624_ = false;
        }
        this.f_96547_.m_92889_(ms, catalogTEXT, 24.0f, (float)(this.f_96544_ / 2 - 71), -1);
    }

    protected void m_7286_(PoseStack ms, float p_97788_, int p_97789_, int p_97790_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)this.f_96544_, (int)this.f_96543_, (int)this.f_96544_);
        if (this.Category >= 0 && this.Category <= 4) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)solarSystemTex);
            GuiHelper.blit(ms, (this.f_96543_ - 185) / 2, (this.f_96544_ - 185) / 2, 0.0f, 0.0f, 185.0f, 185.0f, 185, 185);
        }
        if (this.Category >= 5 && this.Category <= 6) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)proximaCentauriTex);
            GuiHelper.blit(ms, (this.f_96543_ - 185) / 2, (this.f_96544_ - 185) / 2, 0.0f, 0.0f, 185.0f, 185.0f, 185, 185);
        }
        if (this.Category >= 0 && this.Category <= 4) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)sunTex);
            GuiHelper.blit(ms, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 0.0f, 0.0f, 15.0f, 15.0f, 15, 15);
        } else if (this.Category >= 5 && this.Category <= 6) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)blueSunTex);
            GuiHelper.blit(ms, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 0.0f, 0.0f, 15.0f, 15.0f, 15, 15);
        }
        if (this.Category == -1) {
            this.addGalaxy(ms, milkyWayTex, -125.0f, -125.0f, 250, 250, this.milkyWay);
        }
        if (this.Category >= 0 && this.Category <= 4) {
            this.addPlanet(ms, marsTex, -70.0f, -70.0f, 10, 10, this.rotationMars);
            this.addPlanet(ms, earthTex, -54.0f, -54.0f, 10, 10, this.rotationEarth);
            this.addPlanet(ms, venusTex, -37.0f, -37.0f, 10, 10, this.rotationVenus);
            this.addPlanet(ms, mercuryTex, -20.5f, -20.5f, 10, 10, this.rotationMercury);
        } else if (this.Category >= 5 && this.Category <= 6) {
            this.addPlanet(ms, glacioTex, -20.5f, -20.5f, 10, 10, this.rotationGlacio);
        }
        if (this.Category < 1 || this.Category == 5) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)rocketMenuListTex);
            GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)(this.f_96544_ / 2 - 88), (float)0.0f, (float)0.0f, (int)105, (int)177, (int)105, (int)177);
        } else if (this.Category >= 1 && this.Category <= 4 || this.Category >= 5 && this.Category <= 6) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)rocketMenuListTex2);
            GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)(this.f_96544_ / 2 - 88), (float)0.0f, (float)0.0f, (int)215, (int)177, (int)215, (int)177);
        }
        RenderSystem.m_69461_();
    }

    public void addPlanet(PoseStack ms, ResourceLocation planet, float x, float y, int width, int height, float rotation) {
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ / 2), 0.0);
        ms.m_85845_(new Quaternion(Vector3f.f_122227_, rotation, true));
        RenderSystem.m_157456_((int)0, (ResourceLocation)planet);
        GuiHelper.blit(ms, x, y, 0.0f, 0.0f, width, height, width, height);
        ms.m_85837_((double)(-this.f_96543_ / 2), (double)(-this.f_96544_ / 2), 0.0);
        ms.m_85849_();
    }

    public void addGalaxy(PoseStack ms, ResourceLocation planet, float x, float y, int width, int height, float rotation) {
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ / 2), 0.0);
        ms.m_85845_(new Quaternion(Vector3f.f_122227_, rotation, true));
        RenderSystem.m_157456_((int)0, (ResourceLocation)planet);
        GuiHelper.blit(ms, x, y, 0.0f, 0.0f, width, height, width, height);
        ms.m_85837_((double)(-this.f_96543_ / 2), (double)(-this.f_96544_ / 2), 0.0);
        ms.m_85849_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.recipe = this.f_96541_.f_91073_.m_7465_().m_44043_(SpaceStationRecipe.KEY).orElse(null);
        this.spaceStationItemList = this.recipe.getIngredientStacks().stream().allMatch(this::getSpaceStationItemCheck);
        this.solarSystemButton = this.addImageButtonSetSolarSystem(10, this.f_96544_ / 2 - 34, 70, 20, bbButtonTex, 0, solar_system_sunTEXT);
        this.proximaCentauriButton = this.addImageButtonSetSolarSystem(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 5, solar_system_proxima_centauriTEXT);
        this.earthCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 - 12, 70, 20, defaultButtonTex, 1, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 1, earthTEXT);
        this.earthCategoryButton.f_93624_ = false;
        this.marsCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 + 10, 70, 20, defaultButtonTex, 2, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 2, marsTEXT);
        this.marsCategoryButton.f_93624_ = false;
        this.mercuryCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 + 32, 70, 20, defaultButtonTex, 3, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 3, mercuryTEXT);
        this.mercuryCategoryButton.f_93624_ = false;
        this.venusCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 + 54, 70, 20, defaultButtonTex, 4, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 3, venusTEXT);
        this.venusCategoryButton.f_93624_ = false;
        this.glacioCategoryButton = this.addImageButtonSetCategory(10, this.f_96544_ / 2 - 12, 70, 20, defaultButtonTex, 6, ((PlanetSelectionGui.GuiContainer)this.f_97732_).rocket, 4, glacioTEXT);
        this.glacioCategoryButton.f_93624_ = false;
        this.backButton = this.addImageButtonBack(10, this.f_96544_ / 2 - 34, 70, 20, dbbButtonTex, backTEXT);
        this.backButton.f_93624_ = false;
        this.earthButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 0, earthTEXT);
        this.earthButton.f_93624_ = false;
        this.moonButton = this.addImageButton(10, this.f_96544_ / 2 + 10, 70, 20, bbButtonTex, 1, moonTEXT);
        this.moonButton.f_93624_ = false;
        this.marsButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 2, marsTEXT);
        this.marsButton.f_93624_ = false;
        this.mercuryButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 3, mercuryTEXT);
        this.mercuryButton.f_93624_ = false;
        this.venusButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 4, venusTEXT);
        this.venusButton.f_93624_ = false;
        this.glacioButton = this.addImageButton(10, this.f_96544_ / 2 - 12, 70, 20, bbButtonTex, 5, glacioTEXT);
        this.glacioButton.f_93624_ = false;
        this.earthOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 6, orbitTEXT);
        this.earthOrbitButton.f_93624_ = false;
        this.moonOrbitButton = this.addImageButton(84, this.f_96544_ / 2 + 10, 37, 20, sbbButtonTex, 7, orbitTEXT);
        this.moonOrbitButton.f_93624_ = false;
        this.marsOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 8, orbitTEXT);
        this.marsOrbitButton.f_93624_ = false;
        this.mercuryOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 9, orbitTEXT);
        this.mercuryOrbitButton.f_93624_ = false;
        this.venusOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 10, orbitTEXT);
        this.venusOrbitButton.f_93624_ = false;
        this.glacioOrbitButton = this.addImageButton(84, this.f_96544_ / 2 - 12, 37, 20, sbbButtonTex, 11, orbitTEXT);
        this.glacioOrbitButton.f_93624_ = false;
        this.earthSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 12, space_stationTEXT, this.spaceStationItemList);
        this.earthSpaceStationButton.f_93624_ = false;
        this.moonSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 + 10, 75, 20, brbButtonTex, 13, space_stationTEXT, this.spaceStationItemList);
        this.moonSpaceStationButton.f_93624_ = false;
        this.marsSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 14, space_stationTEXT, this.spaceStationItemList);
        this.marsSpaceStationButton.f_93624_ = false;
        this.mercurySpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 15, space_stationTEXT, this.spaceStationItemList);
        this.mercurySpaceStationButton.f_93624_ = false;
        this.venusSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 16, space_stationTEXT, this.spaceStationItemList);
        this.venusSpaceStationButton.f_93624_ = false;
        this.glacioSpaceStationButton = this.addSpaceStationImageButton(125, this.f_96544_ / 2 - 12, 75, 20, brbButtonTex, 17, space_stationTEXT, this.spaceStationItemList);
        this.glacioSpaceStationButton.f_93624_ = false;
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    public Rectangle2d getBounds(int left, int top, int width, int height) {
        return GuiHelper.getBounds(left, top, width, height);
    }

    public boolean checkTier(String rocketType, int stage) {
        int tier = 0;
        if (rocketType.equals("entity.beyond_earth.rocket_t1")) {
            tier = 1;
        }
        if (rocketType.equals("entity.beyond_earth.rocket_t2")) {
            tier = 2;
        }
        if (rocketType.equals("entity.beyond_earth.rocket_t3")) {
            tier = 3;
        }
        if (rocketType.equals("entity.beyond_earth.rocket_t4")) {
            tier = 4;
        }
        return tier >= stage;
    }

    public void buttonManager(String rocketType, ResourceLocation gb2, ResourceLocation rb2, ResourceLocation gb, ResourceLocation rb, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component dim, int stage) {
        String level = "c";
        if (this.checkTier(rocketType, stage)) {
            level = "a";
            button.setTexture(gb);
        } else {
            level = "c";
            button.setTexture(rb);
        }
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + categoryTEXT.getString() + ": \u00a7" + level + dim.getString()));
            list.add(new TextComponent("\u00a79" + providedTEXT.getString() + ": \u00a7b" + PlanetSelectionGuiWindow.getRocket(stage).getString()));
            this.m_96597_(ms, list, mouseX, mouseY);
            if (this.checkTier(rocketType, stage)) {
                button.setTexture(gb2);
            } else {
                button.setTexture(rb2);
            }
        }
    }

    public void categoryButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component solarSystem, Component type) {
        button.setTexture(bb);
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + categoryTEXT.getString() + ": \u00a7b" + solarSystem.getString()));
            list.add(new TextComponent("\u00a79" + typeTEXT.getString() + ": \u00a73" + type.getString()));
            this.m_96597_(ms, list, mouseX, mouseY);
            button.setTexture(bb2);
        }
    }

    public void teleportButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component planetType, String gravity, boolean oxygen, String temperatureColor, int temperature) {
        this.teleportButtonManager(bb, bb2, mouseX, mouseY, left, top, width, height, ms, button, planetType, (Component)new TextComponent(gravity), oxygen, temperatureColor, temperature);
    }

    public void teleportButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component planetType, Component gravity, boolean oxygen, String temperatureColor, int temperature) {
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + typeTEXT.getString() + ": \u00a73" + planetType.getString()));
            list.add(new TextComponent("\u00a79" + gravityTEXT.getString() + ": \u00a73" + gravity.getString()));
            list.add(new TextComponent("\u00a79" + oxygenTEXT.getString() + ": \u00a7" + (oxygen ? "a" + oxygenTrueTEXT.getString() : "c" + oxygenFalseTEXT.getString())));
            list.add(new TextComponent("\u00a79" + temperatureTEXT.getString() + ": \u00a7" + temperatureColor + temperature));
            this.m_96597_(ms, list, mouseX, mouseY);
            button.setTexture(bb2);
        } else {
            button.setTexture(bb);
        }
    }

    public void spaceStationCreatorButtonManager(ResourceLocation brb, ResourceLocation brb2, ResourceLocation bbb, ResourceLocation bbb2, int mouseX, int mouseY, int left, int top, int width, int height, PoseStack ms, ImageButtonPlacer button, Component orbitType, Component gravity, boolean oxygen, String temperatureColor, int temperature) {
        if (this.spaceStationItemList) {
            button.setTexture(bbb);
        } else {
            button.setTexture(brb);
        }
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + item_requirementTEXT.getString()));
            for (IngredientStack ingredientStack : this.recipe.getIngredientStacks()) {
                boolean check = this.getSpaceStationItemCheck(ingredientStack);
                Component component = Arrays.stream(ingredientStack.getIngredient().m_43908_()).findFirst().map(ItemStack::m_41786_).orElse(TextComponent.f_131282_);
                list.add(new TextComponent("\u00a78[\u00a76" + ingredientStack.getCount() + "\u00a78]" + (check ? "\u00a7a" : "\u00a7c") + " " + component.getString() + (ingredientStack.getCount() > 1 ? "'s" : "")));
            }
            list.add(new TextComponent("\u00a7c----------------"));
            list.add(new TextComponent("\u00a79" + typeTEXT.getString() + ": \u00a73" + orbitType.getString()));
            list.add(new TextComponent("\u00a79" + gravityTEXT.getString() + ": \u00a73" + gravity.getString()));
            list.add(new TextComponent("\u00a79" + oxygenTEXT.getString() + ": \u00a7" + (oxygen ? "a" + oxygenTrueTEXT.getString() : "c" + oxygenFalseTEXT.getString())));
            list.add(new TextComponent("\u00a79" + temperatureTEXT.getString() + ": \u00a7" + temperatureColor + temperature));
            this.m_96597_(ms, list, mouseX, mouseY);
            if (this.spaceStationItemList) {
                button.setTexture(bbb2);
            } else {
                button.setTexture(brb2);
            }
        }
    }

    public boolean getSpaceStationItemCheck(IngredientStack ingredientStack) {
        if (((PlanetSelectionGui.GuiContainer)this.f_97732_).player.m_150110_().f_35937_ || ((PlanetSelectionGui.GuiContainer)this.f_97732_).player.m_5833_()) {
            return true;
        }
        Inventory inv = ((PlanetSelectionGui.GuiContainer)this.f_97732_).player.m_150109_();
        int itemStackCount = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (!ingredientStack.testWithoutCount(itemStack)) continue;
            itemStackCount += itemStack.m_41613_();
        }
        return itemStackCount >= ingredientStack.getCount();
    }

    public static Component getRocket(int tier) {
        if (tier == 1) {
            return rocket_t1TEXT;
        }
        if (tier == 2) {
            return rocket_t2TEXT;
        }
        if (tier == 3) {
            return rocket_t3TEXT;
        }
        return rocket_t4TEXT;
    }

    public static Component tl(String string) {
        return new TranslatableComponent("gui.beyond_earth.planet_selection." + string);
    }

    public void backButtonManager(ResourceLocation bb, ResourceLocation bb2, int mouseX, int mouseY, int left, int top, int width, int height, ImageButtonPlacer button) {
        if (GuiHelper.isHover(this.getBounds(left, top, width, height), mouseX, mouseY)) {
            button.setTexture(bb2);
        } else {
            button.setTexture(bb);
        }
    }

    public ImageButtonPlacer addImageButton(int xIn, int yIn, int width, int height, ResourceLocation texture, int handler, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> BeyondEarthMod.PACKET_HANDLER.sendToServer((Object)new PlanetSelectionGui.NetworkHandler(handler)), title));
        return button;
    }

    public ImageButtonPlacer addSpaceStationImageButton(int xIn, int yIn, int width, int height, ResourceLocation texture, int handler, Component title, boolean condition) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            if (condition) {
                BeyondEarthMod.PACKET_HANDLER.sendToServer((Object)new PlanetSelectionGui.NetworkHandler(handler));
            }
        }, title));
        return button;
    }

    public ImageButtonPlacer addImageButtonSetCategory(int xIn, int yIn, int width, int height, ResourceLocation texture, int newCategory, String rocket, int stage, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            if (this.checkTier(rocket, stage)) {
                this.Category = newCategory;
            }
        }, title));
        return button;
    }

    public ImageButtonPlacer addImageButtonBack(int xIn, int yIn, int width, int height, ResourceLocation texture, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            this.Category = this.Category >= 1 && this.Category <= 4 ? 0 : (this.Category == 5 ? -1 : (this.Category >= 6 && this.Category <= 6 ? 5 : --this.Category));
        }, title));
        return button;
    }

    public ImageButtonPlacer addImageButtonSetSolarSystem(int xIn, int yIn, int width, int height, ResourceLocation texture, int newCategory, Component title) {
        ImageButtonPlacer button = (ImageButtonPlacer)this.m_142416_((GuiEventListener)new ImageButtonPlacer(xIn, yIn, width, height, 0, 0, 0, texture, width, height, p_2130901 -> {
            this.Category = newCategory;
        }, title));
        return button;
    }
}

