/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.version;

import com.google.common.io.CharStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import journeymap.common.version.Version;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class VersionCheck {
    private static volatile ExecutorService executorService;
    private static volatile Boolean updateCheckEnabled;
    private static volatile Boolean versionIsCurrent;
    private static volatile Boolean versionIsChecked;
    private static volatile String versionAvailable;
    private static volatile String downloadUrl;

    public static Boolean getVersionIsCurrent() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsCurrent;
    }

    public static Boolean getVersionIsChecked() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionIsChecked;
    }

    public static String getVersionAvailable() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return versionAvailable;
    }

    public static String getDownloadUrl() {
        if (versionIsChecked == null) {
            VersionCheck.checkVersion();
        }
        return downloadUrl;
    }

    private static synchronized void checkVersion() {
        versionIsChecked = false;
        versionIsCurrent = true;
        versionAvailable = "0";
        if (!updateCheckEnabled.booleanValue()) {
            Journeymap.getLogger().info("Update check disabled in properties file.");
        } else {
            executorService = Executors.newSingleThreadExecutor(new JMThreadFactory("VersionCheck"));
            try {
                executorService.submit(() -> {
                    String currentVersion = Journeymap.JM_VERSION.toString();
                    boolean currentIsRelease = Journeymap.JM_VERSION.isRelease();
                    JsonObject project = VersionCheck.makeGetRequest(Journeymap.VERSION_URL);
                    JsonObject downloadUrls = VersionCheck.makeGetRequest(Journeymap.VERSION_URL + "/references");
                    if (project != null && downloadUrls != null) {
                        JsonObject promos = project.get("promos").getAsJsonObject();
                        Set versions = project.get("promos").getAsJsonObject().keySet();
                        if (versions == null) {
                            Journeymap.getLogger().warn("No versions found online for " + MCPVersion.getMCVersion());
                        } else {
                            for (String name : versions) {
                                String file = promos.get(name).getAsString();
                                try {
                                    if (currentIsRelease && !name.contains("recommended") || !name.contains(MCPVersion.getMCVersion())) continue;
                                    downloadUrl = downloadUrls.get(name).getAsString();
                                    if (VersionCheck.isCurrent(currentVersion, file)) continue;
                                    versionAvailable = file;
                                    versionIsCurrent = false;
                                    versionIsChecked = true;
                                    Journeymap.getLogger().info(String.format("Newer version online: JourneyMap %s for Minecraft %s on %s", versionAvailable, MCPVersion.getMCVersion(), downloadUrl));
                                    break;
                                }
                                catch (Exception e) {
                                    Journeymap.getLogger().error("Could not parse download info: " + file, (Throwable)e);
                                }
                            }
                        }
                        if (!versionIsChecked.booleanValue()) {
                            versionAvailable = currentVersion;
                            versionIsCurrent = true;
                            versionIsChecked = true;
                            downloadUrl = Journeymap.DOWNLOAD_URL;
                        }
                    }
                    if (!versionIsCurrent.booleanValue()) {
                        // empty if block
                    }
                });
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error with version checking");
            }
            finally {
                executorService.shutdown();
                executorService = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject makeGetRequest(String url) {
        InputStreamReader in = null;
        try {
            URI uri = URI.create(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).setRedirectsEnabled(true).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            HttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(uri));
            if (response.getStatusLine().getStatusCode() / 200 == 1) {
                in = new InputStreamReader(response.getEntity().getContent());
                String rawResponse = CharStreams.toString((Readable)in);
                JsonObject jsonObject = JsonParser.parseString((String)rawResponse).getAsJsonObject();
                return jsonObject;
            }
            Journeymap.getLogger().error(String.format("Version check to %s returned: %s ", uri, response.getStatusLine()));
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Could not check version URL", e);
            updateCheckEnabled = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static boolean isCurrent(String thisVersionStr, String availableVersionStr) {
        if (thisVersionStr.equals(availableVersionStr)) {
            return true;
        }
        Version thisVersion = Version.from(thisVersionStr, null);
        Version availableVersion = Version.from(availableVersionStr, null);
        return !availableVersion.isNewerThan(thisVersion);
    }

    static {
        updateCheckEnabled = JourneymapClient.getInstance().isUpdateCheckEnabled();
        versionIsCurrent = true;
    }
}

