/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyStorageUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryModificationHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.LootHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class BackpackWrapper
implements IBackpackWrapper {
    public static final int DEFAULT_CLOTH_COLOR = 13394234;
    public static final int DEFAULT_BORDER_COLOR = 6434330;
    private static final String CLOTH_COLOR_TAG = "clothColor";
    private static final String BORDER_COLOR_TAG = "borderColor";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    private static final String SORT_BY_TAG = "sortBy";
    private static final String CONTENTS_UUID_TAG = "contentsUuid";
    private static final String INVENTORY_SLOTS_TAG = "inventorySlots";
    private static final String UPGRADE_SLOTS_TAG = "upgradeSlots";
    private static final String LOOT_TABLE_NAME_TAG = "lootTableName";
    private static final String LOOT_PERCENTAGE_TAG = "lootPercentage";
    private static final String COLUMNS_TAKEN_TAG = "columnsTaken";
    private final ItemStack backpack;
    private Runnable backpackSaveHandler = () -> {};
    private Runnable inventorySlotChangeHandler = () -> {};
    @Nullable
    private InventoryHandler handler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private InventoryModificationHandler inventoryModificationHandler = null;
    @Nullable
    private BackpackSettingsHandler settingsHandler = null;
    private boolean fluidHandlerInitialized = false;
    @Nullable
    private IStorageFluidHandler fluidHandler = null;
    private boolean energyStorageInitialized = false;
    @Nullable
    private IEnergyStorage energyStorage = null;
    private final BackpackRenderInfo renderInfo;

    public BackpackWrapper(ItemStack backpack) {
        this.backpack = backpack;
        this.renderInfo = new BackpackRenderInfo(backpack, () -> this.backpackSaveHandler);
    }

    @Override
    public void setSaveHandler(Runnable saveHandler) {
        this.backpackSaveHandler = saveHandler;
        this.refreshInventoryForUpgradeProcessing();
    }

    @Override
    public void setInventorySlotChangeHandler(Runnable slotChangeHandler) {
        this.inventorySlotChangeHandler = slotChangeHandler;
    }

    @Override
    public IItemHandlerSimpleInserter getInventoryForUpgradeProcessing() {
        if (this.inventoryModificationHandler == null) {
            this.inventoryModificationHandler = new InventoryModificationHandler(this);
        }
        return this.inventoryModificationHandler.getModifiedInventoryHandler();
    }

    @Override
    public InventoryHandler getInventoryHandler() {
        if (this.handler == null) {
            this.handler = new BackpackInventoryHandler(this.getNumberOfInventorySlots() - this.getNumberOfSlotRows() * this.getColumnsTaken(), this, this.getBackpackContentsNbt(), () -> {
                this.markBackpackContentsDirty();
                this.inventorySlotChangeHandler.run();
            }, StackUpgradeItem.getInventorySlotLimit(this));
            this.handler.addListener(this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)::itemChanged);
        }
        return this.handler;
    }

    private int getNumberOfInventorySlots() {
        Optional<Integer> inventorySlots = NBTHelper.getInt(this.backpack, INVENTORY_SLOTS_TAG);
        if (inventorySlots.isPresent()) {
            return inventorySlots.get();
        }
        int itemInventorySlots = ((BackpackItem)this.backpack.m_41720_()).getNumberOfSlots();
        this.setNumberOfInventorySlots(itemInventorySlots);
        return itemInventorySlots;
    }

    @Override
    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    private void setNumberOfInventorySlots(int itemInventorySlots) {
        NBTHelper.setInteger(this.backpack, INVENTORY_SLOTS_TAG, itemInventorySlots);
    }

    private CompoundTag getBackpackContentsNbt() {
        return BackpackStorage.get().getOrCreateBackpackContents(this.getOrCreateContentsUuid());
    }

    private void markBackpackContentsDirty() {
        BackpackStorage.get().m_77762_();
    }

    @Override
    public IItemHandlerSimpleInserter getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler(this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    @Override
    public Optional<IStorageFluidHandler> getFluidHandler() {
        if (!this.fluidHandlerInitialized) {
            IStorageFluidHandler wrappedHandler = this.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE).isEmpty() ? null : new BackpackFluidHandler(this);
            List<IFluidHandlerWrapperUpgrade> fluidHandlerWrapperUpgrades = this.getUpgradeHandler().getWrappersThatImplement(IFluidHandlerWrapperUpgrade.class);
            for (IFluidHandlerWrapperUpgrade fluidHandlerWrapperUpgrade : fluidHandlerWrapperUpgrades) {
                wrappedHandler = fluidHandlerWrapperUpgrade.wrapHandler(wrappedHandler, this.backpack);
            }
            this.fluidHandler = wrappedHandler;
        }
        return Optional.ofNullable(this.fluidHandler);
    }

    @Override
    public Optional<IEnergyStorage> getEnergyStorage() {
        if (!this.energyStorageInitialized) {
            IEnergyStorage wrappedStorage = this.getUpgradeHandler().getWrappersThatImplement(IEnergyStorage.class).stream().findFirst().orElse(null);
            for (IEnergyStorageUpgradeWrapper energyStorageWrapperUpgrade : this.getUpgradeHandler().getWrappersThatImplement(IEnergyStorageUpgradeWrapper.class)) {
                wrappedStorage = energyStorageWrapperUpgrade.wrapStorage(wrappedStorage);
            }
            this.energyStorage = wrappedStorage;
        }
        return this.energyStorage == null || this.energyStorage.getMaxEnergyStored() == 0 ? Optional.empty() : Optional.of(this.energyStorage);
    }

    @Override
    public void copyDataTo(IStorageWrapper otherStorageWrapper) {
        this.getContentsUuid().ifPresent(originalUuid -> {
            this.getInventoryHandler().copyStacksTo(otherStorageWrapper.getInventoryHandler());
            this.getUpgradeHandler().copyTo(otherStorageWrapper.getUpgradeHandler());
            this.getSettingsHandler().copyTo(otherStorageWrapper.getSettingsHandler());
        });
    }

    @Override
    public BackpackSettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new BackpackSettingsHandler(this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty) : IBackpackWrapper.Noop.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    @Override
    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = this.getContentsUuid().isPresent() ? new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty, () -> {
                if (this.handler != null) {
                    this.handler.clearListeners();
                    this.handler.setSlotLimit(StackUpgradeItem.getInventorySlotLimit(this));
                }
                this.getInventoryHandler().clearListeners();
                this.handler.addListener(this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)::itemChanged);
                this.inventoryIOHandler = null;
                this.inventoryModificationHandler = null;
                this.fluidHandlerInitialized = false;
                this.fluidHandler = null;
                this.energyStorageInitialized = false;
                this.energyStorage = null;
            }){

                @Override
                public boolean isItemValid(int slot, ItemStack stack) {
                    return super.isItemValid(slot, stack) && (stack.m_41619_() || "sophisticatedbackpacks".equals(stack.m_41720_().getRegistryName().m_135827_()) || stack.m_204117_(ModItems.BACKPACK_UPGRADE_TAG));
                }
            } : NoopStorageWrapper.INSTANCE.getUpgradeHandler();
        }
        return this.upgradeHandler;
    }

    private int getNumberOfUpgradeSlots() {
        Optional<Integer> upgradeSlots = NBTHelper.getInt(this.backpack, UPGRADE_SLOTS_TAG);
        if (upgradeSlots.isPresent()) {
            return upgradeSlots.get();
        }
        int itemUpgradeSlots = ((BackpackItem)this.backpack.m_41720_()).getNumberOfUpgradeSlots();
        this.setNumberOfUpgradeSlots(itemUpgradeSlots);
        return itemUpgradeSlots;
    }

    @Override
    public Optional<UUID> getContentsUuid() {
        return NBTHelper.getUniqueId(this.backpack, CONTENTS_UUID_TAG);
    }

    private UUID getOrCreateContentsUuid() {
        Optional<UUID> contentsUuid = this.getContentsUuid();
        if (contentsUuid.isPresent()) {
            return contentsUuid.get();
        }
        this.clearDummyHandlers();
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        this.migrateBackpackContents(newUuid);
        return newUuid;
    }

    private void clearDummyHandlers() {
        if (this.upgradeHandler == NoopStorageWrapper.INSTANCE.getUpgradeHandler()) {
            this.upgradeHandler = null;
        }
        if (this.settingsHandler == NoopStorageWrapper.INSTANCE.getSettingsHandler()) {
            this.settingsHandler = null;
        }
    }

    private void migrateBackpackContents(UUID newUuid) {
        this.migrateNbtTag(newUuid, "inventory");
        this.migrateNbtTag(newUuid, "upgradeInventory");
    }

    private void migrateNbtTag(UUID newUuid, String key) {
        NBTHelper.getCompound(this.backpack, key).ifPresent(nbt -> {
            BackpackStorage.get().getOrCreateBackpackContents(newUuid).m_128365_(key, (Tag)nbt);
            this.markBackpackContentsDirty();
            NBTHelper.removeTag(this.backpack, key);
        });
    }

    @Override
    public int getMainColor() {
        return NBTHelper.getInt(this.backpack, CLOTH_COLOR_TAG).orElse(13394234);
    }

    @Override
    public int getAccentColor() {
        return NBTHelper.getInt(this.backpack, BORDER_COLOR_TAG).orElse(6434330);
    }

    @Override
    public Optional<Integer> getOpenTabId() {
        return NBTHelper.getInt(this.backpack, OPEN_TAB_ID_TAG);
    }

    @Override
    public void setOpenTabId(int openTabId) {
        NBTHelper.setInteger(this.backpack, OPEN_TAB_ID_TAG, openTabId);
        this.backpackSaveHandler.run();
    }

    @Override
    public void removeOpenTabId() {
        this.backpack.m_41784_().m_128473_(OPEN_TAB_ID_TAG);
        this.backpackSaveHandler.run();
    }

    @Override
    public void setColors(int mainColor, int accentColor) {
        this.backpack.m_41700_(CLOTH_COLOR_TAG, (Tag)IntTag.m_128679_((int)mainColor));
        this.backpack.m_41700_(BORDER_COLOR_TAG, (Tag)IntTag.m_128679_((int)accentColor));
        this.backpackSaveHandler.run();
    }

    @Override
    public void setSortBy(SortBy sortBy) {
        this.backpack.m_41700_(SORT_BY_TAG, (Tag)StringTag.m_129297_((String)sortBy.m_7912_()));
        this.backpackSaveHandler.run();
    }

    @Override
    public SortBy getSortBy() {
        return NBTHelper.getEnumConstant(this.backpack, SORT_BY_TAG, SortBy::fromName).orElse(SortBy.NAME);
    }

    @Override
    public void sort() {
        HashSet<Integer> slotIndexesExcludedFromSort = new HashSet<Integer>();
        slotIndexesExcludedFromSort.addAll(this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotIndexes());
        InventorySorter.sortHandler(this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new IncompatibleClassChangeError();
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
        };
    }

    @Override
    public ItemStack getBackpack() {
        return this.backpack;
    }

    @Override
    public ItemStack cloneBackpack() {
        ItemStack clonedBackpack = this.cloneBackpack(this);
        clonedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(this::cloneSubbackpacks);
        return clonedBackpack;
    }

    private void cloneSubbackpacks(IStorageWrapper wrapperCloned) {
        InventoryHandler inventoryHandler = wrapperCloned.getInventoryHandler();
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            if (!(stack.m_41720_() instanceof BackpackItem)) {
                return;
            }
            inventoryHandler.setStackInSlot((int)slot, stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(this::cloneBackpack).orElse(ItemStack.f_41583_));
        });
    }

    private ItemStack cloneBackpack(IBackpackWrapper originalWrapper) {
        ItemStack backpackCopy = originalWrapper.getBackpack().m_41777_();
        backpackCopy.m_41749_(CONTENTS_UUID_TAG);
        return backpackCopy.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapperCopy -> {
            originalWrapper.copyDataTo((IStorageWrapper)wrapperCopy);
            return wrapperCopy.getBackpack();
        }).orElse(ItemStack.f_41583_);
    }

    @Override
    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.getInventoryHandler().setPersistent(persistent);
        this.getUpgradeHandler().setPersistent(persistent);
    }

    @Override
    public void setSlotNumbers(int numberOfInventorySlots, int numberOfUpgradeSlots) {
        this.setNumberOfInventorySlots(numberOfInventorySlots);
        this.setNumberOfUpgradeSlots(numberOfUpgradeSlots);
    }

    @Override
    public void setLoot(ResourceLocation lootTableName, float lootPercentage) {
        this.backpack.m_41700_(LOOT_TABLE_NAME_TAG, (Tag)StringTag.m_129297_((String)lootTableName.toString()));
        this.backpack.m_41700_(LOOT_PERCENTAGE_TAG, (Tag)FloatTag.m_128566_((float)lootPercentage));
        this.backpackSaveHandler.run();
    }

    @Override
    public void fillWithLoot(Player playerEntity) {
        if (playerEntity.f_19853_.f_46443_) {
            return;
        }
        NBTHelper.getString(this.backpack, LOOT_TABLE_NAME_TAG).ifPresent(ltName -> this.fillWithLootFromTable(playerEntity, (String)ltName));
    }

    @Override
    public void setContentsUuid(UUID storageUuid) {
        NBTHelper.setUniqueId(this.backpack, CONTENTS_UUID_TAG, storageUuid);
    }

    @Override
    public BackpackRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    @Override
    public void setColumnsTaken(int columnsTaken) {
        NBTHelper.setInteger(this.backpack, COLUMNS_TAKEN_TAG, columnsTaken);
    }

    @Override
    public int getColumnsTaken() {
        return NBTHelper.getInt(this.backpack, COLUMNS_TAKEN_TAG).orElse(0);
    }

    private void fillWithLootFromTable(Player playerEntity, String lootName) {
        Level level;
        MinecraftServer server = playerEntity.f_19853_.m_142572_();
        if (server == null || !((level = playerEntity.f_19853_) instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        ResourceLocation lootTableName = new ResourceLocation(lootName);
        float lootPercentage = NBTHelper.getFloat(this.backpack, LOOT_PERCENTAGE_TAG).orElse(Float.valueOf(0.0f)).floatValue();
        this.backpack.m_41749_(LOOT_TABLE_NAME_TAG);
        this.backpack.m_41749_(LOOT_PERCENTAGE_TAG);
        List<ItemStack> loot = LootHelper.getLoot(lootTableName, server, world, (Entity)playerEntity);
        loot = RandHelper.getNRandomElements(loot, (int)((float)loot.size() * lootPercentage));
        LootHelper.fillWithLoot(world.f_46441_, loot, this.getInventoryHandler());
    }

    private void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        NBTHelper.setInteger(this.backpack, UPGRADE_SLOTS_TAG, numberOfUpgradeSlots);
    }

    @Override
    public void refreshInventoryForUpgradeProcessing() {
        this.inventoryModificationHandler = null;
        this.fluidHandler = null;
        this.fluidHandlerInitialized = false;
        this.energyStorage = null;
        this.energyStorageInitialized = false;
        this.refreshInventoryForInputOutput();
    }

    @Override
    public void onContentsNbtUpdated() {
        this.handler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }

    @Override
    public ItemStack getWrappedStorageStack() {
        return this.getBackpack();
    }
}

