/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;

public class BackpackInsertMessage {
    private final int slotIndex;

    public BackpackInsertMessage(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public static void encode(BackpackInsertMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.slotIndex);
    }

    public static BackpackInsertMessage decode(FriendlyByteBuf packetBuffer) {
        return new BackpackInsertMessage(packetBuffer.readInt());
    }

    static void onMessage(BackpackInsertMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackInsertMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, BackpackInsertMessage msg) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu containerMenu = player.f_36096_;
        containerMenu.m_38853_(msg.slotIndex).m_7993_().getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            ItemStack heldItem = containerMenu.m_142621_();
            containerMenu.m_142503_(wrapper.getInventoryForUpgradeProcessing().insertItem(heldItem, false));
        });
    }
}

