/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackOpenMessage {
    private static final int CHEST_SLOT = 38;
    private static final int OFFHAND_SLOT = 40;
    private final int slotIndex;
    private final boolean isSubBackpack;

    public BackpackOpenMessage() {
        this(-1, false);
    }

    public BackpackOpenMessage(int backpackSlot, boolean isSubBackpack) {
        this.slotIndex = backpackSlot;
        this.isSubBackpack = isSubBackpack;
    }

    public static void encode(BackpackOpenMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.slotIndex);
        packetBuffer.writeBoolean(msg.isSubBackpack);
    }

    public static BackpackOpenMessage decode(FriendlyByteBuf packetBuffer) {
        return new BackpackOpenMessage(packetBuffer.readInt(), packetBuffer.readBoolean());
    }

    static void onMessage(BackpackOpenMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackOpenMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, BackpackOpenMessage msg) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackContainer) {
            BackpackContainer backpackContainer = (BackpackContainer)abstractContainerMenu;
            backpackContext = backpackContainer.getBackpackContext();
            if (msg.slotIndex == -1) {
                BackpackOpenMessage.openBackpack(player, ((BackpackContext)backpackContext).getParentBackpackContext());
            } else if (backpackContainer.isStorageInventorySlot(msg.slotIndex)) {
                BackpackOpenMessage.openBackpack(player, ((BackpackContext)backpackContext).getSubBackpackContext(msg.slotIndex));
            }
        } else {
            backpackContext = player.f_36096_;
            if (backpackContext instanceof IContextAwareContainer) {
                IContextAwareContainer contextAwareContainer = (IContextAwareContainer)backpackContext;
                backpackContext = contextAwareContainer.getBackpackContext();
                BackpackOpenMessage.openBackpack(player, (BackpackContext)backpackContext);
            } else if (msg.slotIndex > -1 && player.f_36096_ instanceof InventoryMenu) {
                int slotIndex = msg.slotIndex;
                String inventoryProvider = "main";
                if (msg.slotIndex == 38) {
                    inventoryProvider = "armor";
                } else if (msg.slotIndex == 40) {
                    inventoryProvider = "offhand";
                    slotIndex = 0;
                }
                BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryProvider, slotIndex, true);
                BackpackOpenMessage.openBackpack(player, backpackContext);
            } else {
                BackpackOpenMessage.findAndOpenFirstBackpack(player);
            }
        }
    }

    private static void findAndOpenFirstBackpack(ServerPlayer player) {
        PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, inventoryName, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, slot);
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpack.m_41786_()), backpackContext::toBuffer);
            return true;
        });
    }

    private static void openBackpack(ServerPlayer player, BackpackContext backpackContext) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext.getDisplayName((Player)player)), backpackContext::toBuffer);
    }
}

