/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.capability.data;

import fuzs.puzzleslib.capability.data.CapabilityComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityDispatcher<T extends CapabilityComponent>
implements ICapabilityProvider,
CapabilityComponent {
    private final Capability<T> capability;
    private final T storage;

    public CapabilityDispatcher(Capability<T> capability, T storage) {
        this.capability = capability;
        this.storage = storage;
    }

    @Nonnull
    public <S> LazyOptional<S> getCapability(@Nonnull Capability<S> capability, @Nullable Direction facing) {
        return capability == this.capability ? LazyOptional.of(() -> this.storage).cast() : LazyOptional.empty();
    }

    @Override
    public void write(CompoundTag tag) {
        this.storage.write(tag);
    }

    @Override
    public void read(CompoundTag tag) {
        this.storage.read(tag);
    }
}

