/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.renderer;

import chanceCubes.tileentities.TileChanceD20;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.Level;

public class TileChanceD20Renderer
implements BlockEntityRenderer<TileChanceD20> {
    private static final Random random = new Random();
    private static final float HOVER_SPEED = 6000.0f;
    private static final float ROTATION_SPEED = 100.0f;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public void render(TileChanceD20 d20, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        random.setSeed(432L);
        VertexConsumer vertexconsumer2 = bufferIn.m_6299_(RenderType.m_110502_());
        poseStack.m_85836_();
        Level level = d20.m_58904_();
        long gameTime = 0L;
        if (level != null) {
            gameTime = level.m_46467_();
        }
        float wave = d20.getStage() == 0 ? (float)(Math.sin((((float)gameTime % 6000.0f + partialTicks) / 6000.0f + random.nextFloat()) * 360.0f) * (double)0.3f) : ((float)d20.getStage() + partialTicks) / 70.0f;
        d20.wave = wave;
        float rotation = ((float)gameTime % 100.0f + partialTicks) / 100.0f;
        boolean f7 = false;
        float color = (float)(gameTime % 75L) / 75.0f;
        Color tmpClr = new Color(Color.HSBtoRGB(color, 1.0f, 1.0f));
        int r = tmpClr.getRed();
        int g = tmpClr.getGreen();
        int b = tmpClr.getBlue();
        poseStack.m_85837_(0.5, 0.5 + (double)wave, 0.5);
        int i = 0;
        while ((float)i < 5.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + rotation * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + (float)f7 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + (float)f7 * 2.0f;
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            int alpha = (int)(255.0f * (1.0f - (float)f7));
            TileChanceD20Renderer.vertex01(vertexconsumer2, matrix4f, r, g, b, alpha);
            TileChanceD20Renderer.vertex2(vertexconsumer2, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex3(vertexconsumer2, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex01(vertexconsumer2, matrix4f, r, g, b, alpha);
            TileChanceD20Renderer.vertex3(vertexconsumer2, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex4(vertexconsumer2, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex01(vertexconsumer2, matrix4f, r, g, b, alpha);
            TileChanceD20Renderer.vertex4(vertexconsumer2, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex2(vertexconsumer2, matrix4f, f3, f4, r, g, b, alpha);
            ++i;
        }
        poseStack.m_85849_();
    }

    private static void vertex01(VertexConsumer p_114220_, Matrix4f p_114221_, int r, int g, int b, int alpha) {
        p_114220_.m_85982_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_5752_();
    }

    private static void vertex2(VertexConsumer p_114215_, Matrix4f p_114216_, float p_114217_, float p_114218_, int r, int g, int b, int alpha) {
        p_114215_.m_85982_(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, -0.5f * p_114218_).m_6122_(r, g, b, alpha).m_5752_();
    }

    private static void vertex3(VertexConsumer p_114224_, Matrix4f p_114225_, float p_114226_, float p_114227_, int r, int g, int b, int alpha) {
        p_114224_.m_85982_(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, -0.5f * p_114227_).m_6122_(r, g, b, alpha).m_5752_();
    }

    private static void vertex4(VertexConsumer p_114229_, Matrix4f p_114230_, float p_114231_, float p_114232_, int r, int g, int b, int alpha) {
        p_114229_.m_85982_(p_114230_, 0.0f, p_114231_, p_114232_).m_6122_(r, g, b, alpha).m_5752_();
    }
}

