/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.blocks.BlockFallingCustom;
import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.rewardparts.BasePart;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class OffsetBlock
extends BasePart {
    protected BoolVar relativeToPlayer = new BoolVar(false);
    public final IntVar xOff;
    public final IntVar yOff;
    public final IntVar zOff;
    protected BlockState state;
    protected BoolVar falling;
    protected BoolVar causeUpdate = new BoolVar(false);
    private BoolVar removeUnbreakableBlocks = new BoolVar(false);
    protected BoolVar playSound = new BoolVar(true);

    public OffsetBlock(int x, int y, int z, Block b, boolean falling) {
        this(x, y, z, b.m_49966_(), falling);
    }

    public OffsetBlock(int x, int y, int z, Block b, BoolVar falling) {
        this(x, y, z, b, falling, new IntVar(0));
    }

    public OffsetBlock(int x, int y, int z, Block b, BoolVar falling, IntVar delay) {
        this(new IntVar(x), new IntVar(y), new IntVar(z), b.m_49966_(), falling, delay);
    }

    public OffsetBlock(int x, int y, int z, Block b, boolean falling, int delay) {
        this(x, y, z, b.m_49966_(), falling, delay);
    }

    public OffsetBlock(int x, int y, int z, BlockState state, boolean falling) {
        this(x, y, z, state, falling, 0);
    }

    public OffsetBlock(int x, int y, int z, BlockState state, boolean falling, int delay) {
        this(new IntVar(x), new IntVar(y), new IntVar(z), state, new BoolVar(falling), new IntVar(delay));
    }

    public OffsetBlock(IntVar x, IntVar y, IntVar z, Block b, BoolVar falling) {
        this(x, y, z, b.m_49966_(), falling, new IntVar(0));
    }

    public OffsetBlock(IntVar x, IntVar y, IntVar z, BlockState state, BoolVar falling, IntVar delay) {
        this.xOff = x;
        this.yOff = y;
        this.zOff = z;
        this.falling = falling;
        this.setDelay(delay);
        this.state = state;
    }

    public void spawnInWorld(Level level, int x, int y, int z) {
        this.spawnInWorld(level, x, y, z, null);
    }

    public void spawnInWorld(final Level level, final int x, final int y, final int z, final RewardBlockCache blockCache) {
        if (!this.falling.getBoolValue().booleanValue()) {
            Scheduler.scheduleTask(new Task("Delayed_Block", this.getDelay()){

                @Override
                public void callback() {
                    OffsetBlock.this.placeInWorld(level, new BlockPos(x, y, z), true, blockCache);
                }
            });
        } else {
            Scheduler.scheduleTask(new Task("Falling_Block", this.getDelay()){

                @Override
                public void callback() {
                    OffsetBlock.this.spawnFallingBlock(level, x, y, z, blockCache);
                }
            });
        }
    }

    protected void spawnFallingBlock(Level level, int x, int y, int z, RewardBlockCache blockCache) {
        int xOffVal = this.xOff.getIntValue();
        int yOffVal = this.yOff.getIntValue();
        int zOffVal = this.zOff.getIntValue();
        double yy = (double)(y + yOffVal + (Integer)CCubesSettings.dropHeight.get()) + 0.5 >= 256.0 ? 255.0 : (double)(y + yOffVal + (Integer)CCubesSettings.dropHeight.get()) + 0.5;
        for (int yyy = (int)yy; yyy >= y + yOffVal; --yyy) {
            BlockPos offsetPos = new BlockPos(x + xOffVal, yyy, z + zOffVal);
            if (blockCache != null) {
                blockCache.cacheBlock(offsetPos, Blocks.f_50016_.m_49966_());
                continue;
            }
            RewardsUtil.placeBlock(Blocks.f_50016_.m_49966_(), level, offsetPos, this.removeUnbreakableBlocks.getBoolValue());
        }
        BlockFallingCustom entityfallingblock = new BlockFallingCustom(level, (double)(x + xOffVal) + 0.5, yy, (double)(z + zOffVal) + 0.5, this.state, y + yOffVal, this);
        level.m_7967_((Entity)entityfallingblock);
    }

    public OffsetBlock setBlockState(BlockState state) {
        this.state = state;
        return this;
    }

    public BlockState getBlockState() {
        return this.state;
    }

    public OffsetBlock setRelativeToPlayer(boolean relative) {
        return this.setRelativeToPlayer(new BoolVar(relative));
    }

    public OffsetBlock setRelativeToPlayer(BoolVar relative) {
        this.relativeToPlayer = relative;
        return this;
    }

    public boolean isRelativeToPlayer() {
        return this.relativeToPlayer.getBoolValue();
    }

    public IntVar getDelayVar() {
        return this.delay;
    }

    public OffsetBlock setCausesBlockUpdate(boolean flag) {
        return this.setCausesBlockUpdate(new BoolVar(flag));
    }

    public OffsetBlock setCausesBlockUpdate(BoolVar flag) {
        this.causeUpdate = flag;
        return this;
    }

    public boolean isFalling() {
        return this.falling.getBoolValue();
    }

    public BoolVar isFallingVar() {
        return this.falling;
    }

    public void setFalling(boolean falling) {
        this.setFalling(new BoolVar(falling));
    }

    public void setFalling(BoolVar falling) {
        this.falling = falling;
    }

    public void setRemoveUnbreakableBlocks(boolean remove) {
        this.setRemoveUnbreakableBlocks(new BoolVar(remove));
    }

    public void setRemoveUnbreakableBlocks(BoolVar remove) {
        this.removeUnbreakableBlocks = remove;
    }

    public boolean doesRemoveUnbreakableBlocks() {
        return this.removeUnbreakableBlocks.getBoolValue();
    }

    public void setPlaysSound(BoolVar playSound) {
        this.playSound = playSound;
    }

    public boolean doesPlaySound() {
        return this.playSound.getBoolValue();
    }

    public BlockPos placeInWorld(Level level, BlockPos position, boolean offset, RewardBlockCache blockCache) {
        BlockPos offsetPos = new BlockPos(0, 0, 0);
        if (offset) {
            offsetPos = offsetPos.m_142082_(this.xOff.getIntValue(), this.yOff.getIntValue(), this.zOff.getIntValue());
        }
        BlockPos placePos = position.m_141952_((Vec3i)offsetPos);
        if (blockCache != null) {
            blockCache.cacheBlock(offsetPos, this.state, this.causeUpdate.getBoolValue() != false ? 3 : 2);
        } else {
            RewardsUtil.placeBlock(this.state, level, placePos, this.causeUpdate.getBoolValue() != false ? 3 : 2, this.removeUnbreakableBlocks.getBoolValue());
        }
        if (this.playSound.getBoolValue().booleanValue()) {
            BlockPos surfacefPos = placePos.m_142082_(0, -1, 0);
            Block bSurface = level.m_8055_(surfacefPos).m_60734_();
            SoundType sound = bSurface.getSoundType(level.m_8055_(surfacefPos), (LevelReader)level, surfacefPos, null);
            level.m_6263_(null, (double)((float)placePos.m_123341_() + 0.5f), (double)((float)placePos.m_123342_() + 0.5f), (double)((float)placePos.m_123343_() + 0.5f), sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56773_() * 0.5f);
        }
        return placePos;
    }
}

