/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.holographic_rails;

import com.alc.moreminecarts.MMReferences;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HolographicRail
extends BaseRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final IntegerProperty LENGTH = BlockStateProperties.f_61422_;
    protected static final VoxelShape FULL_BLOCK_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public HolographicRail(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)LENGTH, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, LENGTH, f_152149_});
    }

    protected Block getProjectorRail() {
        return MMReferences.projector_rail;
    }

    public boolean canSurvive(BlockState state, Level world_reader, BlockPos pos) {
        BlockPos holograph_position;
        BlockState holograph_state;
        int length = (Integer)state.m_61143_((Property)LENGTH);
        if (length != 0 && ((holograph_state = world_reader.m_8055_(holograph_position = this.getSupportHolograph(state, pos))).m_60734_() != state.m_60734_() || holograph_state.m_61143_((Property)FACING) != state.m_61143_((Property)FACING))) {
            return false;
        }
        BlockPos projector_position = this.getSupportProjector(state, pos);
        BlockState projector_state = world_reader.m_8055_(projector_position);
        return projector_state.m_60734_() == this.getProjectorRail() && projector_state.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
    }

    public BlockPos getSupportHolograph(BlockState state, BlockPos pos) {
        RailShape shape = (RailShape)state.m_61143_(SHAPE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return pos.m_6625_(shape.m_61745_() ? 1 : 0).m_142300_(facing.m_122424_());
    }

    public BlockPos getSupportProjector(BlockState state, BlockPos pos) {
        RailShape shape = (RailShape)state.m_61143_(SHAPE);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int length = (Integer)state.m_61143_((Property)LENGTH);
        return pos.m_6625_(shape.m_61745_() ? length : 0).m_5484_(facing.m_122424_(), length + 1);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    public void m_6861_(BlockState p_220069_1_, Level p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.f_46443_ && p_220069_2_.m_8055_(p_220069_3_).m_60713_((Block)this) && !this.canSurvive(p_220069_1_, p_220069_2_, p_220069_3_)) {
            HolographicRail.m_49950_((BlockState)p_220069_1_, (Level)p_220069_2_, (BlockPos)p_220069_3_);
            p_220069_2_.m_7471_(p_220069_3_, p_220069_6_);
        }
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter block_reader, BlockPos pos, CollisionContext selection_context) {
        RailShape railshape = state.m_60713_((Block)this) ? (RailShape)state.m_61143_(this.m_7978_()) : null;
        return railshape != null && railshape.m_61745_() ? FULL_BLOCK_AABB : f_49355_;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.m_6360_(state, worldIn, pos, state.m_60734_());
        }
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    protected BlockState m_49389_(BlockState state, Level world, BlockPos pos, boolean isMoving) {
        return state;
    }

    protected BlockState m_49367_(Level worldIn, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
        return state;
    }
}

