/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.entities.IronPushcartEntity;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PistonPushcartEntity
extends IronPushcartEntity {
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
    public static final EntityDataAccessor<Float> HEIGHT_PARAMETER = SynchedEntityData.m_135353_(PistonPushcartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LAST_HEIGHT_PARAMETER = SynchedEntityData.m_135353_(PistonPushcartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final String HEIGHT_NAME = "height";
    public static final String LAST_HEIGHT_NAME = "last_height";
    public boolean going_up;
    public boolean going_down;

    public float getHeight() {
        return ((Float)this.f_19804_.m_135370_(HEIGHT_PARAMETER)).floatValue();
    }

    protected void setHeight(float height) {
        this.f_19804_.m_135381_(HEIGHT_PARAMETER, (Object)Float.valueOf(height));
    }

    public float getLastHeight() {
        return ((Float)this.f_19804_.m_135370_(LAST_HEIGHT_PARAMETER)).floatValue();
    }

    protected void setLastHeight(float height) {
        this.f_19804_.m_135381_(LAST_HEIGHT_PARAMETER, (Object)Float.valueOf(height));
    }

    public PistonPushcartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public PistonPushcartEntity(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions bounding_box = super.m_6972_(pose);
        return new EntityDimensions(bounding_box.f_20377_, bounding_box.f_20378_ + 0.2f + this.getHeight(), bounding_box.f_20379_);
    }

    public void onHeightChanged() {
        this.m_20011_(this.m_142242_());
    }

    protected AABB m_142242_() {
        return this.m_6972_(Pose.STANDING).m_20393_(this.m_20182_());
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_(HEIGHT_NAME, this.getHeight());
        compound.m_128350_(LAST_HEIGHT_NAME, this.getLastHeight());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHeight(compound.m_128457_(HEIGHT_NAME));
        this.setLastHeight(compound.m_128457_(LAST_HEIGHT_NAME));
        this.onHeightChanged();
    }

    public double m_6048_() {
        return 0.65 + (double)this.getHeight();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        float height = this.getHeight();
        float last_height = this.getLastHeight();
        if (height != last_height) {
            this.setLastHeight(height);
        }
        if (this.ContainsPlayerPassenger()) {
            if (this.going_up) {
                this.attemptMove(true, false);
            }
            if (this.going_down) {
                this.attemptMove(false, false);
            }
        }
    }

    public void attemptMove(boolean going_up, boolean is_reduced) {
        float height = this.getHeight();
        if (going_up) {
            BlockPos test_pos = this.m_142538_().m_6630_((int)Math.ceil((double)height + 1.5));
            BlockState test_state = this.f_19853_.m_8055_(test_pos);
            if (!test_state.m_60838_((BlockGetter)this.f_19853_, test_pos)) {
                this.setHeight(height + this.getVerticalSpeed() * (is_reduced ? 0.2f : 1.0f));
            }
            if (this.getHeight() > 5.0f) {
                this.setHeight(5.0f);
            }
        } else {
            this.setHeight(height - this.getVerticalSpeed() * (is_reduced ? 0.2f : 1.0f));
            if (this.getHeight() < 0.0f) {
                this.setHeight(0.0f);
            }
        }
        this.onHeightChanged();
    }

    public float getVerticalSpeed() {
        return 0.2f;
    }

    public boolean ContainsPlayerPassenger() {
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof Player)) continue;
            return true;
        }
        return false;
    }

    protected void m_20351_(Entity p_184225_1_) {
        this.going_up = false;
        this.going_down = false;
        super.m_20351_(p_184225_1_);
    }

    protected void m_20348_(Entity p_184200_1_) {
        this.going_up = false;
        this.going_down = false;
        super.m_20348_(p_184200_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HEIGHT_PARAMETER, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(LAST_HEIGHT_PARAMETER, (Object)Float.valueOf(0.0f));
    }

    public void setElevating(boolean is_upwards, boolean is_down) {
        if (is_upwards) {
            this.going_up = is_down;
        } else {
            this.going_down = is_down;
        }
    }

    public BlockState m_38178_() {
        return MMReferences.piston_display_block.m_49966_();
    }

    public BlockState m_6390_() {
        return MMReferences.piston_display_block.m_49966_();
    }

    public AABB m_6921_() {
        AABB axisalignedbb = this.m_142469_();
        return this.m_38184_() ? axisalignedbb.m_82400_((double)Math.abs(this.m_38183_()) / 16.0) : axisalignedbb;
    }

    @Override
    public void m_7617_(DamageSource source) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack stack = new ItemStack((ItemLike)MMItemReferences.iron_pushcart);
            if (this.m_8077_()) {
                stack.m_41714_(this.m_7770_());
            }
            this.m_19983_(stack);
            this.m_19983_(new ItemStack((ItemLike)Items.f_41869_));
        }
    }

    public Vec3 m_7688_(LivingEntity p_230268_1_) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(p_230268_1_);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_142538_();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        ImmutableList immutablelist = p_230268_1_.m_7431_();
        for (Pose pose : immutablelist) {
            EntityDimensions entitysize = p_230268_1_.m_6972_(pose);
            float f = Math.min(entitysize.f_20377_, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int i = (Integer)unmodifiableIterator.next();
                for (int[] aint1 : aint) {
                    Vec3 vector3d;
                    AABB axisalignedbb;
                    blockpos$mutable.m_122169_((double)(blockpos.m_123341_() + aint1[0]), (double)((float)blockpos.m_123342_() + this.getHeight() + (float)i), (double)(blockpos.m_123343_() + aint1[1]));
                    double d0 = this.f_19853_.m_45564_(DismountHelper.m_38446_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable), () -> DismountHelper.m_38446_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable.m_7495_()));
                    if (!DismountHelper.m_38439_((double)d0) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)p_230268_1_, (AABB)(axisalignedbb = new AABB((double)(-f), 0.0, (double)(-f), (double)f, (double)entitysize.f_20378_, (double)f)).m_82383_(vector3d = Vec3.m_82514_((Vec3i)blockpos$mutable, (double)d0)))) continue;
                    p_230268_1_.m_20124_(pose);
                    return vector3d;
                }
            }
        }
        double d1 = this.m_142469_().f_82292_;
        blockpos$mutable.m_122169_((double)blockpos.m_123341_(), d1, (double)blockpos.m_123343_());
        for (Pose pose1 : immutablelist) {
            double d2 = p_230268_1_.m_6972_((Pose)pose1).f_20378_;
            int j = Mth.m_14165_((double)(d1 - (double)blockpos$mutable.m_123342_() + d2));
            double d3 = DismountHelper.m_38463_((BlockPos)blockpos$mutable, (int)j, p_242377_1_ -> this.f_19853_.m_8055_(p_242377_1_).m_60812_((BlockGetter)this.f_19853_, p_242377_1_));
            if (!(d1 + d2 <= d3)) continue;
            p_230268_1_.m_20124_(pose1);
            break;
        }
        return super.m_7688_(p_230268_1_);
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult result = super.m_6096_(player, hand);
        double distance = this.m_20280_((Entity)player);
        if (result == InteractionResult.SUCCESS && this.f_19853_.f_46443_ && distance >= 36.0 && distance < 175.0) {
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)MoreMinecartsPacketHandler.ExtendedInteractPacket.createExtendedInteractPacket((Entity)this, player.m_6144_(), hand));
        }
        return result;
    }
}

