/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.MMConstants;
import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.containers.ChunkLoaderBlock;
import com.alc.moreminecarts.containers.ChunkLoaderContainer;
import com.alc.moreminecarts.tile_entities.ContainerBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkLoaderTile
extends ContainerBlockEntity
implements WorldlyContainer,
Container {
    public static String LAST_CHUNK_X_PROPERTY = "last_block_pos_x";
    public static String LAST_CHUNK_Z_PROPERTY = "last_block_pos_z";
    public static String TIME_LEFT_PROPERTY = "time_left";
    public static int MAX_TIME = 10368000;
    public static int MAX_MINUTES = 8640;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return (int)Math.ceil((double)(Math.abs(ChunkLoaderTile.this.time_left) - 1) / 1200.0) * this.m_6413_(1);
                }
                case 1: {
                    return ChunkLoaderTile.this.time_left > 0 ? 1 : -1;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int set_to) {
            switch (index) {
                case 0: {
                    ChunkLoaderTile.this.time_left = set_to * 1200;
                    break;
                }
                case 1: {
                    ChunkLoaderTile.this.time_left = Math.abs(ChunkLoaderTile.this.time_left) * (set_to > 0 ? 1 : -1);
                    break;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public boolean lit_last_tick;
    public int time_left;
    public int last_chunk_x;
    public int last_chunk_z;

    public ChunkLoaderTile(BlockPos pos, BlockState state) {
        super(MMReferences.chunk_loader_te, pos, state);
        this.items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        this.lit_last_tick = false;
        this.time_left = -1;
        this.last_chunk_x = this.m_58899_().m_123341_() >> 4;
        this.last_chunk_z = this.m_58899_().m_123343_() >> 4;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_(LAST_CHUNK_X_PROPERTY, this.last_chunk_x);
        compound.m_128405_(LAST_CHUNK_Z_PROPERTY, this.last_chunk_z);
        compound.m_128405_(TIME_LEFT_PROPERTY, this.time_left);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.last_chunk_x = compound.m_128451_(LAST_CHUNK_X_PROPERTY);
        this.last_chunk_z = compound.m_128451_(LAST_CHUNK_Z_PROPERTY);
        this.time_left = compound.m_128451_(TIME_LEFT_PROPERTY);
        this.lit_last_tick = this.isLit();
        super.m_142466_(compound);
    }

    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ChunkLoaderContainer(i, inventory, this, this.dataAccess);
    }

    protected AbstractContainerMenu m_6555_(int p_213906_1_, Inventory p_213906_2_) {
        return null;
    }

    public static int getBurnDuration(Item item) {
        double multiplier = (Double)MMConstants.CONFIG_CHUNK_LOADER_MULTIPLIER.get();
        double fuel = -1.0;
        if (item == Items.f_42692_) {
            fuel = 200.0;
        } else if (item == Items.f_151049_) {
            fuel = 600.0;
        } else if (item == Items.f_150998_) {
            fuel = 600.0;
        } else if (item == Items.f_42616_) {
            fuel = 6000.0;
        } else if (item == Items.f_42110_) {
            fuel = 54000.0;
        } else if (item == Items.f_42415_) {
            fuel = 72000.0;
        } else if (item == Items.f_41959_) {
            fuel = 648000.0;
        } else if (item == Items.f_42686_) {
            fuel = 3456000.0;
        } else if (item == MMItemReferences.chunkrodite) {
            fuel = 18000.0;
        } else if (item == MMItemReferences.chunkrodite_block) {
            fuel = 162000.0;
        }
        fuel *= multiplier;
        if (fuel <= 0.0) {
            return -1;
        }
        return (int)Math.ceil(fuel);
    }

    public static void doTick(Level level, BlockPos pos, BlockState state, ChunkLoaderTile ent) {
        ent.tick();
    }

    public void tick() {
        boolean changed_flag = false;
        if (this.isLit()) {
            --this.time_left;
        }
        if (!this.f_58857_.m_5776_()) {
            int burn_duration = ChunkLoaderTile.getBurnDuration(((ItemStack)this.items.get(0)).m_41720_());
            if (burn_duration >= 0 && Math.abs(this.time_left) + burn_duration <= MAX_TIME) {
                changed_flag = true;
                this.time_left = this.time_left > 0 ? (this.time_left += burn_duration) : (this.time_left -= burn_duration);
                ((ItemStack)this.items.get(0)).m_41774_(1);
            }
            int chunk_x = this.m_58899_().m_123341_() >> 4;
            int chunk_z = this.m_58899_().m_123343_() >> 4;
            if (chunk_x != this.last_chunk_x || chunk_z != this.last_chunk_z) {
                changed_flag = true;
                this.forceChucksAt(this.last_chunk_x, this.last_chunk_z, false);
                this.last_chunk_x = chunk_x;
                this.last_chunk_z = chunk_z;
                boolean bl = this.lit_last_tick = !this.isLit();
            }
            if (this.lit_last_tick != this.isLit()) {
                changed_flag = true;
                if (this.isLit()) {
                    this.forceChucksAt(chunk_x, chunk_z, true);
                } else {
                    this.forceChucksAt(chunk_x, chunk_z, false);
                }
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)ChunkLoaderBlock.POWERED, (Comparable)Boolean.valueOf(this.isLit())), 3);
            }
            if (changed_flag) {
                this.m_6596_();
            }
        }
        this.lit_last_tick = this.isLit();
    }

    private void forceChucksAt(int chunk_x, int chunk_z, boolean add) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                boolean bl = ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"moreminecarts", (BlockPos)this.m_58899_(), (int)(chunk_x + i), (int)(chunk_z + j), (boolean)add, (boolean)false);
            }
        }
    }

    public void m_7651_() {
        if (!this.f_58857_.f_46443_) {
            int chunk_x = this.m_58899_().m_123341_() >> 4;
            int chunk_z = this.m_58899_().m_123343_() >> 4;
            this.forceChucksAt(chunk_x, chunk_z, false);
        }
        super.m_7651_();
    }

    public boolean isLit() {
        return this.time_left > 1 && this.isEnabled();
    }

    public boolean isEnabled() {
        return this.time_left > 0;
    }

    public int[] m_7071_(Direction p_180463_1_) {
        return new int[0];
    }

    public boolean m_7155_(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return true;
    }

    public boolean m_7157_(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public int getSlotCount() {
        return 1;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("Chunk Loader");
    }

    public static void dropExtras(Level world, int time_left, BlockPos pos) {
        double multiplier = (Double)MMConstants.CONFIG_CHUNK_LOADER_MULTIPLIER.get();
        if (multiplier == 0.0) {
            return;
        }
        int count = (int)Math.floor(Math.abs((double)time_left / multiplier) / 24000.0);
        Item to_drop = MMItemReferences.chunkrodite;
        if (count > 64) {
            count = (int)Math.floor((float)count / 9.0f);
            to_drop = MMItemReferences.chunkrodite_block;
            if (count > 64) {
                count = 64;
            }
        }
        if (count != 0) {
            ItemStack drop_stack = new ItemStack((ItemLike)to_drop, count);
            NonNullList drops = NonNullList.m_122780_((int)1, (Object)drop_stack);
            Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)drops);
        }
    }

    public int getComparatorSignal() {
        float true_time_left = Math.abs(this.time_left) - 1;
        double log_proportion = Math.log10(true_time_left / (float)MAX_TIME * 9.0f + 1.0f);
        return (int)Math.ceil(log_proportion * 15.0);
    }
}

