/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.data;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;
import samebutdifferent.ecologics.registry.ModItems;

public class LangGenerator
extends LanguageProvider {
    public LangGenerator(DataGenerator gen, String locale) {
        super(gen, "ecologics", locale);
    }

    protected void addTranslations() {
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            if (!item.getId().m_135815_().contains("pot")) continue;
            this.addItem((Supplier)item, this.formatId(item));
        }
    }

    private String formatId(RegistryObject object) {
        return WordUtils.capitalize((String)object.getId().m_135815_().replace("_", " "));
    }

    public void addEntitySoundEvents(String key, String name, String ambientSoundWord) {
        this.add("ecologics.subtitles." + key + ".ambient", name + " " + ambientSoundWord);
        this.add("ecologics.subtitles." + key + ".death", name + " dies");
        this.add("ecologics.subtitles." + key + ".hurt", name + " hurts");
    }

    public void addSoundEvent(Supplier<? extends SoundEvent> key, String subtitle) {
        this.add("ecologics.subtitles." + key.get().m_11660_().m_135815_(), subtitle);
    }
}

