/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set.wood;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WoodType
implements IBlockType {
    public static WoodType OAK_WOOD_TYPE = new WoodType(new ResourceLocation("oak"), Blocks.f_50705_, Blocks.f_49999_);
    public final ResourceLocation id;
    public final Material material;
    public final Block plankBlock;
    public final Block logBlock;
    @Nullable
    public final Block leaves;
    @Nullable
    public final Lazy<Item> signItem;
    @Nullable
    public final Lazy<Item> boatItem;
    public final String shortenedNamespace;

    protected WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        this.id = id;
        this.plankBlock = baseBlock;
        this.logBlock = logBlock;
        this.material = baseBlock.m_49966_().m_60767_();
        this.shortenedNamespace = id.m_135827_().equals("minecraft") ? "" : "_" + WoodType.abbreviateString(id.m_135827_());
        this.leaves = this.findLeaves();
        this.signItem = Lazy.of(() -> this.findRelatedItem("sign"));
        this.boatItem = Lazy.of(() -> this.findRelatedItem("boat"));
    }

    @Nullable
    private Block findLeaves() {
        ResourceLocation[] targets;
        for (ResourceLocation r : targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_leaves"), new ResourceLocation(this.id.m_135827_(), "leaves_" + this.id.m_135815_())}) {
            Block found;
            if (!ForgeRegistries.BLOCKS.containsKey(r) || (found = (Block)ForgeRegistries.BLOCKS.getValue(r)).m_49966_().m_60767_() != Material.f_76274_) continue;
            return found;
        }
        return null;
    }

    @Nullable
    private Item findRelatedItem(String appendedName) {
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_" + appendedName), new ResourceLocation(this.id.m_135827_(), appendedName + "_" + this.id.m_135815_())};
        Item found = null;
        for (ResourceLocation r : targets) {
            if (!ForgeRegistries.ITEMS.containsKey(r)) continue;
            found = (Item)ForgeRegistries.ITEMS.getValue(r);
            break;
        }
        return found;
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    @Deprecated
    public String getWoodName() {
        return this.getTypeName();
    }

    @Override
    public String getTypeName() {
        return this.id.m_135815_();
    }

    @Override
    public String getNamespace() {
        return this.id.m_135827_();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Deprecated
    public String getAppendableId() {
        return this.getTypeName() + this.shortenedNamespace;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    private static String abbreviateString(String string) {
        if (string.length() <= 5) {
            return string;
        }
        String[] a = string.split("_");
        if (a.length > 2) {
            return "" + a[0].charAt(0) + a[1].charAt(0) + a[2].charAt(0) + (Serializable)(a.length > 3 ? Character.valueOf(a[3].charAt(0)) : "");
        }
        if (a.length > 1) {
            return a[0].substring(0, Math.min(2, a[0].length())) + a[1].substring(0, Math.min(2, a[0].length()));
        }
        return string.substring(0, 4);
    }

    public static class Finder
    extends IBlockType.SetFinder<WoodType> {
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return new Finder(new ResourceLocation(modId, woodTypeName), () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modId, planksName)), () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modId, logName)));
        }

        @Override
        public Optional<WoodType> get() {
            if (ModList.get().isLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)ForgeRegistries.BLOCKS.getValue(ForgeRegistries.BLOCKS.getDefaultKey());
                    if (plank != d && log != d && plank != null && log != null) {
                        return Optional.of(new WoodType(this.id, plank, log));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Selene.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

