/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.mehvahdjukaar.selene.map.client.DecorationRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapDecorationRenderHandler {
    private static final Map<CustomDecorationType<?, ?>, DecorationRenderer<?>> RENDERERS = Maps.newHashMap();

    public static <T extends CustomDecoration> void bindDecorationRenderer(CustomDecorationType<T, ?> type, DecorationRenderer<T> renderer) {
        if (RENDERERS.containsKey(type)) {
            throw new IllegalArgumentException("Duplicate map decoration renderer registration " + type.getRegistryId());
        }
        RENDERERS.put(type, renderer);
    }

    public static void bindSimpleRenderer(CustomDecorationType<?, ?> type) {
        ResourceLocation texture = new ResourceLocation(type.getId().m_135827_(), "textures/map/" + type.getId().m_135815_() + ".png");
        MapDecorationRenderHandler.bindDecorationRenderer(type, new DecorationRenderer(texture));
    }

    public static <E extends CustomDecoration> DecorationRenderer<E> getRenderer(E decoration) {
        return RENDERERS.get(decoration.getType());
    }

    public static <T extends CustomDecoration> boolean render(T decoration, PoseStack matrixStack, MultiBufferSource buffer, MapItemSavedData mapData, boolean isOnFrame, int light, int index) {
        DecorationRenderer<T> renderer = MapDecorationRenderHandler.getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }

    static {
        MapDecorationRenderHandler.bindSimpleRenderer(MapDecorationHandler.GENERIC_STRUCTURE_TYPE);
    }
}

