/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.network;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSyncFluidsPacket {
    private final Collection<SoftFluid> fluids;

    public ClientBoundSyncFluidsPacket(Collection<SoftFluid> fluids) {
        this.fluids = fluids;
    }

    public ClientBoundSyncFluidsPacket(FriendlyByteBuf pBuffer) {
        int size = pBuffer.m_130242_();
        this.fluids = new ArrayList<SoftFluid>();
        for (int i = 0; i < size; ++i) {
            DataResult r = SoftFluid.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pBuffer.m_130261_());
            r.result().ifPresent(this.fluids::add);
        }
    }

    public static void buffer(ClientBoundSyncFluidsPacket message, FriendlyByteBuf buffer) {
        ArrayList<CompoundTag> encoded = new ArrayList<CompoundTag>();
        for (SoftFluid f : message.fluids) {
            try {
                Optional r = SoftFluid.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)f).resultOrPartial(e -> Selene.LOGGER.error("Failed encoding Soft Fluid {} : {}", (Object)f, e));
                encoded.add((CompoundTag)r.get());
            }
            catch (Exception e2) {
                Selene.LOGGER.error("Failed encoding Soft Fluid {} : {}", (Object)f, (Object)e2);
            }
        }
        buffer.m_130130_(encoded.size());
        encoded.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130079_(arg_0));
    }

    public static void handler(ClientBoundSyncFluidsPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                SoftFluidRegistry.acceptClientFluids(message);
            }
        });
        context.setPacketHandled(true);
    }

    public Collection<SoftFluid> getFluids() {
        return this.fluids;
    }
}

