/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.MobContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;

public class JarBlockTileRenderer
extends CageBlockTileRenderer<JarBlockTile> {
    private final ItemRenderer itemRenderer;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public JarBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = this.minecraft.m_91291_();
    }

    public static void renderFluid(float height, int color, int luminosity, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int light, int combinedOverlayIn, boolean shading) {
        matrixStackIn.m_85836_();
        float opacity = 1.0f;
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110469_());
        matrixStackIn.m_85837_(0.5, 0.0625, 0.5);
        RendererUtil.addCube(builder, matrixStackIn, 0.5f, height, sprite, light, color, opacity, combinedOverlayIn, true, true, shading, true);
        matrixStackIn.m_85849_();
    }

    public void render(JarBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        long r = tile.m_58899_().m_121878_();
        Random rand = new Random(r);
        if (!tile.m_7983_()) {
            ItemStack stack = tile.getDisplayedItem();
            int height = tile.getDisplayedItem().m_41613_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_85845_(RotHlpr.XN90);
            matrixStackIn.m_85837_(0.0, 0.0, -0.5);
            float scale = 0.5714286f;
            matrixStackIn.m_85841_(scale, scale, scale);
            for (float i = 0.0f; i < (float)height; i += 1.0f) {
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)rand.nextInt(16) * 22.5f));
                matrixStackIn.m_85837_(0.0, 0.0, (double)(1.0f / (16.0f * scale)));
                BakedModel model = this.itemRenderer.m_174264_(stack, tile.m_58904_(), null, 0);
                this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, model);
            }
            matrixStackIn.m_85849_();
        }
        if (!tile.mobContainer.isEmpty()) {
            MobContainer.MobData data = tile.mobContainer.getData();
            if (data.isAquarium) {
                matrixStackIn.m_85836_();
                long time = System.currentTimeMillis() + r;
                float angle = (float)(time % 28800L) / 80.0f;
                float angle2 = (float)(time % 1080L) / 3.0f;
                float angle3 = (float)(time % 126000L) / 350.0f;
                float wo = 0.015f * Mth.m_14031_((float)((float)(Math.PI * 2 * (double)angle2 / 360.0)));
                float ho = 0.1f * Mth.m_14031_((float)((float)(Math.PI * 2 * (double)angle3 / 360.0)));
                VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110463_());
                matrixStackIn.m_85837_(0.5, 0.5, 0.5);
                Quaternion rotation = Vector3f.f_122225_.m_122240_(-angle);
                matrixStackIn.m_85845_(rotation);
                matrixStackIn.m_85841_(0.625f, 0.625f, 0.625f);
                matrixStackIn.m_85837_(0.0, -0.2, -0.335);
                int fishType = data.getFishIndex();
                RendererUtil.renderFish(builder, matrixStackIn, wo, ho, fishType, combinedLightIn);
                matrixStackIn.m_85849_();
            } else {
                super.m_6922_(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            if (tile.mobContainer.shouldHaveWater()) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.5, 0.0635, 0.5);
                VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110463_());
                TextureAtlasSprite sprite_s = (TextureAtlasSprite)this.minecraft.m_91258_(TextureAtlas.f_118259_).apply(Textures.SAND_TEXTURE);
                RendererUtil.addCube(builder, matrixStackIn, 0.499f, 0.0625f, sprite_s, combinedLightIn, 0xFFFFFF, 1.0f, combinedOverlayIn, true, true, true, true);
                matrixStackIn.m_85849_();
                matrixStackIn.m_85836_();
                SoftFluid s = SoftFluidRegistry.WATER.get();
                JarBlockTileRenderer.renderFluid(0.5625f, s.getTintColor(), 0, s.getStillTexture(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true);
                matrixStackIn.m_85849_();
            }
        }
        if (!tile.fluidHolder.isEmpty()) {
            JarBlockTileRenderer.renderFluid(tile.fluidHolder.getHeight(0.75f), tile.fluidHolder.getTintColor((LevelReader)tile.m_58904_(), tile.m_58899_()), tile.fluidHolder.getFluid().getLuminosity(), tile.fluidHolder.getFluid().getStillTexture(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true);
        }
    }
}

