/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.client.TextUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.LOD;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class SignPostBlockTileRenderer
implements BlockEntityRenderer<SignPostBlockTile> {
    private static final int LINE_MAX_WIDTH = 90;
    private final Camera camera;
    private final Font font;
    public final ModelPart signModel;

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-12.0f, -5.0f, -3.0f, 2.0f, 1.0f, 1.0f).m_171514_(0, 0).m_171481_(-8.0f, -7.0f, -3.0f, 16.0f, 5.0f, 1.0f).m_171514_(0, 6).m_171481_(-10.0f, -6.0f, -3.0f, 2.0f, 3.0f, 1.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)16);
    }

    public SignPostBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.m_173582_(ClientRegistry.SIGN_POST_MODEL);
        this.signModel = model.m_171324_("sign");
        this.camera = Minecraft.m_91087_().f_91063_.m_109153_();
        this.font = context.m_173586_();
    }

    public int m_142163_() {
        return 96;
    }

    public void render(SignPostBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockPos pos = tile.m_58899_();
        Vec3 cameraPos = this.camera.m_90583_();
        LOD lod = new LOD(cameraPos, pos);
        boolean up = tile.up;
        boolean down = tile.down;
        if (up || down) {
            VertexConsumer builder;
            Material material;
            int o;
            boolean left;
            float relAngle = LOD.getRelativeAngle(cameraPos, pos);
            TextUtil.RenderTextProperties textProperties = new TextUtil.RenderTextProperties(tile.textHolder, combinedLightIn, lod::isVeryNear);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            if (up) {
                matrixStackIn.m_85836_();
                left = tile.leftUp;
                o = left ? 1 : -1;
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(tile.yawUp - 90.0f));
                matrixStackIn.m_85836_();
                if (!left) {
                    matrixStackIn.m_85845_(RotHlpr.YN180);
                    matrixStackIn.m_85837_(0.0, 0.0, -0.3125);
                }
                matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
                material = Materials.SIGN_POSTS_MATERIALS.get(tile.woodTypeUp);
                if (material != null) {
                    builder = material.m_119194_(bufferIn, RenderType::m_110446_);
                    this.signModel.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
                }
                matrixStackIn.m_85849_();
                if (lod.isNear() && LOD.isOutOfFocus(relAngle, tile.yawUp + 90.0f, 2.0f)) {
                    matrixStackIn.m_85837_(-0.03125 * (double)o, 0.28125, 0.1925);
                    matrixStackIn.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
                    TextUtil.renderLine(tile.textHolder, 0, this.font, 90, -4.0f, matrixStackIn, bufferIn, textProperties);
                }
                matrixStackIn.m_85849_();
            }
            if (down) {
                matrixStackIn.m_85836_();
                left = tile.leftDown;
                o = left ? 1 : -1;
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(tile.yawDown - 90.0f));
                matrixStackIn.m_85837_(0.0, -0.5, 0.0);
                matrixStackIn.m_85836_();
                if (!left) {
                    matrixStackIn.m_85845_(RotHlpr.YN180);
                    matrixStackIn.m_85837_(0.0, 0.0, -0.3125);
                }
                matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
                material = Materials.SIGN_POSTS_MATERIALS.get(tile.woodTypeDown);
                builder = material.m_119194_(bufferIn, RenderType::m_110446_);
                this.signModel.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
                matrixStackIn.m_85849_();
                if (lod.isNear() && LOD.isOutOfFocus(relAngle, tile.yawDown + 90.0f, 2.0f)) {
                    matrixStackIn.m_85837_(-0.03125 * (double)o, 0.28125, 0.1925);
                    matrixStackIn.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
                    TextUtil.renderLine(tile.textHolder, 1, this.font, 90, -4.0f, matrixStackIn, bufferIn, textProperties);
                }
                matrixStackIn.m_85849_();
            }
            matrixStackIn.m_85849_();
        }
    }
}

