/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetTrappedPresentPacket {
    private final BlockPos pos;
    private final boolean packed;

    public ServerBoundSetTrappedPresentPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.packed = buf.readBoolean();
    }

    public ServerBoundSetTrappedPresentPacket(BlockPos pos, boolean packed) {
        this.pos = pos;
        this.packed = packed;
    }

    public static void buffer(ServerBoundSetTrappedPresentPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeBoolean(message.packed);
    }

    public static void handler(ServerBoundSetTrappedPresentPacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = Objects.requireNonNull(ctx.get().getSender());
        Level world = player.f_19853_;
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            BlockEntity patt1497$temp = world.m_7702_(message.pos);
            if (patt1497$temp instanceof TrappedPresentBlockTile) {
                TrappedPresentBlockTile present = (TrappedPresentBlockTile)patt1497$temp;
                present.updateState(message.packed);
                BlockState state = world.m_8055_(pos);
                present.m_6596_();
                world.m_7260_(pos, state, state, 3);
                if (message.packed) {
                    player.m_9230_();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

