/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import java.util.Calendar;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightableLanternBlock;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class CommonUtil {
    public static DamageSource SPIKE_DAMAGE = new DamageSource("supplementaries.bamboo_spikes");
    public static DamageSource BOTTLING_DAMAGE = new DamageSource("supplementaries.xp_extracting");
    public static Festivity FESTIVITY = Festivity.get();
    private static final ShulkerBoxBlockEntity SHULKER_TILE = new ShulkerBoxBlockEntity(BlockPos.f_121853_, Blocks.f_50456_.m_49966_());

    public static boolean isSword(Item i) {
        if (i.m_204114_().m_203656_(ModTags.STATUE_SWORDS)) {
            return true;
        }
        return i instanceof SwordItem;
    }

    public static boolean isTool(Item i) {
        if (i.m_204114_().m_203656_(ModTags.STATUE_TOOLS)) {
            return true;
        }
        return i instanceof DiggerItem || i instanceof TridentItem;
    }

    public static boolean isLantern(Item i) {
        if (i instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)i;
            Block b = blockItem.m_40614_();
            String namespace = b.getRegistryName().m_135827_();
            if (namespace.equals("skinnedlanterns")) {
                return true;
            }
            if (b instanceof LanternBlock && !ServerConfigs.cached.WALL_LANTERN_BLACKLIST.contains(namespace)) {
                return !b.m_49966_().m_155947_() || b instanceof LightableLanternBlock;
            }
        }
        return false;
    }

    public static boolean isCookie(Item i) {
        return i.m_204114_().m_203656_(ModTags.COOKIES);
    }

    public static boolean isBrick(Item i) {
        return i.m_204114_().m_203656_(ModTags.BRICKS);
    }

    public static boolean isCake(Item i) {
        return i == Items.f_42502_;
    }

    public static boolean isPot(Item i) {
        if (i instanceof BlockItem) {
            Block b = ((BlockItem)i).m_40614_();
            return b instanceof FlowerPotBlock;
        }
        return false;
    }

    public static AABB getDirectionBB(BlockPos pos, Direction facing, int offset) {
        BlockPos endPos = pos.m_5484_(facing, offset);
        switch (facing) {
            case NORTH: {
                endPos = endPos.m_142082_(1, 1, 0);
                break;
            }
            case SOUTH: {
                endPos = endPos.m_142082_(1, 1, 1);
                pos = pos.m_142082_(0, 0, 1);
                break;
            }
            case UP: {
                endPos = endPos.m_142082_(1, 1, 1);
                pos = pos.m_142082_(0, 1, 0);
                break;
            }
            case EAST: {
                endPos = endPos.m_142082_(1, 1, 1);
                pos = pos.m_142082_(1, 0, 0);
                break;
            }
            case WEST: {
                endPos = endPos.m_142082_(0, 1, 1);
                break;
            }
            case DOWN: {
                endPos = endPos.m_142082_(1, 0, 1);
            }
        }
        return new AABB(pos, endPos);
    }

    public static boolean isAllowedInShulker(ItemStack stack) {
        return SHULKER_TILE.m_7155_(0, stack, null);
    }

    public static boolean withinDistanceDown(BlockPos pos, Vec3 vector, double distW, double distDown) {
        double dx = vector.m_7096_() - ((double)pos.m_123341_() + 0.5);
        double dy = vector.m_7098_() - ((double)pos.m_123342_() + 0.5);
        double dz = vector.m_7094_() - ((double)pos.m_123343_() + 0.5);
        double mydistW = dx * dx + dz * dz;
        return mydistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static HitResult rayTrace(LivingEntity entity2, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return CommonUtil.rayTrace((Entity)entity2, world, blockMode, fluidMode, entity2.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_());
    }

    public static HitResult rayTrace(Entity entity2, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Vec3 startPos = entity2.m_146892_();
        Vec3 ray = entity2.m_20252_(1.0f).m_82490_(range);
        Vec3 endPos = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, endPos, blockMode, fluidMode, entity2);
        return world.m_45547_(context);
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE,
        MY_BIRTHDAY,
        MOD_BIRTHDAY;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        public boolean isBirthday() {
            return this == MOD_BIRTHDAY || this == MY_BIRTHDAY;
        }

        public int getCandyWrappingIndex() {
            return switch (this) {
                default -> 0;
                case HALLOWEEN -> 1;
                case CHRISTMAS -> 2;
            };
        }

        private static Festivity get() {
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            int date = calendar.get(5);
            if (month == 9 && date >= 29 || month == 10 && date <= 1) {
                return HALLOWEEN;
            }
            if (month == 3 && date == 1) {
                return APRILS_FOOL;
            }
            if (month == 1 && date == 14) {
                return ST_VALENTINE;
            }
            if (month == 3 && date == 22) {
                return EARTH_DAY;
            }
            if (month == 11 && date >= 23 && date <= 27) {
                return CHRISTMAS;
            }
            if (month == 1 && date == 7) {
                return MY_BIRTHDAY;
            }
            if (month == 9 && date == 9) {
                return MOD_BIRTHDAY;
            }
            return NONE;
        }
    }
}

