/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.generation.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.utils.VectorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureLocator {
    private static int dist(BlockPos pos1, BlockPos pos2) {
        int i = pos2.m_123341_() - pos1.m_123341_();
        int j = pos2.m_123343_() - pos1.m_123343_();
        return (int)Mth.m_14116_((float)(i * i + j * j));
    }

    @Nullable
    public static Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> findNearestRandomMapFeature(ServerLevel level, TagKey<ConfiguredStructureFeature<?, ?>> tagKey, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated) {
        List<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> found = StructureLocator.findNearestMapFeatures(level, tagKey, pos, maximumChunkDistance, newlyGenerated, 1, false);
        if (found.size() > 0) {
            return found.get(0);
        }
        return null;
    }

    public static List<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> findNearestMapFeatures(ServerLevel level, TagKey<ConfiguredStructureFeature<?, ?>> tagKey, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount) {
        return StructureLocator.findNearestMapFeatures(level, tagKey, pos, maximumChunkDistance, newlyGenerated, requiredCount, false);
    }

    public static List<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> findNearestMapFeatures(ServerLevel level, TagKey<ConfiguredStructureFeature<?, ?>> tagKey, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, boolean selectRandom) {
        int n;
        ArrayList foundStructures = new ArrayList();
        if (!level.m_142572_().m_129910_().m_5961_().m_64657_()) {
            return foundStructures;
        }
        Optional optional = level.m_5962_().m_175515_(Registry.f_122882_).m_203431_(tagKey);
        if (optional.isEmpty()) {
            return foundStructures;
        }
        HolderSet.Named targets = (HolderSet.Named)optional.get();
        Set targetBiomes = targets.m_203614_().flatMap(holder -> ((ConfiguredStructureFeature)holder.m_203334_()).m_209752_().m_203614_()).collect(Collectors.toSet());
        if (targetBiomes.isEmpty()) {
            return foundStructures;
        }
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        Set possibleBiomes = chunkGenerator.m_62218_().m_207840_();
        if (Collections.disjoint(possibleBiomes, targetBiomes)) {
            return foundStructures;
        }
        double maxDist = Double.MAX_VALUE;
        List<Object> selectedTargets = new ArrayList();
        for (Object holder2 : targets) {
            if (!possibleBiomes.stream().anyMatch(arg_0 -> ((HolderSet)((ConfiguredStructureFeature)holder2.m_203334_()).m_209752_()).m_203333_(arg_0))) continue;
            selectedTargets.add(holder2);
        }
        if (selectRandom) {
            Holder selected = (Holder)selectedTargets.get(level.f_46441_.nextInt(selectedTargets.size()));
            selectedTargets = List.of(selected);
        }
        Object2ObjectArrayMap reachableTargetsMap = new Object2ObjectArrayMap();
        for (Holder holder2 : selectedTargets) {
            for (StructurePlacement structurePlacement : chunkGenerator.m_208090_(holder2)) {
                reachableTargetsMap.computeIfAbsent(structurePlacement, placement -> new ObjectArraySet()).add(holder2);
            }
        }
        ArrayList<Pair> list = new ArrayList<Pair>(reachableTargetsMap.size());
        boolean bl = false;
        for (Map.Entry entry : reachableTargetsMap.entrySet()) {
            StructurePlacement placement2 = (StructurePlacement)entry.getKey();
            if (placement2 instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)placement2;
                BlockPos blockpos = chunkGenerator.m_204382_(pos, concentricringsstructureplacement);
                double d1 = pos.m_123331_((Vec3i)blockpos);
                if (!(d1 < maxDist)) continue;
                maxDist = d1;
                continue;
            }
            if (!(placement2 instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement randomPlacement = (RandomSpreadStructurePlacement)placement2;
            list.add(Pair.of((Object)randomPlacement, (Object)((Set)entry.getValue())));
            n = Math.max(n, randomPlacement.f_204973_());
        }
        if (!list.isEmpty()) {
            int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
            int n2 = SectionPos.m_123171_((int)pos.m_123343_());
            long seed = level.m_7328_();
            StructureFeatureManager manager = level.m_8595_();
            block4: for (int k = 0; k <= maximumChunkDistance / n; ++k) {
                int outerRing = (k + 1) * n;
                int innerRing = k * n;
                boolean lessPrecision = innerRing * 16 > 2000;
                TreeMap possiblePositions = new TreeMap();
                for (Pair p : list) {
                    RandomSpreadStructurePlacement placement3 = (RandomSpreadStructurePlacement)p.getFirst();
                    int spacing = placement3.f_204973_();
                    for (int r = innerRing; r < outerRing; r += spacing) {
                        StructureLocator.addAllPossibleFeatureChunksAtDistance(chunkX, n2, r, seed, placement3, c -> {
                            List ll;
                            VectorUtils.Vec2i v = new VectorUtils.Vec2i(c.f_45578_ - chunkX, c.f_45579_ - chunkZ);
                            if (possiblePositions.containsKey(v)) {
                                boolean bl = true;
                            }
                            if ((ll = possiblePositions.computeIfAbsent(v, o -> new ArrayList())).contains(p)) {
                                boolean bl = true;
                            } else {
                                ll.add(p);
                            }
                        });
                    }
                }
                for (VectorUtils.Vec2i vec2i : possiblePositions.keySet()) {
                    ChunkPos chunkPos = new ChunkPos(vec2i.x() + chunkX, vec2i.y() + n2);
                    List structuresThatCanSpawnAtChunkPos = (List)possiblePositions.get(vec2i);
                    for (Pair pp : structuresThatCanSpawnAtChunkPos) {
                        foundStructures.addAll(StructureLocator.getFeaturesAtChunkPos((Set)pp.getSecond(), (LevelReader)level, manager, newlyGenerated, (RandomSpreadStructurePlacement)pp.getFirst(), chunkPos));
                    }
                    if (foundStructures.size() < requiredCount) continue;
                    break block4;
                }
            }
        }
        foundStructures.sort(Comparator.comparingDouble(f -> pos.m_123331_((Vec3i)f.getFirst())));
        if (foundStructures.size() >= requiredCount) {
            return (List)Lists.partition(foundStructures, (int)requiredCount).get(0);
        }
        return foundStructures;
    }

    private static void addAllPossibleFeatureChunksAtDistance(int chunkX, int chunkZ, int radius, long seed, RandomSpreadStructurePlacement placement, Consumer<ChunkPos> positionConsumer) {
        int spacing = placement.f_204973_();
        for (int j = -radius; j <= radius; ++j) {
            boolean flag = j == -radius || j == radius;
            for (int k = -radius; k <= radius; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -radius || k == radius;
                if (!flag && !flag1) continue;
                int px = chunkX + j;
                int pz = chunkZ + k;
                ChunkPos chunkpos = placement.m_204991_(seed, px, pz);
                positionConsumer.accept(chunkpos);
            }
        }
    }

    private static Set<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> getFeaturesAtChunkPos(Set<Holder<ConfiguredStructureFeature<?, ?>>> targets, LevelReader level, StructureFeatureManager featureManager, boolean newChunk, RandomSpreadStructurePlacement placement, ChunkPos chunkpos) {
        HashSet foundStructures = new HashSet();
        for (Holder<ConfiguredStructureFeature<?, ?>> holder : targets) {
            ChunkAccess chunkaccess;
            StructureStart structurestart;
            StructureCheckResult structurecheckresult = featureManager.m_207777_(chunkpos, (ConfiguredStructureFeature)holder.m_203334_(), newChunk);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!newChunk && structurecheckresult == StructureCheckResult.START_PRESENT) {
                foundStructures.add(Pair.of((Object)StructureFeature.m_204766_((RandomSpreadStructurePlacement)placement, (ChunkPos)chunkpos), holder));
            }
            if ((structurestart = featureManager.m_207802_(SectionPos.m_175562_((ChunkAccess)(chunkaccess = level.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_))), (ConfiguredStructureFeature)holder.m_203334_(), (FeatureAccess)chunkaccess)) == null || !structurestart.m_73603_()) continue;
            if (newChunk && structurestart.m_73606_()) {
                featureManager.m_196674_(structurestart);
                foundStructures.add(Pair.of((Object)StructureFeature.m_204766_((RandomSpreadStructurePlacement)placement, (ChunkPos)structurestart.m_163625_()), holder));
            }
            if (newChunk) continue;
            foundStructures.add(Pair.of((Object)StructureFeature.m_204766_((RandomSpreadStructurePlacement)placement, (ChunkPos)structurestart.m_163625_()), holder));
        }
        return foundStructures;
    }

    @Nullable
    private static Set<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> getNearestGeneratedStructureAtDistance(Set<Holder<ConfiguredStructureFeature<?, ?>>> targets, LevelReader level, StructureFeatureManager featureManager, int x, int z, int distance, boolean newChunk, long seed, RandomSpreadStructurePlacement placement) {
        int i = placement.f_204973_();
        for (int j = -distance; j <= distance; ++j) {
            boolean flag = j == -distance || j == distance;
            for (int k = -distance; k <= distance; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -distance || k == distance;
                if (!flag && !flag1) continue;
                int px = x + i * j;
                int pz = z + i * k;
                ChunkPos chunkpos = placement.m_204991_(seed, px, pz);
                return StructureLocator.getFeaturesAtChunkPos(targets, level, featureManager, newChunk, placement, chunkpos);
            }
        }
        return null;
    }

    @Nullable
    public BlockPos findRandomMapFeature(TagKey<ConfiguredStructureFeature<?, ?>> tagKey, BlockPos pos, int radius, boolean unexplored, ServerLevel level) {
        if (!level.m_142572_().m_129910_().m_5961_().m_64657_()) {
            return null;
        }
        Optional optional = level.m_5962_().m_175515_(Registry.f_122882_).m_203431_(tagKey);
        if (optional.isEmpty()) {
            return null;
        }
        HolderSet.Named o = (HolderSet.Named)optional.get();
        List list = o.m_203614_().toList();
        Holder chosen = (Holder)list.get(level.f_46441_.nextInt(list.size()));
        Pair pair = level.m_7726_().m_8481_().m_207970_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{chosen}), pos, radius, unexplored);
        return pair != null ? (BlockPos)pair.getFirst() : null;
    }
}

