/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.configs;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.quark.QuarkPlugin;
import net.mehvahdjukaar.supplementaries.mixins.MixinConfigs;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class RegistryConfigs {
    public static final String FILE_NAME = "supplementaries-registry.toml";
    public static ForgeConfigSpec REGISTRY_CONFIG;

    public static void createSpec() {
        ForgeConfigSpec.Builder REGISTRY_BUILDER = new ForgeConfigSpec.Builder();
        reg.init(REGISTRY_BUILDER);
        REGISTRY_CONFIG = REGISTRY_BUILDER.build();
    }

    public static void load() {
        CommentedFileConfig replacementConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve(FILE_NAME)).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        replacementConfig.load();
        replacementConfig.save();
        REGISTRY_CONFIG.setConfig((CommentedConfig)replacementConfig);
        reg.HAS_MINESHAFT_LANTERN = (Boolean)reg.COPPER_LANTERN_ENABLED.get();
        reg.HAS_STRONGHOLD_SCONCE = (Boolean)reg.SCONCE_ENABLED.get();
    }

    private static boolean hasMod(String ... modIds) {
        return Arrays.stream(modIds).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
    }

    public static class reg {
        public static ForgeConfigSpec.BooleanValue ASH_ENABLED;
        public static ForgeConfigSpec.BooleanValue ASH_BRICKS_ENABLED;
        public static ForgeConfigSpec.BooleanValue PLANTER_ENABLED;
        public static ForgeConfigSpec.BooleanValue CLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue PEDESTAL_ENABLED;
        public static ForgeConfigSpec.BooleanValue WIND_VANE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ILLUMINATOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue NOTICE_BOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue CRANK_ENABLED;
        public static ForgeConfigSpec.BooleanValue JAR_ENABLED;
        public static ForgeConfigSpec.BooleanValue FAUCET_ENABLED;
        public static ForgeConfigSpec.BooleanValue TURN_TABLE_ENABLED;
        public static ForgeConfigSpec.BooleanValue PISTON_LAUNCHER_ENABLED;
        public static ForgeConfigSpec.BooleanValue SPEAKER_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue SIGN_POST_ENABLED;
        public static ForgeConfigSpec.BooleanValue HANGING_SIGN_ENABLED;
        public static ForgeConfigSpec.BooleanValue BELLOWS_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_GREEN_ENABLED;
        public static ForgeConfigSpec.BooleanValue CAGE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ITEM_SHELF_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_LEVER_ENABLED;
        public static ForgeConfigSpec.BooleanValue COG_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue STONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue END_STONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue BLACKSTONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue DEEPSLATE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue GLOBE_ENABLED;
        public static ForgeConfigSpec.BooleanValue HOURGLASS_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLAG_ENABLED;
        public static ForgeConfigSpec.BooleanValue SACK_ENABLED;
        public static ForgeConfigSpec.BooleanValue BLACKBOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue SAFE_ENABLED;
        public static ForgeConfigSpec.BooleanValue COPPER_LANTERN_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLUTE_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue BAMBOO_SPIKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue TIPPED_SPIKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue CHECKERBOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue NETHERITE_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue NETHERITE_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue PANCAKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue LOCK_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLAX_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROPE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROPE_ARROW_ENABLED;
        public static ForgeConfigSpec.BooleanValue PULLEY_ENABLED;
        public static ForgeConfigSpec.BooleanValue FODDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue BOMB_ENABLED;
        public static ForgeConfigSpec.BooleanValue MAGMA_CREAM_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue CRIMSON_LANTERN_ENABLED;
        public static ForgeConfigSpec.BooleanValue DAUB_ENABLED;
        public static ForgeConfigSpec.BooleanValue WATTLE_AND_DAUB_ENABLED;
        public static ForgeConfigSpec.BooleanValue TIMBER_FRAME_ENABLED;
        public static ForgeConfigSpec.BooleanValue TILE_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOBLET_ENABLED;
        public static ForgeConfigSpec.BooleanValue RAKED_GRAVEL_ENABLED;
        public static ForgeConfigSpec.BooleanValue STATUE_ENABLED;
        public static ForgeConfigSpec.BooleanValue IRON_GATE_ENABLED;
        public static ForgeConfigSpec.BooleanValue FEATHER_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLINT_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue SLINGSHOT_ENABLED;
        public static ForgeConfigSpec.BooleanValue SHULKER_HELMET_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDY_ENABLED;
        public static ForgeConfigSpec.BooleanValue WRENCH_ENABLED;
        public static ForgeConfigSpec.BooleanValue URN_ENABLED;
        public static ForgeConfigSpec.BooleanValue ANTIQUE_INK_ENABLED;
        public static ForgeConfigSpec.BooleanValue DOORMAT_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLOWER_BOX_ENABLED;
        public static ForgeConfigSpec.BooleanValue BLACKSTONE_TILE_ENABLED;
        public static ForgeConfigSpec.BooleanValue SOAP_ENABLED;
        public static ForgeConfigSpec.BooleanValue BUBBLE_BLOWER_ENABLED;
        public static ForgeConfigSpec.BooleanValue GLOBE_SEPIA;
        public static ForgeConfigSpec.BooleanValue PRESENT_ENABLED;
        public static ForgeConfigSpec.BooleanValue STASIS_ENABLED;
        public static ForgeConfigSpec.BooleanValue SILVER_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue SILVER_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue LEAD_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue LEAD_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue DISPENSER_MINECART_ENABLED;
        public static ForgeConfigSpec.BooleanValue JAR_TAB;
        public static ForgeConfigSpec.BooleanValue CREATIVE_TAB;
        public static ForgeConfigSpec.BooleanValue DISPENSERS;
        public static ForgeConfigSpec.BooleanValue CUSTOM_CONFIGURED_SCREEN;
        public static ForgeConfigSpec.BooleanValue DEBUG_RESOURCES;
        public static boolean HAS_MINESHAFT_LANTERN;
        public static boolean HAS_STRONGHOLD_SCONCE;
        public static final Map<String, ForgeConfigSpec.BooleanValue> MIXIN_VALUES;

        public static boolean isEnabled(String path) {
            switch (path) {
                case "vertical_slabs": {
                    return CompatHandler.quark && QuarkPlugin.isVerticalSlabEnabled();
                }
                case "globe_sepia": {
                    return (Boolean)GLOBE_SEPIA.get() != false && (Boolean)ANTIQUE_INK_ENABLED.get() != false;
                }
                case "wild_flax": {
                    return (Boolean)FLAX_ENABLED.get();
                }
                case "key": {
                    return (Boolean)NETHERITE_DOOR_ENABLED.get() != false || (Boolean)NETHERITE_TRAPDOOR_ENABLED.get() != false || (Boolean)SAFE_ENABLED.get() != false;
                }
            }
            for (Field f : reg.class.getDeclaredFields()) {
                try {
                    ForgeConfigSpec.BooleanValue b;
                    String p;
                    if (!ForgeConfigSpec.BooleanValue.class.isAssignableFrom(f.getType()) || !(p = (String)(b = (ForgeConfigSpec.BooleanValue)f.get(null)).getPath().get(b.getPath().size() - 1)).equals(path)) continue;
                    return (Boolean)b.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        private static void init(ForgeConfigSpec.Builder builder) {
            builder.comment("Here are configs that need reloading to take effect");
            builder.push("general");
            CREATIVE_TAB = builder.comment("Enable Creative Tab").define("creative_tab", false);
            DISPENSERS = builder.comment("Set to false to disable custom dispenser behaviors (i.e: filling jars) if for some reason they are causing trouble").define("dispensers", true);
            JAR_TAB = builder.comment("Creates a creative tab full of filled jars").define("jar_tab", false);
            CUSTOM_CONFIGURED_SCREEN = builder.comment("Enables custom Configured config screen").define("custom_configured_screen", true);
            DEBUG_RESOURCES = builder.comment("Save generated resources to disk in a 'debug' folder in your game directory. Mainly for debug purposes but can be used to generate assets in all wood types for your mods :0").define("debug_save_dynamic_pack", false);
            builder.pop();
            builder.push("blocks");
            PLANTER_ENABLED = builder.define("planter", true);
            CLOCK_ENABLED = builder.define("clock_block", true);
            PEDESTAL_ENABLED = builder.define("pedestal", true);
            WIND_VANE_ENABLED = builder.define("wind_vane", true);
            ILLUMINATOR_ENABLED = builder.define("redstone_illuminator", true);
            NOTICE_BOARD_ENABLED = builder.define("notice_board", true);
            CRANK_ENABLED = builder.define("crank", true);
            JAR_ENABLED = builder.define("jar", true);
            FAUCET_ENABLED = builder.define("faucet", true);
            TURN_TABLE_ENABLED = builder.define("turn_table", true);
            PISTON_LAUNCHER_ENABLED = builder.define("spring_launcher", true);
            SPEAKER_BLOCK_ENABLED = builder.define("speaker_block", true);
            SIGN_POST_ENABLED = builder.define("sign_post", true);
            HANGING_SIGN_ENABLED = builder.define("hanging_sign", true);
            BELLOWS_ENABLED = builder.define("bellows", true);
            SCONCE_ENABLED = builder.define("sconce", true);
            SCONCE_GREEN_ENABLED = builder.define("sconce_green", false);
            CAGE_ENABLED = builder.define("cage", true);
            ITEM_SHELF_ENABLED = builder.define("item_shelf", true);
            SCONCE_LEVER_ENABLED = builder.define("sconce_lever", true);
            COG_BLOCK_ENABLED = builder.define("cog_block", true);
            GLOBE_ENABLED = builder.define("globe", true);
            HOURGLASS_ENABLED = builder.define("hourglass", true);
            SACK_ENABLED = builder.define("sack", true);
            BLACKBOARD_ENABLED = builder.define("blackboard", true);
            SAFE_ENABLED = builder.define("safe", true);
            COPPER_LANTERN_ENABLED = builder.define("copper_lantern", true);
            FLUTE_ENABLED = builder.define("flute", true);
            GOLD_TRAPDOOR_ENABLED = builder.define("gold_trapdoor", true);
            GOLD_DOOR_ENABLED = builder.define("gold_door", true);
            BAMBOO_SPIKES_ENABLED = builder.define("bamboo_spikes", true);
            TIPPED_SPIKES_ENABLED = builder.define("bamboo_spikes_tipped", true);
            STONE_LAMP_ENABLED = builder.define("stone_lamp", true);
            END_STONE_LAMP_ENABLED = builder.define("end_stone_lamp", true);
            BLACKSTONE_LAMP_ENABLED = builder.define("blackstone_lamp", true);
            DEEPSLATE_LAMP_ENABLED = builder.define("deepslate_lamp", true);
            CHECKERBOARD_ENABLED = builder.define("checker_block", true);
            NETHERITE_DOOR_ENABLED = builder.define("netherite_door", true);
            NETHERITE_TRAPDOOR_ENABLED = builder.define("netherite_trapdoor", true);
            PANCAKES_ENABLED = builder.define("pancake", true);
            LOCK_BLOCK_ENABLED = builder.define("lock_block", true);
            FLAX_ENABLED = builder.define("flax", true);
            ROPE_ENABLED = builder.define("rope", true);
            ROPE_ARROW_ENABLED = builder.define("rope_arrow", true);
            PULLEY_ENABLED = builder.define("pulley_block", true);
            FODDER_ENABLED = builder.define("fodder", true);
            BOMB_ENABLED = builder.define("bomb", true);
            CRIMSON_LANTERN_ENABLED = builder.define("crimson_lantern", true);
            MAGMA_CREAM_BLOCK_ENABLED = builder.define("magma_cream_block", true);
            DAUB_ENABLED = builder.define("daub", true);
            WATTLE_AND_DAUB_ENABLED = builder.define("wattle_and_daub", true);
            TIMBER_FRAME_ENABLED = builder.define("timber_frame", true);
            FLAG_ENABLED = builder.define("flag", true);
            TILE_ENABLED = builder.define("stone_tile", true);
            GOBLET_ENABLED = builder.define("goblet", true);
            RAKED_GRAVEL_ENABLED = builder.define("raked_gravel", true);
            STATUE_ENABLED = builder.define("statue", true);
            IRON_GATE_ENABLED = builder.define("iron_gate", true);
            FEATHER_BLOCK_ENABLED = builder.define("feather_block", true);
            FLINT_BLOCK_ENABLED = builder.define("flint_block", true);
            SLINGSHOT_ENABLED = builder.define("slingshot", true);
            SHULKER_HELMET_ENABLED = builder.define("shulker_shell", true);
            CANDY_ENABLED = builder.define("candy", true);
            WRENCH_ENABLED = builder.define("wrench", true);
            URN_ENABLED = builder.define("urn", true);
            ASH_ENABLED = builder.define("ash", true);
            ASH_BRICKS_ENABLED = builder.define("ash_bricks", true);
            ANTIQUE_INK_ENABLED = builder.define("antique_ink", true);
            DOORMAT_ENABLED = builder.define("doormat", true);
            FLOWER_BOX_ENABLED = builder.define("flower_box", true);
            BLACKSTONE_TILE_ENABLED = builder.define("blackstone_tile", true);
            SOAP_ENABLED = builder.define("soap", true);
            BUBBLE_BLOWER_ENABLED = builder.define("bubble_blower", true);
            GLOBE_SEPIA = builder.define("globe_sepia", true);
            PRESENT_ENABLED = builder.define("present", true);
            PRESENT_ENABLED = builder.define("statue", true);
            STASIS_ENABLED = builder.define("stasis", true);
            DISPENSER_MINECART_ENABLED = builder.define("dispenser_minecart", true);
            SILVER_TRAPDOOR_ENABLED = builder.define("silver_trapdoor", true);
            SILVER_DOOR_ENABLED = builder.define("silver_door", true);
            LEAD_TRAPDOOR_ENABLED = builder.define("lead_trapdoor", true);
            LEAD_DOOR_ENABLED = builder.define("lead_door", true);
            builder.pop();
            builder.push("entities");
            builder.pop();
            builder.comment("Here you can disable mixins if they clash with other mods ones").push("mixins");
            List<String> mixins = MixinConfigs.getMixinClassesNames();
            for (String c : mixins) {
                MIXIN_VALUES.put(c, builder.define(c.replace("Mixin", ""), true));
            }
            builder.pop();
        }

        static {
            HAS_MINESHAFT_LANTERN = false;
            HAS_STRONGHOLD_SCONCE = false;
            MIXIN_VALUES = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        }
    }
}

