/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;

public class AveragingEnergyStorage
extends MutableEnergyStorage {
    private int averageInsertion = 0;
    private int averageExtraction = 0;
    private static final double AVERAGE_DECAY_FACTOR = 0.5;

    public AveragingEnergyStorage(int capacity) {
        super(capacity);
    }

    public int receiveEnergy(int energy, boolean simulate) {
        int received = super.receiveEnergy(energy, simulate);
        if (!simulate) {
            this.averageInsertion = (int)Math.round((double)this.averageInsertion * 0.5 + (double)received * 0.5);
        }
        return received;
    }

    public int extractEnergy(int energy, boolean simulate) {
        int extracted = super.extractEnergy(energy, simulate);
        if (!simulate) {
            this.averageExtraction = (int)Math.round((double)this.averageExtraction * 0.5 + (double)extracted * 0.5);
        }
        return extracted;
    }

    public int getAverageInsertion() {
        return this.averageInsertion;
    }
}

