/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.blocks.metal.ArcFurnaceBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.gui.ArcFurnaceContainer;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;

public class ArcFurnaceScreen
extends IEContainerScreen<ArcFurnaceContainer> {
    private static final ResourceLocation TEXTURE = ArcFurnaceScreen.makeTextureLocation("arc_furnace");
    private final ArcFurnaceBlockEntity tile;
    private GuiButtonIE distributeButton;

    public ArcFurnaceScreen(ArcFurnaceContainer container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.f_97727_ = 207;
        this.tile = (ArcFurnaceBlockEntity)container.tile;
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)((Object)new EnergyInfoArea(this.f_97735_ + 157, this.f_97736_ + 22, this.tile.energyStorage)));
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        if (this.distributeButton.m_198029_()) {
            addLine.accept((Component)new TranslatableComponent("gui.immersiveengineering.config.arcfurnace.distribute"));
        }
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull PoseStack transform, float f, int mx, int my) {
        for (MultiblockProcess process : this.tile.processQueue) {
            if (!(process instanceof MultiblockProcessInMachine)) continue;
            MultiblockProcessInMachine inMachine = (MultiblockProcessInMachine)process;
            float mod = (float)process.processTick / (float)process.getMaxTicks(this.tile.m_58904_());
            int slot = inMachine.getInputSlots()[0];
            int h = (int)Math.max(1.0f, mod * 16.0f);
            this.m_93228_(transform, this.f_97735_ + 27 + slot % 3 * 21, this.f_97736_ + 34 + slot / 3 * 18 + (16 - h), 176, 16 - h, 2, h);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.distributeButton = new GuiButtonIE(this.f_97735_ + 10, this.f_97736_ + 10, 16, 16, TextComponent.f_131282_, TEXTURE, 179, 0, btn -> {
            if (((ArcFurnaceContainer)this.f_97732_).m_142621_().m_41619_()) {
                this.autoSplitStacks();
            }
        }){

            public boolean m_198029_() {
                return super.m_198029_() && ((ArcFurnaceContainer)ArcFurnaceScreen.this.f_97732_).m_142621_().m_41619_();
            }
        }.setHoverOffset(0, 16);
        this.m_142416_((GuiEventListener)this.distributeButton);
    }

    private void autoSplitStacks() {
        for (int j = 0; j < 12; ++j) {
            int emptySlot = -1;
            int largestSlot = -1;
            int largestCount = -1;
            for (int i = 0; i < 12; ++i) {
                if (((ArcFurnaceContainer)this.f_97732_).m_38853_(i).m_6657_()) {
                    int count = ((ArcFurnaceContainer)this.f_97732_).m_38853_(i).m_7993_().m_41613_();
                    if (count <= 1 || count <= largestCount) continue;
                    largestSlot = i;
                    largestCount = count;
                    continue;
                }
                if (emptySlot >= 0) continue;
                emptySlot = i;
            }
            if (emptySlot < 0 || largestSlot < 0) break;
            this.m_6597_(((ArcFurnaceContainer)this.f_97732_).m_38853_(largestSlot), largestSlot, 1, ClickType.PICKUP);
            this.m_6597_(((ArcFurnaceContainer)this.f_97732_).m_38853_(emptySlot), emptySlot, 0, ClickType.PICKUP);
        }
    }
}

