/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.mixin.accessors.client.MinecartRendererAccess;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ShaderMinecartRenderer<T extends AbstractMinecart>
extends MinecartRenderer<T> {
    public static Int2ObjectMap<ItemStack> shadedCarts = new Int2ObjectOpenHashMap();
    private final MinecartRenderer<T> baseRenderer;
    private final MinecartModel<?> baseModel;

    public ShaderMinecartRenderer(MinecartRenderer<T> base, EntityRendererProvider.Context manager) {
        super(manager, ModelLayers.f_171198_);
        this.baseRenderer = base;
        this.baseModel = this.getModel();
    }

    public void m_7392_(T entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ItemStack shader;
        ShaderCase sCase = null;
        if (shadedCarts.containsKey(entity.m_142049_()) && (shader = (ItemStack)shadedCarts.get(entity.m_142049_())) != null && !shader.m_41619_() && shader.m_41720_() instanceof IShaderItem) {
            sCase = ((IShaderItem)shader.m_41720_()).getShaderCase(shader, new ResourceLocation("immersiveengineering", "minecart"));
        }
        this.baseRenderer.m_7392_(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (sCase != null) {
            matrixStackIn.m_85836_();
            this.applyTransforms(matrixStackIn, entity, partialTicks, entityYaw);
            List boxList = this.baseModel.m_142109_().m_171331_().collect(Collectors.toList());
            ((ModelPart)boxList.get((int)5)).f_104201_ = 4.1f;
            for (int part = 0; part < boxList.size() - 1; ++part) {
                if (boxList.get(part) == null) continue;
                float scale = 1.0f;
                ShaderLayer[] layers = sCase.getLayers();
                for (int pass = 0; pass < layers.length; ++pass) {
                    if (!sCase.shouldRenderGroupForPass("" + part, pass)) continue;
                    Vector4f col = sCase.getRenderColor("" + part, pass, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_85841_(scale, scale, scale);
                    RenderType type = sCase.getLayers()[pass].getRenderType(RenderType.m_110473_((ResourceLocation)sCase.getTextureReplacement(Integer.toString(part), pass)));
                    ModelPart subModel = (ModelPart)boxList.get(part);
                    subModel.m_104306_(matrixStackIn, bufferIn.m_6299_(type), packedLightIn, OverlayTexture.f_118083_, col.m_123601_(), col.m_123615_(), col.m_123616_(), col.m_123617_());
                    matrixStackIn.m_85849_();
                }
            }
            matrixStackIn.m_85849_();
        }
    }

    private MinecartModel<?> getModel() {
        EntityModel<?> model = ((MinecartRendererAccess)this.baseRenderer).getModel();
        if (model instanceof MinecartModel) {
            return (MinecartModel)model;
        }
        return (MinecartModel)this.f_115401_;
    }

    private void applyTransforms(PoseStack matrixStackIn, T entityIn, float partialTicks, float entityYaw) {
        long i = (long)entityIn.m_142049_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        matrixStackIn.m_85837_((double)f, (double)f1, (double)f2);
        double d0 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)entityIn).f_19790_, (double)entityIn.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)entityIn).f_19791_, (double)entityIn.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)entityIn).f_19792_, (double)entityIn.m_20189_());
        Vec3 vec3d = entityIn.m_38179_(d0, d1, d2);
        float f3 = Mth.m_14179_((float)partialTicks, (float)((AbstractMinecart)entityIn).f_19860_, (float)entityIn.m_146909_());
        if (vec3d != null) {
            Vec3 vec3d1 = entityIn.m_38096_(d0, d1, d2, (double)0.3f);
            Vec3 vec3d2 = entityIn.m_38096_(d0, d1, d2, (double)-0.3f);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            matrixStackIn.m_85837_(vec3d.f_82479_ - d0, (vec3d1.f_82480_ + vec3d2.f_82480_) / 2.0 - d1, vec3d.f_82481_ - d2);
            Vec3 vec3d3 = vec3d2.m_82520_(-vec3d1.f_82479_, -vec3d1.f_82480_, -vec3d1.f_82481_);
            if (vec3d3.m_82553_() != 0.0) {
                vec3d3 = vec3d3.m_82541_();
                entityYaw = (float)(Math.atan2(vec3d3.f_82481_, vec3d3.f_82479_) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec3d3.f_82480_) * 73.0);
            }
        }
        matrixStackIn.m_85837_(0.0, 0.375, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-f3));
        float f5 = (float)entityIn.m_38176_() - partialTicks;
        float f6 = entityIn.m_38169_() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f5) * f5 * f6 / 10.0f * (float)entityIn.m_38177_()));
        }
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
    }

    public static void overrideMinecartModels() {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher rendererManager = mc.m_91290_();
        HashMap mutableRenderers = new HashMap(rendererManager.f_114362_);
        for (Map.Entry entry : rendererManager.f_114362_.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof MinecartRenderer)) continue;
            MinecartRenderer minecartRender = (MinecartRenderer)v;
            mutableRenderers.put((EntityType)entry.getKey(), new ShaderMinecartRenderer(minecartRender, new EntityRendererProvider.Context(rendererManager, mc.m_91291_(), mc.m_91098_(), mc.m_167973_(), mc.f_91062_)));
        }
        rendererManager.f_114362_ = ImmutableMap.copyOf(mutableRenderers);
    }
}

