/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.IListRecipe;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingCalculator;
import blusunrize.immersiveengineering.common.crafting.PotionRecipeGenerators;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class GeneratedListRecipe
extends IESerializableRecipe
implements IListRecipe {
    public static Map<ResourceLocation, RecipeListGenerator<?>> LIST_GENERATORS = new HashMap();
    public static RegistryObject<IERecipeSerializer<GeneratedListRecipe>> SERIALIZER;
    @Nullable
    private List<? extends IESerializableRecipe> cachedRecipes;
    private final RecipeListGenerator<?> generator;

    public static void init() {
        LIST_GENERATORS.put(ImmersiveEngineering.rl("mixer_potion_list"), new RecipeListGenerator<MixerRecipe>(PotionRecipeGenerators::initPotionRecipes, MixerRecipe.SERIALIZER.getId(), MixerRecipe.TYPE));
        LIST_GENERATORS.put(ImmersiveEngineering.rl("potion_bottling_list"), new RecipeListGenerator<BottlingMachineRecipe>(PotionRecipeGenerators::getPotionBottlingRecipes, BottlingMachineRecipe.SERIALIZER.getId(), BottlingMachineRecipe.TYPE));
        LIST_GENERATORS.put(ImmersiveEngineering.rl("arc_recycling_list"), new RecipeListGenerator<ArcFurnaceRecipe>(ArcRecyclingCalculator::getRecipesFromRunningThreads, ArcFurnaceRecipe.SERIALIZER.getId(), ArcFurnaceRecipe.TYPE));
    }

    public GeneratedListRecipe(ResourceLocation id) {
        super((Lazy<ItemStack>)LAZY_EMPTY, ((RecipeListGenerator)Preconditions.checkNotNull(GeneratedListRecipe.LIST_GENERATORS.get((Object)id), (Object)id)).recipeType, id);
        this.generator = LIST_GENERATORS.get(id);
    }

    public GeneratedListRecipe(ResourceLocation id, @Nullable List<IESerializableRecipe> subRecipes) {
        this(id);
        this.cachedRecipes = subRecipes;
    }

    protected IERecipeSerializer<GeneratedListRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_5598_() {
        return true;
    }

    @Override
    public List<? extends IESerializableRecipe> getSubRecipes() {
        if (this.cachedRecipes == null) {
            this.cachedRecipes = this.generator.generator.get();
        }
        return this.cachedRecipes;
    }

    public ResourceLocation getSubSerializer() {
        return this.generator.serialized;
    }

    public static class RecipeListGenerator<T extends IESerializableRecipe> {
        private final Supplier<List<T>> generator;
        private final ResourceLocation serialized;
        private final RecipeType<T> recipeType;

        public RecipeListGenerator(Supplier<List<T>> generator, ResourceLocation serializer, RecipeType<T> recipeType) {
            this.generator = generator;
            this.serialized = serializer;
            this.recipeType = recipeType;
        }
    }
}

