/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.mixin.accessors.PotionBrewingAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class PotionHelper {
    public static FluidTagInput getFluidTagForType(Potion type, int amount) {
        if (type == Potions.f_43599_ || type == null) {
            return new FluidTagInput((TagKey<Fluid>)FluidTags.f_13131_, amount);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Potion", type.getRegistryName().toString());
        return new FluidTagInput(IETags.fluidPotion, amount, nbt);
    }

    public static void applyToAllPotionRecipes(PotionRecipeProcessor out) {
        for (PotionBrewing.Mix<Potion> mixPredicate : PotionBrewingAccess.getConversions()) {
            if (mixPredicate.f_43534_.get() == Potions.f_43600_ || mixPredicate.f_43534_.get() == Potions.f_43601_) continue;
            out.apply((Potion)mixPredicate.f_43534_.get(), (Potion)mixPredicate.f_43532_.get(), new IngredientWithSize(mixPredicate.f_43533_));
        }
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            IngredientWithSize ingredient = new IngredientWithSize(((BrewingRecipe)recipe).getIngredient());
            Ingredient input = ((BrewingRecipe)recipe).getInput();
            ItemStack output = ((BrewingRecipe)recipe).getOutput();
            if (output.m_41720_() != Items.f_42589_) continue;
            out.apply(PotionUtils.m_43579_((ItemStack)output), PotionUtils.m_43579_((ItemStack)input.m_43908_()[0]), ingredient);
        }
    }

    public static interface PotionRecipeProcessor {
        public void apply(Potion var1, Potion var2, IngredientWithSize var3);
    }
}

