/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public record ArrayFluidHandler(IFluidTank[] internal, boolean allowDrain, boolean allowFill, Runnable afterTransfer) implements IFluidHandler
{
    public int getTanks() {
        return this.internal.length;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.internal[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.internal[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.internal[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.allowFill || resource.isEmpty()) {
            return 0;
        }
        FluidStack remaining = resource.copy();
        for (IFluidTank tank : this.internal) {
            int filledHere = tank.fill(remaining, action);
            remaining.shrink(filledHere);
            if (remaining.isEmpty()) break;
        }
        if (resource.getAmount() != remaining.getAmount()) {
            this.afterTransfer.run();
        }
        return resource.getAmount() - remaining.getAmount();
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.allowDrain) {
            return FluidStack.EMPTY;
        }
        for (IFluidTank tank : this.internal) {
            FluidStack drainedHere = tank.drain(resource, action);
            if (drainedHere.isEmpty()) continue;
            this.afterTransfer.run();
            return drainedHere;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.allowDrain) {
            return FluidStack.EMPTY;
        }
        for (IFluidTank tank : this.internal) {
            FluidStack drainedHere = tank.drain(maxDrain, action);
            if (drainedHere.isEmpty()) continue;
            this.afterTransfer.run();
            return drainedHere;
        }
        return FluidStack.EMPTY;
    }
}

