/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageStoredEnergy;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record MessageRequestEnergyUpdate(FastEither<BlockPos, Integer> pos) implements IMessage
{
    public MessageRequestEnergyUpdate(FriendlyByteBuf buf) {
        this(MessageRequestEnergyUpdate.readPos(buf));
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        MessageRequestEnergyUpdate.writePos(buf, this.pos);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            IEnergyStorage energyCap;
            ServerLevel level = Objects.requireNonNull(ctx.getSender()).m_183503_();
            Object provider = this.pos.isLeft() ? SafeChunkUtils.getSafeBE((LevelAccessor)level, this.pos.leftNonnull()) : level.m_6815_(this.pos.rightNonnull().intValue());
            VoltmeterItem.RemoteEnergyData data = null;
            if (provider != null && (energyCap = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)provider, CapabilityEnergy.ENERGY)) != null && energyCap.getMaxEnergyStored() > 0) {
                data = new VoltmeterItem.RemoteEnergyData(this.pos, level.m_46467_(), true, energyCap.getEnergyStored(), energyCap.getMaxEnergyStored());
            }
            if (data == null) {
                data = new VoltmeterItem.RemoteEnergyData(this.pos, level.m_46467_(), false, 0, 0);
            }
            ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)ctx).getSender()), (Object)new MessageStoredEnergy(data));
        });
    }

    public static FastEither<BlockPos, Integer> readPos(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return FastEither.right(buf.readInt());
        }
        return FastEither.left(buf.m_130135_());
    }

    public static void writePos(FriendlyByteBuf out, FastEither<BlockPos, Integer> pos) {
        out.writeBoolean(pos.isRight());
        if (pos.isRight()) {
            out.writeInt(pos.rightNonnull().intValue());
        } else {
            out.m_130064_(pos.leftNonnull());
        }
    }
}

