/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.IELogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class MessageSetGhostSlots
implements IMessage {
    private final Int2ObjectMap<ItemStack> stacksToSet;

    public MessageSetGhostSlots(Int2ObjectMap<ItemStack> stacksToSet) {
        this.stacksToSet = stacksToSet;
    }

    public MessageSetGhostSlots(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.stacksToSet = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            int slot = buf.readInt();
            this.stacksToSet.put(slot, (Object)buf.m_130267_());
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.stacksToSet.size());
        for (Int2ObjectMap.Entry e : this.stacksToSet.int2ObjectEntrySet()) {
            buf.writeInt(e.getIntKey());
            buf.m_130055_((ItemStack)e.getValue());
        }
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ServerPlayer player = ctx.getSender();
        assert (player != null);
        ctx.enqueueWork(() -> {
            AbstractContainerMenu container = player.f_36096_;
            if (container != null) {
                for (Int2ObjectMap.Entry e : this.stacksToSet.int2ObjectEntrySet()) {
                    int slot = e.getIntKey();
                    if (slot < 0 || slot >= container.f_38839_.size()) continue;
                    Slot target = (Slot)container.f_38839_.get(slot);
                    if (!(target instanceof IESlot.ItemHandlerGhost)) {
                        IELogger.error("Player " + player.m_5446_() + " tried to set the contents of a non-ghost slot.This is either a bug in IE or an attempt at cheating.");
                        return;
                    }
                    container.m_182406_(slot, container.m_182424_(), (ItemStack)e.getValue());
                }
            }
        });
    }
}

