/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic.impl;

import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackEnvironment;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerCallable;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.IndexArgument;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public class InventoryCallbacks<T>
extends Callback<T> {
    private final Function<T, List<ItemStack>> getStacks;
    private final String desc;

    public InventoryCallbacks(Function<T, List<ItemStack>> getStacks, String desc) {
        this.getStacks = getStacks;
        this.desc = desc;
    }

    public InventoryCallbacks(Function<T, List<ItemStack>> getAllStacks, int begin, int count, String desc) {
        this(getAllStacks.andThen(l -> l.subList(begin, begin + count)), desc);
    }

    @Override
    public String renameMethod(String javaName) {
        return javaName.replace("Desc", InventoryCallbacks.capitalize(this.desc));
    }

    @ComputerCallable
    public int getDescSlotCount(CallbackEnvironment<T> env) {
        return this.getStacks.apply(env.object()).size();
    }

    @ComputerCallable
    public ItemStack getDescStack(CallbackEnvironment<T> env, @IndexArgument int index) {
        List<ItemStack> stacks = this.getStacks.apply(env.object());
        if (index < 0 || index >= stacks.size()) {
            throw new RuntimeException("Index is out of bounds, only " + stacks.size() + " " + this.desc + " slots are available");
        }
        return stacks.get(index);
    }
}

