/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.registry;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import top.theillusivec4.champions.common.entity.ArcticBulletEntity;
import top.theillusivec4.champions.common.entity.EnkindlingBulletEntity;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.particle.RankParticle;
import top.theillusivec4.champions.common.potion.ParalysisEffect;
import top.theillusivec4.champions.common.potion.WoundEffect;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;

@Mod.EventBusSubscriber(modid="champions", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEventsHandler {
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{new ChampionEggItem()});
    }

    @SubscribeEvent
    public static void registerParticleTypes(RegistryEvent.Register<ParticleType<?>> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)((ParticleType)new SimpleParticleType(false).setRegistryName("champions:rank")));
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent evt) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ChampionsRegistry.RANK, RankParticle.RankFactory::new);
    }

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<MobEffect> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new MobEffect[]{new ParalysisEffect(), new WoundEffect()});
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> evt) {
        EntityType arcticBullet = (EntityType)EntityType.Builder.m_20704_((type, world) -> new ArcticBulletEntity(world), (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).setCustomClientFactory((spawnEntity, world) -> new ArcticBulletEntity((Level)world)).m_20712_("champions:arctic_bullet").setRegistryName("champions:arctic_bullet");
        EntityType enkindlingBullet = (EntityType)EntityType.Builder.m_20704_((type, world) -> new EnkindlingBulletEntity(world), (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).setCustomClientFactory((spawnEntity, world) -> new EnkindlingBulletEntity((Level)world)).m_20712_("champions:enkindling_bullet").setRegistryName("champions:enkindling_bullet");
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{arcticBullet, enkindlingBullet});
    }
}

