/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EachArmorRenderer
extends ArmorRenderer {
    public EachArmorRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        boolean right;
        int i = 5;
        float scale = (float)this.armScale / 100.0f;
        mat.m_85836_();
        mat.m_85837_(0.0, 0.0, -320.0);
        for (ItemStack item : this.mc.f_91074_.m_20158_()) {
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            if (!this.showArmor && i < 4) {
                --i;
                continue;
            }
            int x = this.getX(width, (int)(16.0f * scale), this.items[i].x, this.items[i].aligns.HorAlign);
            int y = this.getY(height, (int)(16.0f * scale), this.items[i].y, this.items[i].aligns.VertAlign);
            right = this.getRight(this.items[i].x, this.items[i].aligns.HorAlign);
            int Damage = ArmorStatus.GetDamage(item);
            String text = null;
            if (Damage >= 0 && Damage <= this.armAbove) {
                if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    switch (this.armView) {
                        case PERCENTAGE: {
                            text = this.getDamageText(String.valueOf(Damage), Damage);
                            break;
                        }
                        case DAMAGE: {
                            text = this.getDamageText(String.valueOf(item.m_41773_()), Damage);
                            break;
                        }
                        case DAMAGE_LEFT: {
                            text = this.getDamageText(String.valueOf(item.m_41776_() - item.m_41773_()), Damage);
                        }
                    }
                }
                this.pushAndRender(mat, x, y, !right, null, item, text, this.armBars, scale);
            } else if (Damage == -2) {
                String t = null;
                boolean over = true;
                if ((i == 5 || i == 4) && this.showCount) {
                    t = "" + this.getItemCount(item);
                    over = false;
                }
                this.pushAndRender(mat, x, y, !right, null, item, t, over, scale);
            } else if (this.showEmpty) {
                this.pushAndRender(mat, x, y, !right, this.armorRL[i], null, null, false, scale);
            }
            --i;
        }
        if (this.showArrows || this.showInv) {
            int count = 0;
            int arrows = 0;
            for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35974_) {
                if (slot.m_41619_()) {
                    ++count;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.m_41613_();
            }
            if (this.showInv) {
                int x = this.getX(width, (int)(16.0f * scale), this.items[6].x, this.items[6].aligns.HorAlign);
                int y = this.getY(height, (int)(16.0f * scale), this.items[6].y, this.items[6].aligns.VertAlign);
                right = this.getRight(this.items[6].x, this.items[6].aligns.HorAlign);
                this.pushAndRender(mat, x, y, !right, this.armorRL[6], null, "" + count, false, scale);
            }
            if (this.showArrows) {
                int x = this.getX(width, (int)(16.0f * scale), this.items[7].x, this.items[7].aligns.HorAlign);
                int y = this.getY(height, (int)(16.0f * scale), this.items[7].y, this.items[7].aligns.VertAlign);
                right = this.getRight(this.items[7].x, this.items[7].aligns.HorAlign);
                this.pushAndRender(mat, x, y, !right, this.armorRL[7], null, "" + arrows, false, scale);
            }
        }
        mat.m_85849_();
    }

    private void pushAndRender(PoseStack mat, int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale) {
        mat.m_85836_();
        mat.m_85837_((double)x, (double)y, 0.0);
        mat.m_85841_(scale, scale, 1.0f);
        this.renderElement(mat, x, y, scale, right, resourceLocation, itemStack, text, over);
        mat.m_85849_();
    }
}

