/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class CustomOptionList
extends AbstractSelectionList {
    private static final int ITEM_HEIGHT = 30;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final Screen parent;
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private final ResourceLocation SCROLL = new ResourceLocation("inventoryhud", "textures/gui/scroll.png");

    public CustomOptionList(Minecraft p_i51130_1_, Screen screen) {
        super(p_i51130_1_, screen.f_96543_, screen.f_96544_, 55, screen.f_96544_ - 32, 30);
        this.parent = screen;
    }

    public void addWidget(Widget widget, int row) {
        if (this.maxHeight < (row + 1) * 30 + 10) {
            this.maxHeight = (row + 1) * 30 + 10;
        }
        widget.y = this.f_93390_ + 10 + 30 * row + widget.y;
        this.widgets.add(widget);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public boolean m_6050_(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        double tmp = 0.0;
        if (this.maxHeight > this.f_93391_ - this.f_93390_) {
            tmp = p_231043_5_ * 5.0;
            int diff = this.maxHeight - (this.f_93391_ - this.f_93390_);
            this.scroll = (int)((double)this.scroll - tmp);
            if (this.scroll < 0) {
                tmp += (double)this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp += (double)(this.scroll - diff);
                this.scroll = diff;
            }
        }
        for (Widget w : this.widgets) {
            if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                ((NumericTextField)w).setFocused2(false);
            }
            w.y = (int)((double)w.y + tmp);
        }
        return true;
    }

    public boolean m_7979_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.isDragging) {
            int height = this.f_93391_ - this.f_93390_;
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += p_231045_8_ / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.f_93391_ - this.f_93390_);
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            for (Widget w : this.widgets) {
                if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                    ((NumericTextField)w).setFocused2(false);
                }
                w.y -= tmp;
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (!this.m_5953_(p_231044_1_, p_231044_3_)) {
            return false;
        }
        if (this.maxHeight > this.f_93391_ - this.f_93390_ && p_231044_5_ == 0) {
            int pos = this.f_93388_ > 309 ? this.f_93388_ / 2 + 150 : this.f_93388_ - 9;
            int height = this.f_93391_ - this.f_93390_;
            double scale = (double)height / (double)this.maxHeight;
            int yPos = this.f_93390_ + (int)((double)this.scroll * scale);
            if (this.isOver(p_231044_1_, p_231044_3_, pos + 1, pos + 8, yPos + 1, yPos + (height = (int)((double)height * scale)) - 1)) {
                this.isDragging = true;
            }
        }
        for (Widget w : this.widgets) {
            if (!w.hovered && !(w instanceof NumericTextField)) continue;
            w.m_6375_(p_231044_1_, p_231044_3_, p_231044_5_);
        }
        return false;
    }

    public boolean m_6348_(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        this.isDragging = false;
        return false;
    }

    public boolean m_5534_(char p_231042_1_, int p_231042_2_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof NumericTextField) || !((NumericTextField)w).isFocused()) continue;
            w.m_5534_(p_231042_1_, p_231042_2_);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof NumericTextField) || !((NumericTextField)w).isFocused()) continue;
            w.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
            return true;
        }
        super.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
        return false;
    }

    private void renderScrollBG(PoseStack mat, int xPos, int height) {
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)this.f_93390_, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)this.f_93390_, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(this.f_93391_ - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(this.f_93391_ - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)this.f_93390_, (int)3, (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(this.f_93390_ + 3), (int)3, (int)(height - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(this.f_93391_ - 3), (int)3, (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(this.f_93390_ + 3), (int)3, (int)(height - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(this.f_93390_ + 3), (int)3, (int)(height - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private void renderScroll(PoseStack mat, int xPos, int height, int pos) {
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)pos, (int)3, (int)3, (float)16.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)pos, (int)3, (int)3, (float)29.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(-3 + height + pos), (int)3, (int)3, (float)16.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(-3 + height + pos), (int)3, (int)3, (float)29.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)pos, (int)3, (int)3, (float)19.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)29.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(-3 + height + pos), (int)3, (int)3, (float)19.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)16.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)19.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    protected void m_93451_(PoseStack p_238478_1_, int p_238478_2_, int p_238478_3_, int p_238478_4_, int p_238478_5_, float p_238478_6_) {
        if (this.maxHeight > this.f_93391_ - this.f_93390_) {
            int pos = this.f_93388_ > 309 ? this.f_93388_ / 2 + 150 : this.f_93388_ - 9;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.SCROLL);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            int height = this.f_93391_ - this.f_93390_;
            this.renderScrollBG(p_238478_1_, pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.f_93390_ + (int)((double)this.scroll * scale);
            RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            if (this.isOver(p_238478_4_, p_238478_5_, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.renderScroll(p_238478_1_, pos, height, yPos);
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (Widget w : this.widgets) {
            w.m_6305_(p_238478_1_, p_238478_4_, p_238478_5_, p_238478_6_);
        }
    }

    public void renderTooltips(PoseStack mat, int x, int y) {
        if (y > this.f_93391_ || y < this.f_93390_ || x > this.f_93392_ || x < this.f_93393_) {
            return;
        }
        for (Widget w : this.widgets) {
            w.renderTooltip(mat, x, y);
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

