/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dlovin.inventoryhud.gui.widgets.Widget;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NumericTextField
extends Widget {
    protected final IPressable onChange;
    private final Font fontRenderer;
    private String text;
    private int maxStringLength = 32;
    private final boolean enableBackgroundDrawing = true;
    private final boolean isEnabled = true;
    private boolean isFocused;
    private boolean field_212956_h;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private final int minValue;
    private final int maxValue;
    private final int defValue;
    private String prevText;
    private final ResourceLocation BG = new ResourceLocation("inventoryhud", "textures/gui/tf_bg.png");
    private Predicate<String> validator = Objects::nonNull;
    private final BiFunction<String, Integer, String> textFormatter = (p_195610_0_, p_195610_1_) -> p_195610_0_;

    public NumericTextField(Font p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, int minValue, int maxValue, int defValue, IPressable onChange) {
        super(p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, "" + defValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defValue = defValue;
        this.prevText = "" + defValue;
        this.text = this.prevText;
        this.fontRenderer = p_i232260_1_;
        this.onChange = onChange;
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void writeText(String textToWrite) {
        Object s1;
        int l;
        int i;
        block7: {
            String s;
            i = Math.min(this.cursorPosition, this.selectionEnd);
            int j = Math.max(this.cursorPosition, this.selectionEnd);
            int k = this.maxStringLength - this.text.length() - (i - j);
            if (k < (l = (s = SharedConstants.m_136190_((String)textToWrite)).length())) {
                s = s.substring(0, k);
                l = k;
            }
            s1 = new StringBuilder(this.text).replace(i, j, s).toString();
            try {
                int num = Integer.parseInt((String)s1);
                s1 = "" + num;
                if (num < this.minValue) {
                    s1 = "" + this.minValue;
                } else if (num > this.maxValue) {
                    s1 = "" + this.maxValue;
                }
            }
            catch (NumberFormatException ex) {
                if (s.equalsIgnoreCase("-")) break block7;
                s1 = this.prevText;
            }
        }
        if (this.validator.test((String)s1)) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        if (!newText.equals(this.prevText) && this.isNumeric(newText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    private void delete(int p_212950_1_) {
        if (Screen.m_96637_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.func_238516_r_(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.func_238516_r_(num));
    }

    private int func_238516_r_(int p_238516_1_) {
        return Util.m_137479_((String)this.text, (int)this.cursorPosition, (int)p_238516_1_);
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.field_212956_h) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = this.clamp(pos, 0, this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.field_212956_h = Screen.m_96638_();
        if (Screen.m_96634_((int)p_231046_1_)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.m_96632_((int)p_231046_1_)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            return true;
        }
        if (Screen.m_96630_((int)p_231046_1_)) {
            Objects.requireNonNull(this);
            if (this.isNumeric(Minecraft.m_91087_().f_91068_.m_90876_())) {
                this.writeText(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)p_231046_1_)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            Objects.requireNonNull(this);
            this.writeText("");
            return true;
        }
        switch (p_231046_1_) {
            case 256: {
                this.setFocused2(false);
                return true;
            }
            case 259: {
                Objects.requireNonNull(this);
                this.field_212956_h = false;
                this.delete(-1);
                this.field_212956_h = Screen.m_96638_();
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                Objects.requireNonNull(this);
                this.field_212956_h = false;
                this.delete(1);
                this.field_212956_h = Screen.m_96638_();
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.getVisible() && this.isFocused() && this.isEnabled();
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public boolean m_5534_(char p_231042_1_, int p_231042_2_) {
        if (!this.canWrite()) {
            return false;
        }
        if (this.isNumeric(Character.toString(p_231042_1_))) {
            Objects.requireNonNull(this);
            this.writeText(Character.toString(p_231042_1_));
            return true;
        }
        if (p_231042_1_ == '-') {
            if (!this.getText().contains("-") && this.cursorPosition == 0) {
                Objects.requireNonNull(this);
                this.writeText(Character.toString(p_231042_1_));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (!this.getVisible()) {
            return false;
        }
        boolean flag = p_231044_1_ >= (double)this.x && p_231044_1_ < (double)(this.x + this.width) && p_231044_3_ >= (double)this.y && p_231044_3_ < (double)(this.y + this.height);
        boolean canLoseFocus = true;
        if (canLoseFocus) {
            this.setFocused2(flag);
        }
        if (this.isFocused() && flag && p_231044_5_ == 0) {
            int i = this.floor(p_231044_1_) - this.x;
            Objects.requireNonNull(this);
            String s = this.fontRenderer.m_92834_(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.m_92834_(s, i -= 4).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.field_212956_h = false;
            this.setCursorPosition(0);
            if (!this.isNumeric(this.text) || this.text.equals("")) {
                this.setText("" + this.defValue);
            }
        }
    }

    @Override
    public void m_6305_(PoseStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
        super.m_6305_(p_230431_1_, p_230431_2_, p_230431_3_, p_230431_4_);
        if (this.getVisible()) {
            Minecraft mc = Minecraft.m_91087_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.BG);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            if (this.isFocused()) {
                this.renderBtnBg(p_230431_1_, 0, 16);
            } else if (this.hovered) {
                this.renderBtnBg(p_230431_1_, 16, 0);
            } else {
                this.renderBtnBg(p_230431_1_, 0, 0);
            }
            RenderSystem.m_69461_();
            int enabledColor = 0xE0E0E0;
            int disabledColor = 0x707070;
            Objects.requireNonNull(this);
            int i2 = enabledColor;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String s = this.fontRenderer.m_92834_(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isFocused() && flag;
            Objects.requireNonNull(this);
            int l = this.x + 4;
            Objects.requireNonNull(this);
            int i1 = this.y + (this.height - 8) / 2;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.fontRenderer.m_92750_(p_230431_1_, this.textFormatter.apply(s1, this.lineScrollOffset), (float)l, (float)i1, i2);
            }
            boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                this.fontRenderer.m_92750_(p_230431_1_, this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)j1, (float)i1, i2);
            }
            if (flag1) {
                if (flag2) {
                    NumericTextField.m_93172_((PoseStack)p_230431_1_, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
                } else {
                    this.fontRenderer.m_92750_(p_230431_1_, "_", (float)k1, (float)i1, i2);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.m_92895_(s.substring(0, k));
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_5483_((double)startX, (double)endY, 0.0).m_5752_();
        bufferbuilder.m_5483_((double)endX, (double)endY, 0.0).m_5752_();
        bufferbuilder.m_5483_((double)endX, (double)startY, 0.0).m_5752_();
        bufferbuilder.m_5483_((double)startX, (double)startY, 0.0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private boolean getEnableBackgroundDrawing() {
        Objects.requireNonNull(this);
        return true;
    }

    @Override
    public boolean m_5755_(boolean p_231049_1_) {
        Objects.requireNonNull(this);
        return super.m_5755_(p_231049_1_);
    }

    @Override
    public boolean m_5953_(double p_231047_1_, double p_231047_3_) {
        return p_231047_1_ >= (double)this.x && p_231047_1_ < (double)(this.x + this.width) && p_231047_3_ >= (double)this.y && p_231047_3_ < (double)(this.y + this.height);
    }

    private boolean isEnabled() {
        Objects.requireNonNull(this);
        return true;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = this.clamp(position, 0, i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.m_92834_(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.m_92837_(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = this.clamp(this.lineScrollOffset, 0, i);
        }
    }

    public boolean getVisible() {
        return true;
    }

    public void setX(int xIn) {
        this.x = xIn;
    }

    private void renderBtnBg(PoseStack mat, int offsetX, int offsetY) {
        NumericTextField.m_93160_((PoseStack)mat, (int)this.x, (int)this.y, (int)2, (int)2, (float)offsetX, (float)offsetY, (int)2, (int)2, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)(this.x + this.width - 2), (int)this.y, (int)2, (int)2, (float)(14 + offsetX), (float)offsetY, (int)2, (int)2, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)this.x, (int)(this.y + this.height - 2), (int)2, (int)2, (float)offsetX, (float)(14 + offsetY), (int)2, (int)2, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)(this.x + this.width - 2), (int)(this.y + this.height - 2), (int)2, (int)2, (float)(14 + offsetX), (float)(14 + offsetY), (int)2, (int)2, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)(this.x + 2), (int)this.y, (int)(this.width - 4), (int)2, (float)(2 + offsetX), (float)offsetY, (int)12, (int)2, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)(this.x + this.width - 2), (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)(14 + offsetX), (float)(2 + offsetY), (int)2, (int)12, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)(this.x + 2), (int)(this.y + this.height - 2), (int)(this.width - 4), (int)2, (float)(2 + offsetX), (float)(14 + offsetY), (int)12, (int)2, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)this.x, (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)offsetX, (float)(2 + offsetY), (int)2, (int)12, (int)32, (int)32);
        NumericTextField.m_93160_((PoseStack)mat, (int)(this.x + 2), (int)(this.y + 2), (int)(this.width - 4), (int)(this.height - 4), (float)(2 + offsetX), (float)(2 + offsetY), (int)12, (int)12, (int)32, (int)32);
    }

    private boolean isNumeric(String text) {
        if (text == null) {
            return false;
        }
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onChanged(NumericTextField var1);
    }
}

